/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle;

import java.util.ArrayList;
import java.util.List;

public class PegasusOptions {
    public Mode mode;
    public IdlOptions idlOptions = new IdlOptions();
    public ClientOptions clientOptions = new ClientOptions();

    public static class ClientOptions {
        private List<ClientItem> clientOptionsList = new ArrayList<ClientItem>();

        public void addClientItem(String inRestModelFileName, String inDefaultPackage, boolean inKeepDataTemplates) {
            ClientItem newItem = new ClientItem(inRestModelFileName, inDefaultPackage, inKeepDataTemplates);
            this.clientOptionsList.add(newItem);
        }

        public void addClientItem(String inRestModelFileName) {
            ClientItem newItem = new ClientItem(inRestModelFileName, "", false);
            this.clientOptionsList.add(newItem);
        }

        public boolean hasRestModelFileName(String fileName) {
            for (ClientItem item : this.clientOptionsList) {
                if (!item.restModelFileName.equals(fileName)) continue;
                return true;
            }
            return false;
        }

        public List<ClientItem> getClientItems() {
            return this.clientOptionsList;
        }
    }

    public static class ClientItem {
        String defaultPackage;
        String restModelFileName;
        boolean keepDataTemplates = false;

        public ClientItem(String inRestModelFileName, String inDefaultPackage, boolean inKeepDataTemplates) {
            this.restModelFileName = inRestModelFileName;
            this.defaultPackage = inDefaultPackage;
            this.keepDataTemplates = inKeepDataTemplates;
        }
    }

    public static class IdlOptions {
        private List<IdlItem> _idlOptionsList = new ArrayList<IdlItem>();

        public void addIdlItem(String inApiName, List<String> inPackageNames) {
            IdlItem newItem = new IdlItem(inApiName, inPackageNames);
            this._idlOptionsList.add(newItem);
        }

        public void addIdlItem(List<String> inPackageNames) {
            IdlItem newItem = new IdlItem("", inPackageNames);
            this._idlOptionsList.add(newItem);
        }

        public List<IdlItem> getIdlItems() {
            return this._idlOptionsList;
        }
    }

    public static class IdlItem {
        String apiName;
        String[] packageNames;

        public IdlItem(String inApiName, List<String> inPackageNames) {
            this.apiName = inApiName;
            this.packageNames = inPackageNames.toArray(new String[0]);
        }
    }

    public static enum Mode {
        AVRO,
        PEGASUS;

    }
}

