/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle;

import com.linkedin.pegasus.gradle.FileCompatibilityType;
import org.gradle.api.Project;

public class PropertyUtil {
    public static String findCompatLevel(Project project, FileCompatibilityType type) {
        return PropertyUtil.findCompatLevel(project, PropertyUtil.findProperty(type));
    }

    public static String findProperty(FileCompatibilityType type) {
        switch (type) {
            case SNAPSHOT: {
                return "rest.model.compatibility";
            }
            case IDL: {
                return "rest.idl.compatibility";
            }
        }
        return null;
    }

    public static String findCompatLevel(Project project, String propertyName) {
        if (project.hasProperty(propertyName)) {
            String compatLevel = project.property(propertyName).toString().toUpperCase();
            if (compatLevel.equals("OFF")) {
                return "IGNORE";
            }
            return compatLevel;
        }
        if (propertyName.equals("rest.model.compatibility")) {
            return "BACKWARDS";
        }
        return "OFF";
    }
}

