/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle;

import com.linkedin.pegasus.gradle.ClasspathManifest;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class PathingJarUtil {
    private static final Logger LOG = Logging.getLogger(PathingJarUtil.class);

    public static FileCollection generatePathingJar(Project project, String taskName, FileCollection classpath) throws IOException {
        if (!classpath.filter(f -> f.getAbsolutePath().contains("restli-tools-scala")).isEmpty()) {
            LOG.info("Compiling Scala resource classes. Disabling pathing jar for " + taskName + " to avoid breaking Scala compilation");
            return classpath;
        }
        FileCollection filteredClasspath = classpath.filter(f -> !f.isDirectory());
        File destinationDir = new File(project.getBuildDir(), taskName);
        destinationDir.mkdirs();
        File pathingJarPath = new File(destinationDir, project.getName() + "-pathing.jar");
        FileOutputStream pathingJar = new FileOutputStream(pathingJarPath);
        String cp = ClasspathManifest.relativeClasspathManifest(destinationDir, filteredClasspath.getFiles());
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.CLASS_PATH, cp);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)pathingJar, manifest);
        jarOutputStream.close();
        return classpath.filter(File::isDirectory).plus((FileCollection)project.files(new Object[]{pathingJarPath}));
    }
}

