/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;

public class ChangedFileReportTask
extends DefaultTask {
    @InputFiles
    @SkipWhenEmpty
    FileCollection idlFiles = this.getProject().files(new Object[0]);
    @InputFiles
    @SkipWhenEmpty
    FileCollection snapshotFiles = this.getProject().files(new Object[0]);
    Collection<String> needCheckinFiles = new ArrayList<String>();

    @TaskAction
    public void checkFilesForChanges(IncrementalTaskInputs inputs) {
        this.getLogger().lifecycle("Checking idl and snapshot files for changes...");
        this.getLogger().info("idlFiles: " + this.idlFiles.getAsPath());
        this.getLogger().info("snapshotFiles: " + this.snapshotFiles.getAsPath());
        HashSet<String> filesRemoved = new HashSet<String>();
        HashSet<String> filesAdded = new HashSet<String>();
        HashSet<String> filesChanged = new HashSet<String>();
        if (inputs.isIncremental()) {
            String files;
            inputs.outOfDate(inputFileDetails -> {
                if (inputFileDetails.isAdded()) {
                    filesAdded.add(inputFileDetails.getFile().getAbsolutePath());
                }
                if (inputFileDetails.isRemoved()) {
                    filesRemoved.add(inputFileDetails.getFile().getAbsolutePath());
                }
                if (inputFileDetails.isModified()) {
                    filesChanged.add(inputFileDetails.getFile().getAbsolutePath());
                }
            });
            inputs.removed(inputFileDetails -> filesRemoved.add(inputFileDetails.getFile().getAbsolutePath()));
            if (!filesRemoved.isEmpty()) {
                files = this.joinByComma(filesRemoved);
                this.needCheckinFiles.add(files);
                this.getLogger().lifecycle("The following files have been removed, be sure to remove them from source control: {}", new Object[]{files});
            }
            if (!filesAdded.isEmpty()) {
                files = this.joinByComma(filesAdded);
                this.needCheckinFiles.add(files);
                this.getLogger().lifecycle("The following files have been added, be sure to add them to source control: {}", new Object[]{files});
            }
            if (!filesChanged.isEmpty()) {
                files = this.joinByComma(filesChanged);
                this.needCheckinFiles.add(files);
                this.getLogger().lifecycle("The following files have been changed, be sure to commit the changes to source control: {}", new Object[]{files});
            }
        }
    }

    private String joinByComma(Set<String> files) {
        return files.stream().collect(Collectors.joining(", "));
    }

    public FileCollection getSnapshotFiles() {
        return this.snapshotFiles;
    }

    public void setSnapshotFiles(FileCollection snapshotFiles) {
        this.snapshotFiles = snapshotFiles;
    }

    public FileCollection getIdlFiles() {
        return this.idlFiles;
    }

    public void setIdlFiles(FileCollection idlFiles) {
        this.idlFiles = idlFiles;
    }

    public Collection<String> getNeedCheckinFiles() {
        return this.needCheckinFiles;
    }
}

