/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;

public class CompatibilityLogChecker
extends OutputStream {
    private static final Logger LOG = Logging.getLogger(CompatibilityLogChecker.class);
    private StringBuilder wholeTextBuilder = new StringBuilder();
    private StringBuilder lineTextBuilder = new StringBuilder();
    List<FileCompatibility> restSpecCompatibility = new ArrayList<FileCompatibility>();
    List<FileCompatibility> modelCompatibility = new ArrayList<FileCompatibility>();
    boolean isRestSpecCompatible = true;
    boolean isModelCompatible = true;

    @Override
    public void write(int b) throws IOException {
        this.wholeTextBuilder.append((char)b);
        if (b == 10) {
            LOG.lifecycle("[checker] {}", new Object[]{this.lineTextBuilder.toString()});
            this.processLine(this.lineTextBuilder.toString());
            this.lineTextBuilder = new StringBuilder();
        } else {
            this.lineTextBuilder.append((char)b);
        }
    }

    private void processLine(String s) {
        String message = s.substring(s.indexOf(58) + 1);
        if (s.startsWith("[RS-COMPAT]")) {
            this.isRestSpecCompatible = Boolean.parseBoolean(message.trim());
        } else if (s.startsWith("[MD-COMPAT]")) {
            this.isModelCompatible = Boolean.parseBoolean(message.trim());
        } else if (s.startsWith("[RS-C]")) {
            this.restSpecCompatibility.add(new FileCompatibility(message, true));
        } else if (s.startsWith("[RS-I]")) {
            this.restSpecCompatibility.add(new FileCompatibility(message, false));
        } else if (s.startsWith("[MD-C]")) {
            this.modelCompatibility.add(new FileCompatibility(message, true));
        } else if (s.startsWith("[MD-I]")) {
            this.modelCompatibility.add(new FileCompatibility(message, false));
        }
    }

    public String getWholeText() {
        return this.wholeTextBuilder.toString();
    }

    public List<FileCompatibility> getRestSpecCompatibility() {
        return this.restSpecCompatibility;
    }

    public List<FileCompatibility> getModelCompatibility() {
        return this.modelCompatibility;
    }

    public boolean isRestSpecCompatible() {
        return this.isRestSpecCompatible;
    }

    public boolean isModelCompatible() {
        return this.isModelCompatible;
    }

    public static class FileCompatibility {
        private final String fileName;
        private final boolean compatible;

        public FileCompatibility(String fileName, boolean compatible) {
            this.fileName = fileName;
            this.compatible = compatible;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isCompatible() {
            return this.compatible;
        }
    }
}

