/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle;

import com.linkedin.pegasus.gradle.CacheableAction;
import com.linkedin.pegasus.gradle.FileCompatibilityType;
import com.linkedin.pegasus.gradle.PegasusOptions;
import com.linkedin.pegasus.gradle.PropertyUtil;
import com.linkedin.pegasus.gradle.SchemaFileType;
import com.linkedin.pegasus.gradle.SharedFileUtils;
import com.linkedin.pegasus.gradle.tasks.ChangedFileReportTask;
import com.linkedin.pegasus.gradle.tasks.CheckIdlTask;
import com.linkedin.pegasus.gradle.tasks.CheckRestModelTask;
import com.linkedin.pegasus.gradle.tasks.CheckSnapshotTask;
import com.linkedin.pegasus.gradle.tasks.GenerateAvroSchemaTask;
import com.linkedin.pegasus.gradle.tasks.GenerateDataTemplateTask;
import com.linkedin.pegasus.gradle.tasks.GenerateRestClientTask;
import com.linkedin.pegasus.gradle.tasks.GenerateRestModelTask;
import com.linkedin.pegasus.gradle.tasks.PublishRestModelTask;
import com.linkedin.pegasus.gradle.tasks.TranslateSchemasTask;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.api.tasks.javadoc.Javadoc;
import org.gradle.plugins.ide.eclipse.EclipsePlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModule;

public class PegasusPlugin
implements Plugin<Project> {
    public static boolean debug = false;
    private static final String DATA_TEMPLATE_GEN_TYPE = "DataTemplate";
    private static final String REST_GEN_TYPE = "Rest";
    private static final String AVRO_SCHEMA_GEN_TYPE = "AvroSchema";
    public static final String DATA_TEMPLATE_FILE_SUFFIX = ".pdsc";
    public static final String PDL_FILE_SUFFIX = ".pdl";
    private static final String PDL_ENABLE = "enablePDL";
    private static final String DESTROY_STALE_FILES_ENABLE = "enableDestroyStaleFiles";
    public static final Collection<String> DATA_TEMPLATE_FILE_SUFFIXES = new ArrayList<String>();
    public static final String IDL_FILE_SUFFIX = ".restspec.json";
    public static final String SNAPSHOT_FILE_SUFFIX = ".snapshot.json";
    public static final String SNAPSHOT_COMPAT_REQUIREMENT = "rest.model.compatibility";
    public static final String IDL_COMPAT_REQUIREMENT = "rest.idl.compatibility";
    private static final Pattern TEST_DIR_REGEX = Pattern.compile("^(integ)?[Tt]est");
    private static final String SNAPSHOT_NO_PUBLISH = "rest.model.noPublish";
    private static final String IDL_NO_PUBLISH = "rest.idl.noPublish";
    private static final String SKIP_IDL_CHECK = "rest.idl.skipCheck";
    private static final String SUPPRESS_REST_CLIENT_RESTLI_2 = "rest.client.restli2.suppress";
    private static final String GENERATOR_CLASSLOADER_NAME = "pegasusGeneratorClassLoader";
    private static StringBuffer _restModelCompatMessage = new StringBuffer();
    private static final Collection<String> _needCheckinFiles = new ArrayList<String>();
    private static final Collection<String> _needBuildFolders = new ArrayList<String>();
    private static final Collection<String> _possibleMissingFilesInEarlierCommit = new ArrayList<String>();
    private static final String RUN_ONCE = "runOnce";
    private static final Object STATIC_PROJECT_EVALUATED_LOCK = new Object();
    private static final List<String> UNUSED_CONFIGURATIONS = Arrays.asList("dataTemplateGenerator", "restTools", "avroSchemaGenerator");
    private Class<? extends Plugin<Project>> _thisPluginType = this.getClass().asSubclass(Plugin.class);
    private Task _generateSourcesJarTask;
    private Javadoc _generateJavadocTask;
    private Task _generateJavadocJarTask;

    public void setPluginType(Class<? extends Plugin<Project>> pluginType) {
        this._thisPluginType = pluginType;
    }

    public void setSourcesJarTask(Task sourcesJarTask) {
        this._generateSourcesJarTask = sourcesJarTask;
    }

    public void setJavadocJarTask(Task javadocJarTask) {
        this._generateJavadocJarTask = javadocJarTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(Project project) {
        project.getPlugins().apply(JavaPlugin.class);
        project.getPlugins().apply(IdeaPlugin.class);
        project.getPlugins().apply(EclipsePlugin.class);
        project.getExtensions().getExtraProperties().set("pegasus", new HashMap());
        project.getExtensions().getExtraProperties().set("PegasusGenerationMode", Arrays.stream(PegasusOptions.GenerationMode.values()).collect(Collectors.toMap(Enum::name, Function.identity())));
        Object object = STATIC_PROJECT_EVALUATED_LOCK;
        synchronized (object) {
            if (!project.getRootProject().hasProperty(RUN_ONCE) || !Boolean.parseBoolean(String.valueOf(project.getRootProject().property(RUN_ONCE)))) {
                project.getGradle().projectsEvaluated(gradle -> gradle.getRootProject().subprojects(subproject -> UNUSED_CONFIGURATIONS.forEach(configurationName -> {
                    Configuration conf = (Configuration)subproject.getConfigurations().findByName(configurationName);
                    if (conf != null && !conf.isEmpty()) {
                        subproject.getLogger().warn("*** Project {} declares dependency to unused configuration \"{}\". This configuration is deprecated and you can safely remove the dependency. ***", (Object)subproject.getPath(), configurationName);
                    }
                })));
                DATA_TEMPLATE_FILE_SUFFIXES.clear();
                DATA_TEMPLATE_FILE_SUFFIXES.add(DATA_TEMPLATE_FILE_SUFFIX);
                if (PegasusPlugin.isPropertyTrue(project, PDL_ENABLE)) {
                    DATA_TEMPLATE_FILE_SUFFIXES.add(PDL_FILE_SUFFIX);
                }
                _restModelCompatMessage = new StringBuffer();
                _needCheckinFiles.clear();
                _needBuildFolders.clear();
                _possibleMissingFilesInEarlierCommit.clear();
                project.getGradle().buildFinished(result -> {
                    StringBuilder endOfBuildMessage = new StringBuilder();
                    if (_restModelCompatMessage.length() > 0) {
                        endOfBuildMessage.append(_restModelCompatMessage);
                    }
                    if (!_needCheckinFiles.isEmpty()) {
                        endOfBuildMessage.append(PegasusPlugin.createModifiedFilesMessage(_needCheckinFiles, _needBuildFolders));
                    }
                    if (!_possibleMissingFilesInEarlierCommit.isEmpty()) {
                        endOfBuildMessage.append(PegasusPlugin.createPossibleMissingFilesMessage(_possibleMissingFilesInEarlierCommit));
                    }
                    if (endOfBuildMessage.length() > 0) {
                        result.getGradle().getRootProject().getLogger().quiet(endOfBuildMessage.toString());
                    }
                });
                project.getRootProject().getExtensions().getExtraProperties().set(RUN_ONCE, (Object)true);
            }
        }
        ConfigurationContainer configurations = project.getConfigurations();
        configurations.maybeCreate("pegasusPlugin");
        Configuration dataTemplateCompile = (Configuration)configurations.maybeCreate("dataTemplateCompile");
        dataTemplateCompile.setVisible(false);
        Configuration restClientCompile = (Configuration)configurations.maybeCreate("restClientCompile");
        restClientCompile.setVisible(false);
        Configuration dataTemplateGenerator = (Configuration)configurations.maybeCreate("dataTemplateGenerator");
        dataTemplateGenerator.setVisible(false);
        Configuration restTools = (Configuration)configurations.maybeCreate("restTools");
        restTools.setVisible(false);
        Configuration avroSchemaGenerator = (Configuration)configurations.maybeCreate("avroSchemaGenerator");
        avroSchemaGenerator.setVisible(false);
        Configuration dataModel = (Configuration)configurations.maybeCreate("dataModel");
        Configuration testDataModel = (Configuration)configurations.maybeCreate("testDataModel");
        testDataModel.extendsFrom(new Configuration[]{dataModel});
        Configuration avroSchema = (Configuration)configurations.maybeCreate("avroSchema");
        Configuration testAvroSchema = (Configuration)configurations.maybeCreate("testAvroSchema");
        testAvroSchema.extendsFrom(new Configuration[]{avroSchema});
        Configuration restModel = (Configuration)configurations.maybeCreate("restModel");
        Configuration testRestModel = (Configuration)configurations.maybeCreate("testRestModel");
        testRestModel.extendsFrom(new Configuration[]{restModel});
        Configuration dataTemplate = (Configuration)configurations.maybeCreate("dataTemplate");
        dataTemplate.extendsFrom(new Configuration[]{dataTemplateCompile, dataModel});
        Configuration testDataTemplate = (Configuration)configurations.maybeCreate("testDataTemplate");
        testDataTemplate.extendsFrom(new Configuration[]{dataTemplate, testDataModel});
        Configuration restClient = (Configuration)configurations.maybeCreate("restClient");
        restClient.extendsFrom(new Configuration[]{restClientCompile, dataTemplate});
        Configuration testRestClient = (Configuration)configurations.maybeCreate("testRestClient");
        testRestClient.extendsFrom(new Configuration[]{restClient, testDataTemplate});
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getResourceAsStream("/pegasus-version.properties");
        if (inputStream != null) {
            try {
                properties.load(inputStream);
            }
            catch (IOException e) {
                throw new GradleException("Unable to read pegasus-version.properties file.", (Throwable)e);
            }
            String version = properties.getProperty("pegasus.version");
            project.getDependencies().add("pegasusPlugin", (Object)("com.linkedin.pegasus:data:" + version));
            project.getDependencies().add("pegasusPlugin", (Object)("com.linkedin.pegasus:data-avro-generator:" + version));
            project.getDependencies().add("pegasusPlugin", (Object)("com.linkedin.pegasus:generator:" + version));
            project.getDependencies().add("pegasusPlugin", (Object)("com.linkedin.pegasus:restli-tools:" + version));
        } else {
            project.getLogger().lifecycle("Unable to add pegasus dependencies to {}. Please be sure that 'com.linkedin.pegasus:data', 'com.linkedin.pegasus:data-avro-generator', 'com.linkedin.pegasus:generator', 'com.linkedin.pegasus:restli-tools' are available on the configuration pegasusPlugin", new Object[]{project.getPath()});
        }
        project.getDependencies().add("pegasusPlugin", (Object)"org.slf4j:slf4j-simple:1.7.2");
        project.getDependencies().add("pegasusPlugin", (Object)project.files(new Object[]{System.getProperty("java.home") + "/../lib/tools.jar"}));
        this.configureGeneratedSourcesAndJavadoc(project);
        ChangedFileReportTask changedFileReportTask = (ChangedFileReportTask)project.getTasks().create("changedFilesReport", ChangedFileReportTask.class);
        project.getTasks().getByName("check").dependsOn(new Object[]{changedFileReportTask});
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        sourceSets.all(sourceSet -> {
            if (sourceSet.getName().toLowerCase(Locale.US).contains("generated")) {
                return;
            }
            PegasusPlugin.checkAvroSchemaExist(project, sourceSet);
            Map pegasusOptions = (Map)project.getExtensions().getExtraProperties().get("pegasus");
            pegasusOptions.put(sourceSet.getName(), new PegasusOptions());
            this.configureRestModelGeneration(project, (SourceSet)sourceSet);
            if (PegasusPlugin.isPropertyTrue(project, PDL_ENABLE)) {
                this.configureConversionUtilities(project, (SourceSet)sourceSet);
            }
            this.configureDataTemplateGeneration(project, (SourceSet)sourceSet);
            this.configureAvroSchemaGeneration(project, (SourceSet)sourceSet);
            this.configureRestClientGeneration(project, (SourceSet)sourceSet);
            Task cleanGeneratedDirTask = project.task(sourceSet.getTaskName("clean", "GeneratedDir"));
            cleanGeneratedDirTask.doLast(new CacheableAction(task -> {
                PegasusPlugin.deleteGeneratedDir(project, sourceSet, REST_GEN_TYPE);
                PegasusPlugin.deleteGeneratedDir(project, sourceSet, AVRO_SCHEMA_GEN_TYPE);
                PegasusPlugin.deleteGeneratedDir(project, sourceSet, DATA_TEMPLATE_GEN_TYPE);
            }));
            project.getTasks().getByName("clean").dependsOn(new Object[]{cleanGeneratedDirTask});
        });
        project.getExtensions().getExtraProperties().set(GENERATOR_CLASSLOADER_NAME, (Object)this.getClass().getClassLoader());
    }

    protected void configureGeneratedSourcesAndJavadoc(Project project) {
        ConfigurationContainer configurations;
        this._generateJavadocTask = (Javadoc)project.getTasks().create("generateJavadoc", Javadoc.class);
        if (this._generateSourcesJarTask == null) {
            configurations = project.getConfigurations();
            Configuration generatedSources = (Configuration)configurations.maybeCreate("generatedSources");
            Configuration testGeneratedSources = (Configuration)configurations.maybeCreate("testGeneratedSources");
            testGeneratedSources.extendsFrom(new Configuration[]{generatedSources});
            this._generateSourcesJarTask = project.getTasks().create("generateSourcesJar", Jar.class, jarTask -> {
                jarTask.setGroup("documentation");
                jarTask.setDescription("Generates a jar file containing the sources for the generated Java classes.");
                jarTask.setClassifier("sources");
            });
            project.getArtifacts().add("generatedSources", (Object)this._generateSourcesJarTask);
        }
        if (this._generateJavadocJarTask == null) {
            configurations = project.getConfigurations();
            Configuration generatedJavadoc = (Configuration)configurations.maybeCreate("generatedJavadoc");
            Configuration testGeneratedJavadoc = (Configuration)configurations.maybeCreate("testGeneratedJavadoc");
            testGeneratedJavadoc.extendsFrom(new Configuration[]{generatedJavadoc});
            this._generateJavadocJarTask = project.getTasks().create("generateJavadocJar", Jar.class, jarTask -> {
                jarTask.dependsOn(new Object[]{this._generateJavadocTask});
                jarTask.setGroup("documentation");
                jarTask.setDescription("Generates a jar file containing the Javadoc for the generated Java classes.");
                jarTask.setClassifier("javadoc");
                jarTask.from(new Object[]{this._generateJavadocTask.getDestinationDir()});
            });
            project.getArtifacts().add("generatedJavadoc", (Object)this._generateJavadocJarTask);
        } else {
            ((Jar)this._generateJavadocJarTask).from(new Object[]{this._generateJavadocTask.getDestinationDir()});
            this._generateJavadocJarTask.dependsOn(new Object[]{this._generateJavadocTask});
        }
    }

    private static void deleteGeneratedDir(Project project, SourceSet sourceSet, String dirType) {
        String generatedDirPath = PegasusPlugin.getGeneratedDirPath(project, sourceSet, dirType);
        project.getLogger().info("Delete generated directory {}", (Object)generatedDirPath);
        project.delete(new Object[]{generatedDirPath});
    }

    private static <E extends Enum<E>> Class<E> getCompatibilityLevelClass(Project project) {
        ClassLoader generatorClassLoader = (ClassLoader)project.property(GENERATOR_CLASSLOADER_NAME);
        String className = "com.linkedin.restli.tools.idlcheck.CompatibilityLevel";
        try {
            Class<Enum> enumClass = generatorClassLoader.loadClass(className).asSubclass(Enum.class);
            return enumClass;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class " + className);
        }
    }

    private static void addGeneratedDir(Project project, SourceSet sourceSet, Collection<Configuration> configurations) {
        project.getPlugins().withType(IdeaPlugin.class, ideaPlugin -> {
            Set sourceDirs;
            IdeaModule ideaModule = ideaPlugin.getModel().getModule();
            if (PegasusPlugin.isTestSourceSet(sourceSet)) {
                sourceDirs = ideaModule.getTestSourceDirs();
                sourceDirs.addAll(sourceSet.getJava().getSrcDirs());
                ideaModule.setTestSourceDirs(sourceDirs);
                if (debug) {
                    System.out.println("Added " + sourceSet.getJava().getSrcDirs() + " to IdeaModule testSourceDirs " + ideaModule.getTestSourceDirs());
                }
            } else {
                sourceDirs = ideaModule.getSourceDirs();
                sourceDirs.addAll(sourceSet.getJava().getSrcDirs());
                ideaModule.setSourceDirs(sourceDirs);
                if (debug) {
                    System.out.println("Added " + sourceSet.getJava().getSrcDirs() + " to  IdeaModule sourceDirs " + ideaModule.getSourceDirs());
                }
            }
            Collection compilePlus = (Collection)((Map)ideaModule.getScopes().get("COMPILE")).get("plus");
            compilePlus.addAll(configurations);
            ((Map)ideaModule.getScopes().get("COMPILE")).put("plus", compilePlus);
        });
    }

    private static void checkAvroSchemaExist(Project project, SourceSet sourceSet) {
        String sourceDir = "src" + File.separatorChar + sourceSet.getName();
        File avroSourceDir = project.file((Object)(sourceDir + File.separatorChar + "avro"));
        if (avroSourceDir.exists()) {
            project.getLogger().lifecycle("{}'s {} has non-empty avro directory. pegasus plugin does not process avro directory", new Object[]{project.getName(), sourceDir});
        }
    }

    private static String getGeneratedSourceSetName(SourceSet sourceSet, String genType) {
        return sourceSet.getName() + "Generated" + genType;
    }

    public static String getGeneratedDirPath(Project project, SourceSet sourceSet, String genType) {
        String override = PegasusPlugin.getOverridePath(project, sourceSet, "overrideGeneratedDir");
        String sourceSetName = PegasusPlugin.getGeneratedSourceSetName(sourceSet, genType);
        String base = override == null ? "src" : override;
        return base + File.separatorChar + sourceSetName;
    }

    private static String getDataSchemaPath(Project project, SourceSet sourceSet) {
        String override = PegasusPlugin.getOverridePath(project, sourceSet, "overridePegasusDir");
        if (override == null) {
            return "src" + File.separatorChar + sourceSet.getName() + File.separatorChar + "pegasus";
        }
        return override;
    }

    private static String getSnapshotPath(Project project, SourceSet sourceSet) {
        String override = PegasusPlugin.getOverridePath(project, sourceSet, "overrideSnapshotDir");
        if (override == null) {
            return "src" + File.separatorChar + sourceSet.getName() + File.separatorChar + "snapshot";
        }
        return override;
    }

    private static String getIdlPath(Project project, SourceSet sourceSet) {
        String override = PegasusPlugin.getOverridePath(project, sourceSet, "overrideIdlDir");
        if (override == null) {
            return "src" + File.separatorChar + sourceSet.getName() + File.separatorChar + "idl";
        }
        return override;
    }

    private static String getOverridePath(Project project, SourceSet sourceSet, String overridePropertyName) {
        String sourceSetPropertyName = sourceSet.getName() + '.' + overridePropertyName;
        String override = PegasusPlugin.getNonEmptyProperty(project, sourceSetPropertyName);
        if (override == null && sourceSet.getName().equals("main")) {
            override = PegasusPlugin.getNonEmptyProperty(project, overridePropertyName);
        }
        return override;
    }

    private static boolean isTestSourceSet(SourceSet sourceSet) {
        return TEST_DIR_REGEX.matcher(sourceSet.getName()).find();
    }

    private static Configuration getDataModelConfig(Project project, SourceSet sourceSet) {
        return PegasusPlugin.isTestSourceSet(sourceSet) ? project.getConfigurations().getByName("testDataModel") : project.getConfigurations().getByName("dataModel");
    }

    private static boolean isTaskSuccessful(Task task) {
        return task.getState().getExecuted() && !task.getState().getSkipped() && task.getState().getFailure() == null;
    }

    protected void configureRestModelGeneration(Project project, SourceSet sourceSet) {
        if (sourceSet.getAllSource().isEmpty()) {
            project.getLogger().info("No source files found for sourceSet {}.  Skipping idl generation.", (Object)sourceSet.getName());
            return;
        }
        project.afterEvaluate(p -> {
            Project apiProject = PegasusPlugin.getCheckedApiProject(project);
            if (apiProject != null) {
                project.evaluationDependsOn(apiProject.getPath());
                if (!apiProject.getPlugins().hasPlugin(this._thisPluginType)) {
                    apiProject = null;
                }
            }
            if (apiProject == null) {
                return;
            }
            Task untypedJarTask = (Task)project.getTasks().findByName(sourceSet.getJarTaskName());
            if (!(untypedJarTask instanceof Jar)) {
                return;
            }
            Jar jarTask = (Jar)untypedJarTask;
            String snapshotCompatPropertyName = PegasusPlugin.findProperty(FileCompatibilityType.SNAPSHOT);
            if (project.hasProperty(snapshotCompatPropertyName) && "off".equalsIgnoreCase((String)project.property(snapshotCompatPropertyName))) {
                project.getLogger().lifecycle("Project {} snapshot compatibility level \"OFF\" is deprecated. Default to \"IGNORE\".", new Object[]{project.getPath()});
            }
            FileCollection restModelCodegenClasspath = project.getConfigurations().getByName("pegasusPlugin").plus((FileCollection)project.getConfigurations().getByName("runtime")).plus(sourceSet.getRuntimeClasspath());
            String destinationDirPrefix = PegasusPlugin.getGeneratedDirPath(project, sourceSet, REST_GEN_TYPE) + File.separatorChar;
            FileCollection restModelResolverPath = apiProject.files(new Object[]{PegasusPlugin.getDataSchemaPath(project, sourceSet)}).plus((FileCollection)PegasusPlugin.getDataModelConfig(apiProject, sourceSet));
            Set<File> watchedRestModelInputDirs = PegasusPlugin.buildWatchedRestModelInputDirs(project, sourceSet);
            Set restModelInputDirs = PegasusPlugin.difference(sourceSet.getAllSource().getSrcDirs(), sourceSet.getResources().getSrcDirs());
            Task generateRestModelTask = project.getTasks().create(sourceSet.getTaskName("generate", "restModel"), GenerateRestModelTask.class, task -> {
                task.dependsOn(new Object[]{project.getTasks().getByName(sourceSet.getClassesTaskName())});
                task.setCodegenClasspath(restModelCodegenClasspath);
                task.setWatchedCodegenClasspath(restModelCodegenClasspath.filter(file -> !"main".equals(file.getName()) && !"classes".equals(file.getName())));
                task.setInputDirs(restModelInputDirs);
                task.setWatchedInputDirs(watchedRestModelInputDirs.isEmpty() ? restModelInputDirs : watchedRestModelInputDirs);
                task.setSnapshotDestinationDir(project.file((Object)(destinationDirPrefix + "snapshot")));
                task.setIdlDestinationDir(project.file((Object)(destinationDirPrefix + "idl")));
                Map pegasusOptions = (Map)project.getExtensions().getExtraProperties().get("pegasus");
                task.setIdlOptions(((PegasusOptions)pegasusOptions.get((Object)sourceSet.getName())).idlOptions);
                task.setResolverPath(restModelResolverPath);
                task.doFirst(new CacheableAction(t -> PegasusPlugin.deleteGeneratedDir(project, sourceSet, REST_GEN_TYPE)));
            });
            File apiSnapshotDir = apiProject.file((Object)PegasusPlugin.getSnapshotPath(apiProject, sourceSet));
            File apiIdlDir = apiProject.file((Object)PegasusPlugin.getIdlPath(apiProject, sourceSet));
            apiSnapshotDir.mkdirs();
            if (!PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK)) {
                apiIdlDir.mkdirs();
            }
            CheckRestModelTask checkRestModelTask = (CheckRestModelTask)project.getTasks().create(sourceSet.getTaskName("check", "RestModel"), CheckRestModelTask.class, task -> {
                task.dependsOn(new Object[]{generateRestModelTask});
                task.setCurrentSnapshotFiles(SharedFileUtils.getSnapshotFiles(project, destinationDirPrefix));
                task.setPreviousSnapshotDirectory(apiSnapshotDir);
                task.setCurrentIdlFiles(SharedFileUtils.getIdlFiles(project, destinationDirPrefix));
                task.setPreviousIdlDirectory(apiIdlDir);
                task.setCodegenClasspath((FileCollection)project.getConfigurations().getByName("pegasusPlugin"));
                task.setModelCompatLevel(PropertyUtil.findCompatLevel(project, FileCompatibilityType.SNAPSHOT));
                task.onlyIf(t -> !PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK));
                task.doLast(new CacheableAction(t -> {
                    if (!task.isEquivalent()) {
                        _restModelCompatMessage.append(task.getWholeMessage());
                    }
                }));
            });
            CheckSnapshotTask checkSnapshotTask = (CheckSnapshotTask)project.getTasks().create(sourceSet.getTaskName("check", "Snapshot"), CheckSnapshotTask.class, task -> {
                task.dependsOn(new Object[]{generateRestModelTask});
                task.setCurrentSnapshotFiles(SharedFileUtils.getSnapshotFiles(project, destinationDirPrefix));
                task.setPreviousSnapshotDirectory(apiSnapshotDir);
                task.setCodegenClasspath((FileCollection)project.getConfigurations().getByName("pegasusPlugin"));
                task.setSnapshotCompatLevel(PropertyUtil.findCompatLevel(project, FileCompatibilityType.SNAPSHOT));
                task.onlyIf(t -> PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK));
            });
            CheckIdlTask checkIdlTask = (CheckIdlTask)project.getTasks().create(sourceSet.getTaskName("check", "Idl"), CheckIdlTask.class, task -> {
                task.dependsOn(new Object[]{generateRestModelTask});
                task.setCurrentIdlFiles(SharedFileUtils.getIdlFiles(project, destinationDirPrefix));
                task.setPreviousIdlDirectory(apiIdlDir);
                task.setResolverPath(restModelResolverPath);
                task.setCodegenClasspath((FileCollection)project.getConfigurations().getByName("pegasusPlugin"));
                task.setIdlCompatLevel(PropertyUtil.findCompatLevel(project, FileCompatibilityType.IDL));
                task.onlyIf(t -> !PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK) && !"OFF".equals(PropertyUtil.findCompatLevel(project, FileCompatibilityType.IDL)));
            });
            Task publishRestliSnapshotTask = project.getTasks().create(sourceSet.getTaskName("publish", "RestliSnapshot"), PublishRestModelTask.class, task -> {
                task.dependsOn(new Object[]{checkRestModelTask, checkSnapshotTask, checkIdlTask});
                task.from(new Object[]{SharedFileUtils.getSnapshotFiles(project, destinationDirPrefix)});
                task.into(apiSnapshotDir);
                task.setSuffix(SNAPSHOT_FILE_SUFFIX);
                task.onlyIf(t -> {
                    project.getLogger().info("IDL_NO_PUBLISH: {}\nSNAPSHOT_NO_PUBLISH: {}\ncheckRestModelTask: Executed: {}, Not Skipped: {}, No Failure: {}, Is Not Equivalent: {}\ncheckSnapshotTask: Executed: {}, Not Skipped: {}, No Failure: {}, Is Not Equivalent: {}\n", new Object[]{PegasusPlugin.isPropertyTrue(project, IDL_NO_PUBLISH), PegasusPlugin.isPropertyTrue(project, SNAPSHOT_NO_PUBLISH), checkRestModelTask.getState().getExecuted(), !checkRestModelTask.getState().getSkipped(), checkRestModelTask.getState().getFailure() == null, !checkRestModelTask.isEquivalent(), checkSnapshotTask.getState().getExecuted(), !checkSnapshotTask.getState().getSkipped(), checkSnapshotTask.getState().getFailure() == null, !checkSnapshotTask.isEquivalent()});
                    return !PegasusPlugin.isPropertyTrue(project, SNAPSHOT_NO_PUBLISH) && (PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK) && PegasusPlugin.isTaskSuccessful((Task)checkSnapshotTask) && !checkSnapshotTask.isEquivalent() || !PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK) && PegasusPlugin.isTaskSuccessful((Task)checkRestModelTask) && !checkRestModelTask.isEquivalent());
                });
            });
            Task publishRestliIdlTask = project.getTasks().create(sourceSet.getTaskName("publish", "RestliIdl"), PublishRestModelTask.class, task -> {
                task.dependsOn(new Object[]{checkRestModelTask, checkIdlTask, checkSnapshotTask});
                task.from(new Object[]{SharedFileUtils.getIdlFiles(project, destinationDirPrefix)});
                task.into(apiIdlDir);
                task.setSuffix(IDL_FILE_SUFFIX);
                task.onlyIf(t -> {
                    project.getLogger().info("SKIP_IDL: {}\nIDL_NO_PUBLISH: {}\nSNAPSHOT_NO_PUBLISH: {}\ncheckRestModelTask: Executed: {}, Not Skipped: {}, No Failure: {}, Is Not Equivalent: {}\ncheckIdlTask: Executed: {}, Not Skipped: {}, No Failure: {}, Is Not Equivalent: {}\ncheckSnapshotTask: Executed: {}, Not Skipped: {}, No Failure: {}, Is RestSpec Not Equivalent: {}\n", new Object[]{PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK), PegasusPlugin.isPropertyTrue(project, IDL_NO_PUBLISH), PegasusPlugin.isPropertyTrue(project, SNAPSHOT_NO_PUBLISH), checkRestModelTask.getState().getExecuted(), !checkRestModelTask.getState().getSkipped(), checkRestModelTask.getState().getFailure() == null, !checkRestModelTask.isEquivalent(), checkIdlTask.getState().getExecuted(), !checkIdlTask.getState().getSkipped(), checkIdlTask.getState().getFailure() == null, !checkIdlTask.isEquivalent(), checkSnapshotTask.getState().getExecuted(), !checkSnapshotTask.getState().getSkipped(), checkSnapshotTask.getState().getFailure() == null, !checkSnapshotTask.isEquivalent()});
                    return !PegasusPlugin.isPropertyTrue(project, IDL_NO_PUBLISH) && (PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK) && PegasusPlugin.isTaskSuccessful((Task)checkSnapshotTask) && !checkSnapshotTask.isRestSpecEquivalent() || !PegasusPlugin.isPropertyTrue(project, SKIP_IDL_CHECK) && (PegasusPlugin.isTaskSuccessful((Task)checkRestModelTask) && !checkRestModelTask.isRestSpecEquivalent() || PegasusPlugin.isTaskSuccessful((Task)checkIdlTask) && !checkIdlTask.isEquivalent()));
                });
            });
            project.getLogger().info("API project selected for {} is {}", (Object)publishRestliIdlTask.getPath(), (Object)apiProject.getPath());
            jarTask.from(new Object[]{SharedFileUtils.getIdlFiles(project, destinationDirPrefix)});
            jarTask.dependsOn(new Object[]{publishRestliSnapshotTask, publishRestliIdlTask});
            ChangedFileReportTask changedFileReportTask = (ChangedFileReportTask)project.getTasks().getByName("changedFilesReport");
            changedFileReportTask.setIdlFiles((FileCollection)SharedFileUtils.getSuffixedFiles(project, (Object)apiIdlDir, IDL_FILE_SUFFIX));
            changedFileReportTask.setSnapshotFiles((FileCollection)SharedFileUtils.getSuffixedFiles(project, (Object)apiSnapshotDir, SNAPSHOT_FILE_SUFFIX));
            changedFileReportTask.mustRunAfter(new Object[]{publishRestliSnapshotTask, publishRestliIdlTask});
            changedFileReportTask.doLast(new CacheableAction(t -> {
                if (!changedFileReportTask.getNeedCheckinFiles().isEmpty()) {
                    project.getLogger().info("Adding modified files to need checkin list...");
                    _needCheckinFiles.addAll(changedFileReportTask.getNeedCheckinFiles());
                    _needBuildFolders.add(PegasusPlugin.getCheckedApiProject(project).getPath());
                }
            }));
        });
    }

    protected void configureAvroSchemaGeneration(Project project, SourceSet sourceSet) {
        File dataSchemaDir = project.file((Object)PegasusPlugin.getDataSchemaPath(project, sourceSet));
        File avroDir = project.file((Object)(PegasusPlugin.getGeneratedDirPath(project, sourceSet, AVRO_SCHEMA_GEN_TYPE) + File.separatorChar + "avro"));
        Task generateAvroSchemaTask = project.getTasks().create(sourceSet.getTaskName("generate", "avroSchema"), GenerateAvroSchemaTask.class, task -> {
            task.setInputDir(dataSchemaDir);
            task.setDestinationDir(avroDir);
            task.setResolverPath((FileCollection)PegasusPlugin.getDataModelConfig(project, sourceSet));
            task.setCodegenClasspath((FileCollection)project.getConfigurations().getByName("pegasusPlugin"));
            task.onlyIf(t -> {
                Map pegasusOptions;
                if (task.getInputDir().exists() && ((PegasusOptions)(pegasusOptions = (Map)project.getExtensions().getExtraProperties().get("pegasus")).get(sourceSet.getName())).hasGenerationMode(PegasusOptions.GenerationMode.AVRO)) {
                    return true;
                }
                return !project.getConfigurations().getByName("avroSchemaGenerator").isEmpty();
            });
            task.doFirst(new CacheableAction(t -> PegasusPlugin.deleteGeneratedDir(project, sourceSet, AVRO_SCHEMA_GEN_TYPE)));
        });
        project.getTasks().getByName(sourceSet.getCompileJavaTaskName()).dependsOn(new Object[]{generateAvroSchemaTask});
        Task avroSchemaJarTask = project.getTasks().create(sourceSet.getName() + "AvroSchemaJar", Jar.class, task -> {
            task.from((Object)avroDir, copySpec -> copySpec.eachFile(fileCopyDetails -> fileCopyDetails.setPath("avro" + File.separatorChar + fileCopyDetails.getPath())));
            task.setAppendix(PegasusPlugin.getAppendix(sourceSet, "avro-schema"));
            task.setDescription("Generate an avro schema jar");
        });
        if (!PegasusPlugin.isTestSourceSet(sourceSet)) {
            project.getArtifacts().add("avroSchema", (Object)avroSchemaJarTask);
        } else {
            project.getArtifacts().add("testAvroSchema", (Object)avroSchemaJarTask);
        }
    }

    protected void configureConversionUtilities(Project project, SourceSet sourceSet) {
        File dataSchemaDir = project.file((Object)PegasusPlugin.getDataSchemaPath(project, sourceSet));
        File conversionBackupBuildDir = project.file((Object)(project.getBuildDir().getAbsolutePath() + File.separatorChar + sourceSet.getName() + "ConversionBackup"));
        Task backup = project.getTasks().create(sourceSet.getTaskName("backup", "Pdsc"), Copy.class, task -> {
            task.from((Object)dataSchemaDir, copySpec -> copySpec.include(new String[]{"**/*.pdsc"}));
            task.into((Object)conversionBackupBuildDir);
        });
        project.getTasks().create(sourceSet.getTaskName("restore", "PdscBackup"), Copy.class, task -> {
            task.from((Object)conversionBackupBuildDir, copySpec -> copySpec.include(new String[]{"**/*.pdsc"}));
            task.into((Object)dataSchemaDir);
        });
        project.getTasks().create(sourceSet.getTaskName("convert", "ToPdl"), TranslateSchemasTask.class, task -> {
            task.dependsOn(new Object[]{backup});
            task.setInputDir(dataSchemaDir);
            task.setDestinationDir(dataSchemaDir);
            task.setResolverPath((FileCollection)PegasusPlugin.getDataModelConfig(project, sourceSet));
            task.setCodegenClasspath((FileCollection)project.getConfigurations().getByName("pegasusPlugin"));
            task.onlyIf(t -> task.getInputDir().exists());
            task.doLast(new CacheableAction(t -> {
                System.out.println("pdsc to pdl conversion complete.");
                System.out.println("All pdsc files in " + dataSchemaDir + " have been replaced with pdl files");
                System.out.println("The pdsc files have been backed up to: " + conversionBackupBuildDir.getAbsolutePath());
                System.out.println("If this conversion needs to be undone run the 'restorePdscBackup' task to restore the backed up pdsc files.");
                ConfigurableFileTree tree = project.fileTree((Object)dataSchemaDir);
                tree.include(new String[]{"**/*.pdsc"});
                tree.forEach(File::delete);
            }));
        });
    }

    protected void configureDataTemplateGeneration(Project project, SourceSet sourceSet) {
        File dataSchemaDir = project.file((Object)PegasusPlugin.getDataSchemaPath(project, sourceSet));
        File generatedDataTemplateDir = project.file((Object)(PegasusPlugin.getGeneratedDirPath(project, sourceSet, DATA_TEMPLATE_GEN_TYPE) + File.separatorChar + "java"));
        File publishableSchemasBuildDir = project.file((Object)(project.getBuildDir().getAbsolutePath() + File.separatorChar + sourceSet.getName() + "Schemas"));
        GenerateDataTemplateTask generateDataTemplatesTask = (GenerateDataTemplateTask)project.getTasks().create(sourceSet.getTaskName("generate", "dataTemplate"), GenerateDataTemplateTask.class, task -> {
            task.setInputDir(dataSchemaDir);
            task.setDestinationDir(generatedDataTemplateDir);
            task.setResolverPath((FileCollection)PegasusPlugin.getDataModelConfig(project, sourceSet));
            task.setCodegenClasspath((FileCollection)project.getConfigurations().getByName("pegasusPlugin"));
            task.onlyIf(t -> {
                if (task.getInputDir().exists()) {
                    Map pegasusOptions = (Map)project.getExtensions().getExtraProperties().get("pegasus");
                    return ((PegasusOptions)pegasusOptions.get(sourceSet.getName())).hasGenerationMode(PegasusOptions.GenerationMode.PEGASUS);
                }
                return false;
            });
            task.doFirst(new CacheableAction(t -> PegasusPlugin.deleteGeneratedDir(project, sourceSet, DATA_TEMPLATE_GEN_TYPE)));
        });
        ((Jar)this._generateSourcesJarTask).from(new Object[]{generateDataTemplatesTask.getDestinationDir()});
        this._generateSourcesJarTask.dependsOn(new Object[]{generateDataTemplatesTask});
        this._generateJavadocTask.source(new Object[]{generateDataTemplatesTask.getDestinationDir()});
        this._generateJavadocTask.setClasspath(this._generateJavadocTask.getClasspath().plus((FileCollection)project.getConfigurations().getByName("dataTemplateCompile")).plus(generateDataTemplatesTask.getResolverPath()));
        this._generateJavadocTask.dependsOn(new Object[]{generateDataTemplatesTask});
        project.getDependencies().add("dataTemplateCompile", (Object)"com.google.code.findbugs:jsr305:3.0.0");
        String targetSourceSetName = PegasusPlugin.getGeneratedSourceSetName(sourceSet, DATA_TEMPLATE_GEN_TYPE);
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        SourceSet targetSourceSet = (SourceSet)sourceSets.create(targetSourceSetName, ss -> {
            ss.java(sourceDirectorySet -> sourceDirectorySet.srcDir((Object)generatedDataTemplateDir));
            ss.setCompileClasspath(PegasusPlugin.getDataModelConfig(project, sourceSet).plus((FileCollection)project.getConfigurations().getByName("dataTemplateCompile")));
        });
        PegasusPlugin.addGeneratedDir(project, targetSourceSet, Arrays.asList(PegasusPlugin.getDataModelConfig(project, sourceSet), project.getConfigurations().getByName("dataTemplateCompile")));
        Task compileTask = project.getTasks().getByName(targetSourceSet.getCompileJavaTaskName());
        compileTask.dependsOn(new Object[]{generateDataTemplatesTask});
        Task destroyStaleFiles = project.getTasks().create(sourceSet.getName() + "DestroyStaleFiles");
        if (PegasusPlugin.isPropertyTrue(project, DESTROY_STALE_FILES_ENABLE) && publishableSchemasBuildDir.exists()) {
            destroyStaleFiles.getInputs().dir((Object)publishableSchemasBuildDir);
            destroyStaleFiles.doLast(new CacheableAction(task -> project.delete(new Object[]{publishableSchemasBuildDir})));
        }
        Task preparePdscSchemasForPublishTask = project.getTasks().create(sourceSet.getName() + "CopyPdscSchemas", Copy.class, task -> {
            task.from((Object)dataSchemaDir, copySpec -> copySpec.include(new String[]{"**/*.pdsc"}));
            task.into((Object)publishableSchemasBuildDir);
        });
        preparePdscSchemasForPublishTask.dependsOn(new Object[]{destroyStaleFiles});
        ArrayList<Task> dataTemplateJarDepends = new ArrayList<Task>();
        dataTemplateJarDepends.add(compileTask);
        dataTemplateJarDepends.add(preparePdscSchemasForPublishTask);
        if (PegasusPlugin.isPropertyTrue(project, PDL_ENABLE)) {
            Task preparePdlSchemasForPublishTask = project.getTasks().create(sourceSet.getName() + "TranslateSchemas", TranslateSchemasTask.class, task -> {
                task.setInputDir(dataSchemaDir);
                task.setDestinationDir(publishableSchemasBuildDir);
                task.setResolverPath((FileCollection)PegasusPlugin.getDataModelConfig(project, sourceSet));
                task.setCodegenClasspath((FileCollection)project.getConfigurations().getByName("pegasusPlugin"));
                task.setSourceFormat(SchemaFileType.PDL);
                task.setDestinationFormat(SchemaFileType.PDSC);
            });
            preparePdlSchemasForPublishTask.dependsOn(new Object[]{destroyStaleFiles});
            dataTemplateJarDepends.add(preparePdlSchemasForPublishTask);
        }
        Jar dataTemplateJarTask = (Jar)project.getTasks().create(sourceSet.getName() + "DataTemplateJar", Jar.class, task -> {
            task.dependsOn(new Object[]{dataTemplateJarDepends});
            task.from((Object)publishableSchemasBuildDir, copySpec -> copySpec.eachFile(fileCopyDetails -> fileCopyDetails.setPath("pegasus" + File.separatorChar + fileCopyDetails.getPath())));
            task.from(new Object[]{targetSourceSet.getOutput()});
            task.setAppendix(PegasusPlugin.getAppendix(sourceSet, "data-template"));
            task.setDescription("Generate a data template jar");
        });
        if (!PegasusPlugin.isTestSourceSet(sourceSet)) {
            project.getArtifacts().add("dataTemplate", (Object)dataTemplateJarTask);
        } else {
            project.getArtifacts().add("testDataTemplate", (Object)dataTemplateJarTask);
        }
        String compileConfigName = PegasusPlugin.isTestSourceSet(sourceSet) ? "testCompile" : "compile";
        Configuration compileConfig = (Configuration)project.getConfigurations().maybeCreate(compileConfigName);
        compileConfig.extendsFrom(new Configuration[]{PegasusPlugin.getDataModelConfig(project, sourceSet), project.getConfigurations().getByName("dataTemplateCompile")});
        project.getDependencies().add(compileConfigName, (Object)project.files(new Object[]{dataTemplateJarTask.getArchivePath()}));
        if (debug) {
            System.out.println("configureDataTemplateGeneration sourceSet " + sourceSet.getName());
            System.out.println(compileConfigName + ".allDependencies : " + project.getConfigurations().getByName(compileConfigName).getAllDependencies());
            System.out.println(compileConfigName + ".extendsFrom: " + project.getConfigurations().getByName(compileConfigName).getExtendsFrom());
            System.out.println(compileConfigName + ".transitive: " + project.getConfigurations().getByName(compileConfigName).isTransitive());
        }
        project.getTasks().getByName(sourceSet.getCompileJavaTaskName()).dependsOn(new Object[]{dataTemplateJarTask});
    }

    protected void configureRestClientGeneration(Project project, SourceSet sourceSet) {
        Configuration dataModels;
        File idlDir = project.file((Object)PegasusPlugin.getIdlPath(project, sourceSet));
        if (SharedFileUtils.getSuffixedFiles(project, (Object)idlDir, IDL_FILE_SUFFIX).isEmpty()) {
            return;
        }
        File generatedRestClientDir = project.file((Object)(PegasusPlugin.getGeneratedDirPath(project, sourceSet, REST_GEN_TYPE) + File.separatorChar + "java"));
        Configuration dataModelConfig = PegasusPlugin.getDataModelConfig(project, sourceSet);
        String dataTemplateSourceSetName = PegasusPlugin.getGeneratedSourceSetName(sourceSet, DATA_TEMPLATE_GEN_TYPE);
        Jar dataTemplateJarTask = null;
        SourceSetContainer sourceSets = ((JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class)).getSourceSets();
        if (sourceSets.findByName(dataTemplateSourceSetName) != null) {
            if (debug) {
                System.out.println("sourceSet " + sourceSet.getName() + " has generated sourceSet " + dataTemplateSourceSetName);
            }
            dataTemplateJarTask = (Jar)project.getTasks().getByName(sourceSet.getName() + "DataTemplateJar");
            dataModels = dataModelConfig.plus((FileCollection)project.files(new Object[]{dataTemplateJarTask.getArchivePath()}));
        } else {
            dataModels = dataModelConfig;
        }
        String targetSourceSetName = PegasusPlugin.getGeneratedSourceSetName(sourceSet, REST_GEN_TYPE);
        SourceSet targetSourceSet = (SourceSet)sourceSets.create(targetSourceSetName, arg_0 -> PegasusPlugin.lambda$configureRestClientGeneration$51(generatedRestClientDir, (FileCollection)dataModels, project, arg_0));
        project.getPlugins().withType(EclipsePlugin.class, eclipsePlugin -> {
            EclipseModel eclipseModel = (EclipseModel)project.getExtensions().findByName("eclipse");
            eclipseModel.getClasspath().getPlusConfigurations().add(project.getConfigurations().getByName("restClientCompile"));
        });
        PegasusPlugin.addGeneratedDir(project, targetSourceSet, Arrays.asList(PegasusPlugin.getDataModelConfig(project, sourceSet), project.getConfigurations().getByName("restClientCompile")));
        GenerateRestClientTask generateRestClientTask = (GenerateRestClientTask)project.getTasks().create(targetSourceSet.getTaskName("generate", "restClient"), GenerateRestClientTask.class, arg_0 -> PegasusPlugin.lambda$configureRestClientGeneration$53(project, idlDir, (FileCollection)dataModels, generatedRestClientDir, arg_0));
        if (dataTemplateJarTask != null) {
            generateRestClientTask.dependsOn(new Object[]{dataTemplateJarTask});
        }
        ((Jar)this._generateSourcesJarTask).from(new Object[]{generateRestClientTask.getDestinationDir()});
        this._generateSourcesJarTask.dependsOn(new Object[]{generateRestClientTask});
        this._generateJavadocTask.source(new Object[]{generateRestClientTask.getDestinationDir()});
        this._generateJavadocTask.setClasspath(this._generateJavadocTask.getClasspath().plus((FileCollection)project.getConfigurations().getByName("restClientCompile")).plus(generateRestClientTask.getResolverPath()));
        this._generateJavadocTask.dependsOn(new Object[]{generateRestClientTask});
        JavaCompile compileGeneratedRestClientTask = (JavaCompile)project.getTasks().getByName(targetSourceSet.getCompileJavaTaskName());
        compileGeneratedRestClientTask.dependsOn(new Object[]{generateRestClientTask});
        compileGeneratedRestClientTask.getOptions().getCompilerArgs().add("-Xlint:-deprecation");
        Task restModelJarTask = project.getTasks().create(sourceSet.getName() + "RestModelJar", Jar.class, task -> {
            task.from((Object)idlDir, copySpec -> {
                copySpec.eachFile(fileCopyDetails -> project.getLogger().info("Add idl file: {}", fileCopyDetails));
                copySpec.setIncludes(Collections.singletonList("*.restspec.json"));
            });
            task.setAppendix(PegasusPlugin.getAppendix(sourceSet, "rest-model"));
            task.setDescription("Generate rest model jar");
        });
        Task restClientJarTask = project.getTasks().create(sourceSet.getName() + "RestClientJar", Jar.class, task -> {
            task.dependsOn(new Object[]{compileGeneratedRestClientTask});
            task.from((Object)idlDir, copySpec -> {
                copySpec.eachFile(fileCopyDetails -> {
                    project.getLogger().info("Add interface file: {}", fileCopyDetails);
                    fileCopyDetails.setPath("idl" + File.separatorChar + fileCopyDetails.getPath());
                });
                copySpec.setIncludes(Collections.singletonList("*.restspec.json"));
            });
            task.from(new Object[]{targetSourceSet.getOutput()});
            task.setAppendix(PegasusPlugin.getAppendix(sourceSet, "rest-client"));
            task.setDescription("Generate rest client jar");
        });
        if (!PegasusPlugin.isTestSourceSet(sourceSet)) {
            project.getArtifacts().add("restModel", (Object)restModelJarTask);
            project.getArtifacts().add("restClient", (Object)restClientJarTask);
        } else {
            project.getArtifacts().add("testRestModel", (Object)restModelJarTask);
            project.getArtifacts().add("testRestClient", (Object)restClientJarTask);
        }
    }

    private static String getAppendix(SourceSet sourceSet, String suffix) {
        return sourceSet.getName().equals("main") ? suffix : sourceSet.getName() + '-' + suffix;
    }

    private static Project getApiProject(Project project) {
        List<String> suffixValue;
        if (project.getExtensions().getExtraProperties().has("apiProject")) {
            return (Project)project.getExtensions().getExtraProperties().get("apiProject");
        }
        List<String> subsSuffixes = project.getExtensions().getExtraProperties().has("apiProjectSubstitutionSuffixes") ? (suffixValue = (List<String>)project.getExtensions().getExtraProperties().get("apiProjectSubstitutionSuffixes")) : Arrays.asList("-impl", "-service", "-server", "-server-impl");
        for (String suffix : subsSuffixes) {
            String searchPath;
            Project apiProject;
            if (!project.getPath().endsWith(suffix) || (apiProject = project.findProject(searchPath = project.getPath().substring(0, project.getPath().length() - suffix.length()) + "-api")) == null) continue;
            return apiProject;
        }
        return project.findProject(project.getPath() + "-api");
    }

    private static Project getCheckedApiProject(Project project) {
        Project apiProject = PegasusPlugin.getApiProject(project);
        if (apiProject == project) {
            throw new GradleException("The API project of ${project.path} must not be itself.");
        }
        return apiProject;
    }

    public static String getNonEmptyProperty(Project project, String propertyName) {
        if (!project.hasProperty(propertyName)) {
            return null;
        }
        String propertyValue = project.property(propertyName).toString();
        if (propertyValue.isEmpty()) {
            return null;
        }
        return propertyValue;
    }

    public static boolean isPropertyTrue(Project project, String propertyName) {
        return project.hasProperty(propertyName) && Boolean.valueOf(project.property(propertyName).toString()) != false;
    }

    private static String createModifiedFilesMessage(Collection<String> nonEquivExpectedFiles, Collection<String> foldersToBeBuilt) {
        StringBuilder builder = new StringBuilder();
        builder.append("\nRemember to checkin the changes to the following new or modified files:\n");
        for (String file : nonEquivExpectedFiles) {
            builder.append("  ");
            builder.append(file);
            builder.append("\n");
        }
        if (!foldersToBeBuilt.isEmpty()) {
            builder.append("\nThe file modifications include service interface changes, you can build the the following projects to re-generate the client APIs accordingly:\n");
            for (String folder : foldersToBeBuilt) {
                builder.append("  ");
                builder.append(folder);
                builder.append("\n");
            }
        }
        return builder.toString();
    }

    private static String createPossibleMissingFilesMessage(Collection<String> missingFiles) {
        StringBuilder builder = new StringBuilder();
        builder.append("If this is the result of an automated build, then you may have forgotten to check in some snapshot or idl files:\n");
        for (String file : missingFiles) {
            builder.append("  ");
            builder.append(file);
            builder.append("\n");
        }
        return builder.toString();
    }

    private static String findProperty(FileCompatibilityType type) {
        String property;
        switch (type) {
            case SNAPSHOT: {
                property = SNAPSHOT_COMPAT_REQUIREMENT;
                break;
            }
            case IDL: {
                property = IDL_COMPAT_REQUIREMENT;
                break;
            }
            default: {
                throw new GradleException("No property defined for compatibility type " + (Object)((Object)type));
            }
        }
        return property;
    }

    private static Set<File> buildWatchedRestModelInputDirs(Project project, SourceSet sourceSet) {
        Map pegasusOptions = (Map)project.getExtensions().getExtraProperties().get("pegasus");
        File rootPath = new File(project.getProjectDir(), ((PegasusOptions)pegasusOptions.get((Object)sourceSet.getName())).restModelOptions.getRestResourcesRootPath());
        PegasusOptions.IdlOptions idlOptions = ((PegasusOptions)pegasusOptions.get((Object)sourceSet.getName())).idlOptions;
        return idlOptions.getIdlItems().stream().flatMap(idlItem -> Arrays.stream(idlItem.packageNames)).map(packageName -> new File(rootPath, packageName.replace('.', '/'))).collect(Collectors.toCollection(TreeSet::new));
    }

    private static <T> Set<T> difference(Set<T> left, Set<T> right) {
        HashSet<T> result = new HashSet<T>(left);
        result.removeAll(right);
        return result;
    }

    private static /* synthetic */ void lambda$configureRestClientGeneration$53(Project project, File idlDir, FileCollection dataModels, File generatedRestClientDir, GenerateRestClientTask task) {
        task.dependsOn(new Object[]{project.getConfigurations().getByName("dataTemplate")});
        task.setInputDir(idlDir);
        task.setResolverPath(dataModels);
        task.setRuntimeClasspath(project.getConfigurations().getByName("dataModel").plus(project.getConfigurations().getByName("dataTemplate").getArtifacts().getFiles()));
        task.setCodegenClasspath((FileCollection)project.getConfigurations().getByName("pegasusPlugin"));
        task.setDestinationDir(generatedRestClientDir);
        task.setRestli2FormatSuppressed(project.hasProperty(SUPPRESS_REST_CLIENT_RESTLI_2));
    }

    private static /* synthetic */ void lambda$configureRestClientGeneration$51(File generatedRestClientDir, FileCollection dataModels, Project project, SourceSet ss) {
        ss.java(sourceDirectorySet -> sourceDirectorySet.srcDir((Object)generatedRestClientDir));
        ss.setCompileClasspath(dataModels.plus((FileCollection)project.getConfigurations().getByName("restClientCompile")));
    }
}

