/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;

public class SharedFileUtils {
    public static FileTree getSuffixedFiles(Project project, Object baseDir, String suffix) {
        return SharedFileUtils.getSuffixedFiles(project, baseDir, Collections.singletonList(suffix));
    }

    public static FileTree getSuffixedFiles(Project project, Object baseDir, Collection<String> suffixes) {
        List includes = suffixes.stream().map(suffix -> "**" + File.separatorChar + "*" + suffix).collect(Collectors.toList());
        return project.fileTree(baseDir, fileTree -> fileTree.include((Iterable)includes));
    }

    public static FileCollection getIdlFiles(Project project, Object destinationDirPrefix) {
        return SharedFileUtils.getSuffixedFiles(project, (Object)project.file((Object)(destinationDirPrefix + "idl")), ".restspec.json");
    }

    public static FileCollection getSnapshotFiles(Project project, Object destinationDirPrefix) {
        return SharedFileUtils.getSuffixedFiles(project, (Object)project.file((Object)(destinationDirPrefix + "snapshot")), ".snapshot.json");
    }
}

