/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import com.linkedin.pegasus.gradle.IOUtil;
import com.linkedin.pegasus.gradle.internal.CompatibilityLogChecker;
import com.linkedin.pegasus.gradle.internal.FileExtensionFilter;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class CheckIdlTask
extends DefaultTask {
    private final FileExtensionFilter _idlFilter = new FileExtensionFilter(".restspec.json");
    private FileCollection _currentIdlFiles;
    private File _previousIdlDirectory;
    private FileCollection _resolverPath;
    private FileCollection _codegenClasspath;
    private String _idlCompatLevel;
    private File _summaryTarget = new File(this.getProject().getBuildDir(), "reports/checkIdl/summary.txt");
    private boolean _modelCompatible = true;
    private boolean _restSpecCompatible = true;
    private boolean _equivalent = true;
    private String _wholeMessage = "";

    @TaskAction
    public void check() {
        this.getProject().getLogger().info("Checking interface compatibility with API ...");
        List<String> errorFilePairs = this.findErrorFilePairs();
        CompatibilityLogChecker logChecker = new CompatibilityLogChecker();
        this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setMain("com.linkedin.restli.tools.idlcheck.RestLiResourceModelCompatibilityChecker");
            javaExecSpec.setClasspath(this._codegenClasspath);
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.resolver.path=" + this._resolverPath.getAsPath()});
            javaExecSpec.args(new Object[]{"--compat", this._idlCompatLevel});
            javaExecSpec.args(new Object[]{"--report"});
            javaExecSpec.args((Iterable)errorFilePairs);
            javaExecSpec.setStandardOutput((OutputStream)logChecker);
        });
        this._modelCompatible = logChecker.isModelCompatible();
        this._restSpecCompatible = logChecker.isRestSpecCompatible();
        this._equivalent = logChecker.getModelCompatibility().isEmpty() && logChecker.getRestSpecCompatibility().isEmpty();
        this._wholeMessage = logChecker.getWholeText();
        IOUtil.writeText(this._summaryTarget, this._wholeMessage);
        if (!this._modelCompatible || !this._restSpecCompatible) {
            throw new GradleException("See output for " + this.getPath() + ". Summary written to " + this._summaryTarget.getAbsolutePath());
        }
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCurrentIdlFiles() {
        return this._currentIdlFiles;
    }

    public void setCurrentIdlFiles(FileCollection currentIdlFiles) {
        this._currentIdlFiles = currentIdlFiles;
    }

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPreviousIdlDirectory() {
        return this._previousIdlDirectory;
    }

    public void setPreviousIdlDirectory(File previousIdlDirectory) {
        this._previousIdlDirectory = previousIdlDirectory;
    }

    @Classpath
    public FileCollection getResolverPath() {
        return this._resolverPath;
    }

    public void setResolverPath(FileCollection resolverPath) {
        this._resolverPath = resolverPath;
    }

    @Classpath
    public FileCollection getCodegenClasspath() {
        return this._codegenClasspath;
    }

    public void setCodegenClasspath(FileCollection codegenClasspath) {
        this._codegenClasspath = codegenClasspath;
    }

    @Input
    public String getIdlCompatLevel() {
        return this._idlCompatLevel;
    }

    public void setIdlCompatLevel(String idlCompatLevel) {
        this._idlCompatLevel = idlCompatLevel;
    }

    @OutputFile
    public File getSummaryTarget() {
        return this._summaryTarget;
    }

    public void setSummaryTarget(File summaryTarget) {
        this._summaryTarget = summaryTarget;
    }

    @Deprecated
    public boolean getIsModelCompatible() {
        return this.isModelCompatible();
    }

    @Deprecated
    public boolean isIsModelCompatible() {
        return this.isModelCompatible();
    }

    @Internal
    public boolean isModelCompatible() {
        return this._modelCompatible;
    }

    @Deprecated
    public boolean getIsRestSpecCompatible() {
        return this.isRestSpecCompatible();
    }

    @Deprecated
    public boolean isIsRestSpecCompatible() {
        return this.isRestSpecCompatible();
    }

    @Internal
    public boolean isRestSpecCompatible() {
        return this._restSpecCompatible;
    }

    @Deprecated
    public boolean getIsEquivalent() {
        return this._equivalent;
    }

    @Deprecated
    public boolean isIsEquivalent() {
        return this._equivalent;
    }

    @Internal
    public boolean isEquivalent() {
        return this._equivalent;
    }

    @Internal
    public String getWholeMessage() {
        return this._wholeMessage;
    }

    private List<String> findErrorFilePairs() {
        ArrayList<String> errorFilePairs = new ArrayList<String>();
        Set apiExistingFilePaths = Arrays.stream(this._previousIdlDirectory.listFiles(this._idlFilter)).map(File::getAbsolutePath).collect(Collectors.toSet());
        for (File currentIdlFile : this._currentIdlFiles) {
            String expectedOldFilePath = this._previousIdlDirectory.getPath() + File.separatorChar + currentIdlFile.getName();
            File expectedFile = this.getProject().file((Object)expectedOldFilePath);
            if (expectedFile.exists()) {
                apiExistingFilePaths.remove(expectedOldFilePath);
                errorFilePairs.add(expectedFile.getAbsolutePath());
                errorFilePairs.add(currentIdlFile.getPath());
                continue;
            }
            errorFilePairs.add("");
            errorFilePairs.add(currentIdlFile.getPath());
        }
        for (String apiExistingFilePath : apiExistingFilePaths) {
            errorFilePairs.add(apiExistingFilePath);
            errorFilePairs.add("");
        }
        return errorFilePairs;
    }
}

