/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import com.linkedin.pegasus.gradle.IOUtil;
import com.linkedin.pegasus.gradle.internal.CompatibilityLogChecker;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class CheckRestModelTask
extends DefaultTask {
    private FileCollection _currentSnapshotFiles;
    private File _previousSnapshotDirectory;
    private FileCollection _currentIdlFiles;
    private File _previousIdlDirectory;
    private FileCollection _codegenClasspath;
    private String _modelCompatLevel;
    private File _summaryTarget = new File(this.getProject().getBuildDir(), "reports/checkRestModel/summary.txt");
    private boolean _modelCompatible = true;
    private boolean _restSpecCompatible = true;
    private boolean _equivalent = true;
    private boolean _restSpecEquivalent = true;
    private String _wholeMessage = "";

    @TaskAction
    public void check() {
        this.getProject().getLogger().info("Checking interface compatibility with API ...");
        ArrayList<String> argFiles = new ArrayList<String>();
        argFiles.addAll(this.findMatchingFiles(".snapshot.json", this._currentSnapshotFiles, (FileCollection)this.getProject().fileTree((Object)this._previousSnapshotDirectory), false));
        argFiles.addAll(this.findMatchingFiles(".restspec.json", this._currentIdlFiles, (FileCollection)this.getProject().fileTree((Object)this._previousIdlDirectory), true));
        if (argFiles.isEmpty()) {
            return;
        }
        CompatibilityLogChecker logChecker = new CompatibilityLogChecker();
        this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setMain("com.linkedin.restli.tools.snapshot.check.RestLiSnapshotCompatibilityChecker");
            javaExecSpec.setClasspath(this._codegenClasspath);
            javaExecSpec.args(new Object[]{"--compat", this._modelCompatLevel.toLowerCase()});
            javaExecSpec.args(new Object[]{"--report"});
            javaExecSpec.args((Iterable)argFiles);
            javaExecSpec.setStandardOutput((OutputStream)logChecker);
        });
        this._modelCompatible = logChecker.isModelCompatible();
        this._restSpecCompatible = logChecker.isRestSpecCompatible();
        this._equivalent = logChecker.getModelCompatibility().isEmpty() && logChecker.getRestSpecCompatibility().isEmpty();
        this._restSpecEquivalent = logChecker.getRestSpecCompatibility().isEmpty();
        this._wholeMessage = logChecker.getWholeText();
        IOUtil.writeText(this._summaryTarget, this._wholeMessage);
        if (!this._modelCompatible || !this._restSpecCompatible) {
            throw new GradleException("See output for " + this.getPath() + ". Summary written to " + this._summaryTarget.getAbsolutePath());
        }
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCurrentSnapshotFiles() {
        return this._currentSnapshotFiles;
    }

    public void setCurrentSnapshotFiles(FileCollection currentSnapshotFiles) {
        this._currentSnapshotFiles = currentSnapshotFiles;
    }

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPreviousSnapshotDirectory() {
        return this._previousSnapshotDirectory;
    }

    public void setPreviousSnapshotDirectory(File previousSnapshotDirectory) {
        this._previousSnapshotDirectory = previousSnapshotDirectory;
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCurrentIdlFiles() {
        return this._currentIdlFiles;
    }

    public void setCurrentIdlFiles(FileCollection currentIdlFiles) {
        this._currentIdlFiles = currentIdlFiles;
    }

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getPreviousIdlDirectory() {
        return this._previousIdlDirectory;
    }

    public void setPreviousIdlDirectory(File previousIdlDirectory) {
        this._previousIdlDirectory = previousIdlDirectory;
    }

    @Classpath
    public FileCollection getCodegenClasspath() {
        return this._codegenClasspath;
    }

    public void setCodegenClasspath(FileCollection codegenClasspath) {
        this._codegenClasspath = codegenClasspath;
    }

    @Input
    public String getModelCompatLevel() {
        return this._modelCompatLevel;
    }

    public void setModelCompatLevel(String modelCompatLevel) {
        this._modelCompatLevel = modelCompatLevel;
    }

    @OutputFile
    public File getSummaryTarget() {
        return this._summaryTarget;
    }

    public void setSummaryTarget(File summaryTarget) {
        this._summaryTarget = summaryTarget;
    }

    @Deprecated
    public boolean getIsModelCompatible() {
        return this.isModelCompatible();
    }

    @Deprecated
    public boolean isIsModelCompatible() {
        return this.isModelCompatible();
    }

    @Internal
    public boolean isModelCompatible() {
        return this._modelCompatible;
    }

    @Deprecated
    public boolean getIsRestSpecCompatible() {
        return this.isRestSpecCompatible();
    }

    @Deprecated
    public boolean isIsRestSpecCompatible() {
        return this.isRestSpecCompatible();
    }

    @Internal
    public boolean isRestSpecCompatible() {
        return this._restSpecCompatible;
    }

    @Deprecated
    public boolean getIsEquivalent() {
        return this.isEquivalent();
    }

    @Deprecated
    public boolean isIsEquivalent() {
        return this.isEquivalent();
    }

    @Internal
    public boolean isEquivalent() {
        return this._equivalent;
    }

    @Deprecated
    public boolean getIsRestSpecEquivalent() {
        return this.isRestSpecEquivalent();
    }

    @Deprecated
    public boolean isIsRestSpecEquivalent() {
        return this.isRestSpecEquivalent();
    }

    @Internal
    public boolean isRestSpecEquivalent() {
        return this._restSpecEquivalent;
    }

    @Internal
    public String getWholeMessage() {
        return this._wholeMessage;
    }

    List<String> findMatchingFiles(String ext, FileCollection currentFiles, FileCollection previousFiles, boolean diffOnly) {
        Map<String, String> currentFilenameToAbsolutePath = CheckRestModelTask.createMapFromFiles(currentFiles, ext);
        Map<String, String> previousFilenameToAbsolutePath = CheckRestModelTask.createMapFromFiles(previousFiles, ext);
        ArrayList<String> filePairs = new ArrayList<String>();
        currentFilenameToAbsolutePath.forEach((filename, absolutePath) -> {
            if (previousFilenameToAbsolutePath.containsKey(filename)) {
                if (!diffOnly) {
                    filePairs.add((String)previousFilenameToAbsolutePath.get(filename));
                    filePairs.add((String)absolutePath);
                }
                previousFilenameToAbsolutePath.remove(filename);
            } else {
                filePairs.add("");
                filePairs.add((String)absolutePath);
            }
        });
        previousFilenameToAbsolutePath.forEach((filename, absolutePath) -> {
            filePairs.add((String)absolutePath);
            filePairs.add("");
        });
        return filePairs;
    }

    private static Map<String, String> createMapFromFiles(FileCollection currentFiles, String ext) {
        FileCollection files = currentFiles.filter(file -> file.getName().endsWith(ext));
        return StreamSupport.stream(files.spliterator(), false).collect(Collectors.toMap(File::getName, File::getAbsolutePath, (oldFileName, newFileName) -> newFileName));
    }
}

