/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import com.linkedin.pegasus.gradle.IOUtil;
import com.linkedin.pegasus.gradle.internal.CompatibilityLogChecker;
import com.linkedin.pegasus.gradle.internal.FileExtensionFilter;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class CheckSnapshotTask
extends DefaultTask {
    private static final FileExtensionFilter SNAPSHOT_FILTER = new FileExtensionFilter(".snapshot.json");
    private FileCollection _currentSnapshotFiles;
    private File _previousSnapshotDirectory;
    private FileCollection _codegenClasspath;
    private String _snapshotCompatLevel;
    private File _summaryTarget = new File(this.getProject().getBuildDir(), "reports/checkSnapshot/summary.txt");
    private boolean _modelCompatible = true;
    private boolean _restSpecCompatible = true;
    private boolean _equivalent = true;
    private boolean _restSpecEquivalent = true;
    private String _wholeMessage = "";

    @TaskAction
    public void check() {
        this.getProject().getLogger().info("Checking interface compatibility with API ...");
        ArrayList<String> argFiles = new ArrayList<String>();
        this.checkSnapshotCompatibility(this.getProject(), this._currentSnapshotFiles, this._previousSnapshotDirectory, SNAPSHOT_FILTER, argFiles);
        if (argFiles.isEmpty()) {
            return;
        }
        CompatibilityLogChecker logChecker = new CompatibilityLogChecker();
        this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setMain("com.linkedin.restli.tools.snapshot.check.RestLiSnapshotCompatibilityChecker");
            javaExecSpec.setClasspath(this._codegenClasspath);
            javaExecSpec.args(new Object[]{"--compat", this._snapshotCompatLevel});
            javaExecSpec.args(new Object[]{"--report"});
            javaExecSpec.args((Iterable)argFiles);
            javaExecSpec.setStandardOutput((OutputStream)logChecker);
        });
        this._modelCompatible = logChecker.isModelCompatible();
        this._restSpecCompatible = logChecker.isRestSpecCompatible();
        this._equivalent = logChecker.getModelCompatibility().isEmpty() && logChecker.getRestSpecCompatibility().isEmpty();
        this._restSpecEquivalent = logChecker.getRestSpecCompatibility().isEmpty();
        this._wholeMessage = logChecker.getWholeText();
        IOUtil.writeText(this._summaryTarget, this._wholeMessage);
        if (!this._modelCompatible || !this._restSpecCompatible) {
            throw new GradleException("See output for " + this.getPath() + ". Summary written to " + this._summaryTarget.getAbsolutePath());
        }
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileCollection getCurrentSnapshotFiles() {
        return this._currentSnapshotFiles;
    }

    public void setCurrentSnapshotFiles(FileCollection currentSnapshotFiles) {
        this._currentSnapshotFiles = currentSnapshotFiles;
    }

    @InputDirectory
    public File getPreviousSnapshotDirectory() {
        return this._previousSnapshotDirectory;
    }

    public void setPreviousSnapshotDirectory(File previousSnapshotDirectory) {
        this._previousSnapshotDirectory = previousSnapshotDirectory;
    }

    @Classpath
    public FileCollection getCodegenClasspath() {
        return this._codegenClasspath;
    }

    public void setCodegenClasspath(FileCollection codegenClasspath) {
        this._codegenClasspath = codegenClasspath;
    }

    @Input
    public String getSnapshotCompatLevel() {
        return this._snapshotCompatLevel;
    }

    public void setSnapshotCompatLevel(String snapshotCompatLevel) {
        this._snapshotCompatLevel = snapshotCompatLevel;
    }

    @OutputFile
    public File getSummaryTarget() {
        return this._summaryTarget;
    }

    public void setSummaryTarget(File summaryTarget) {
        this._summaryTarget = summaryTarget;
    }

    @Deprecated
    public boolean getIsModelCompatible() {
        return this.isModelCompatible();
    }

    @Deprecated
    public boolean isIsModelCompatible() {
        return this.isModelCompatible();
    }

    @Internal
    public boolean isModelCompatible() {
        return this._modelCompatible;
    }

    @Deprecated
    public boolean getIsRestSpecCompatible() {
        return this.isRestSpecCompatible();
    }

    @Deprecated
    public boolean isIsRestSpecCompatible() {
        return this.isRestSpecCompatible();
    }

    @Internal
    public boolean isRestSpecCompatible() {
        return this._restSpecCompatible;
    }

    @Deprecated
    public boolean getIsEquivalent() {
        return this.isEquivalent();
    }

    @Deprecated
    public boolean isIsEquivalent() {
        return this.isEquivalent();
    }

    @Internal
    public boolean isEquivalent() {
        return this._equivalent;
    }

    @Deprecated
    public boolean getIsRestSpecEquivalent() {
        return this.isRestSpecEquivalent();
    }

    @Deprecated
    public boolean isIsRestSpecEquivalent() {
        return this.isRestSpecEquivalent();
    }

    @Internal
    public boolean isRestSpecEquivalent() {
        return this._restSpecEquivalent;
    }

    @Internal
    public String getWholeMessage() {
        return this._wholeMessage;
    }

    private void checkSnapshotCompatibility(Project project, FileCollection currentFiles, File previousDirectory, FileExtensionFilter filter, List<String> fileArgs) {
        boolean isCheckRestSpecVsSnapshot = filter.getSuffix().equals(".restspec.json");
        for (File currentFile : currentFiles) {
            String apiFilePath;
            File apiFile;
            String apiFilename;
            this.getProject().getLogger().info("Checking interface file: {}", (Object)currentFile.getPath());
            if (isCheckRestSpecVsSnapshot) {
                String fileName = currentFile.getName().substring(0, currentFile.getName().length() - ".snapshot.json".length());
                apiFilename = fileName + ".restspec.json";
            } else {
                apiFilename = currentFile.getName();
            }
            if (!(apiFile = project.file((Object)(apiFilePath = previousDirectory.getPath() + File.separatorChar + apiFilename))).exists()) continue;
            fileArgs.add(apiFilePath);
            fileArgs.add(currentFile.getPath());
        }
    }
}

