/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import com.linkedin.pegasus.gradle.PathingJarUtil;
import com.linkedin.pegasus.gradle.PegasusPlugin;
import com.linkedin.pegasus.gradle.SharedFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateDataTemplateTask
extends DefaultTask {
    private File _destinationDir;
    private File _inputDir;
    private FileCollection _resolverPath;
    private FileCollection _codegenClasspath;

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getInputDir() {
        return this._inputDir;
    }

    public void setInputDir(File inputDir) {
        this._inputDir = inputDir;
    }

    @Classpath
    public FileCollection getResolverPath() {
        return this._resolverPath;
    }

    public void setResolverPath(FileCollection resolverPath) {
        this._resolverPath = resolverPath;
    }

    @Classpath
    public FileCollection getCodegenClasspath() {
        return this._codegenClasspath;
    }

    public void setCodegenClasspath(FileCollection codegenClasspath) {
        this._codegenClasspath = codegenClasspath;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this._destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this._destinationDir = destinationDir;
    }

    @TaskAction
    public void generate() {
        FileCollection _pathedCodegenClasspath;
        FileTree inputDataSchemaFiles = SharedFileUtils.getSuffixedFiles(this.getProject(), (Object)this._inputDir, PegasusPlugin.DATA_TEMPLATE_FILE_SUFFIXES);
        List inputDataSchemaFilenames = StreamSupport.stream(inputDataSchemaFiles.spliterator(), false).map(File::getPath).collect(Collectors.toList());
        if (inputDataSchemaFilenames.isEmpty()) {
            this.getLogger().lifecycle("There are no data schema input files. Skip generating data template.");
            return;
        }
        this.getLogger().lifecycle("There are {} data schema input files. Using input root folder: {}", new Object[]{inputDataSchemaFilenames.size(), this._inputDir});
        this._destinationDir.mkdirs();
        String resolverPathStr = this._resolverPath.plus((FileCollection)this.getProject().files(new Object[]{this._inputDir})).getAsPath();
        try {
            _pathedCodegenClasspath = PathingJarUtil.generatePathingJar(this.getProject(), "generateDataTemplate", this._codegenClasspath, true);
        }
        catch (IOException e) {
            throw new GradleException("Error occurred generating pathing JAR.", (Throwable)e);
        }
        this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setMain("com.linkedin.pegasus.generator.PegasusDataTemplateGenerator");
            javaExecSpec.setClasspath(_pathedCodegenClasspath);
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.resolver.path=" + resolverPathStr});
            javaExecSpec.jvmArgs(new Object[]{"-Droot.path=" + this.getProject().getRootDir().getPath()});
            javaExecSpec.args(new Object[]{this._destinationDir.getPath()});
            javaExecSpec.args(new Object[]{this._inputDir});
        });
    }
}

