/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import com.linkedin.pegasus.gradle.PegasusOptions;
import com.linkedin.pegasus.gradle.SharedFileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateRestClientTask
extends DefaultTask {
    private File _inputDir;
    private FileCollection _resolverPath;
    private FileCollection _runtimeClasspath;
    private FileCollection _codegenClasspath;
    private File _destinationDir;
    private boolean _restli2FormatSuppressed;
    private boolean _restli1BuildersDeprecated = true;

    @TaskAction
    public void generate() {
        PegasusOptions.ClientOptions pegasusClientOptions = new PegasusOptions.ClientOptions();
        for (File input : this.getProject().files(new Object[]{this._inputDir})) {
            if (!input.isDirectory()) continue;
            for (Object f : SharedFileUtils.getSuffixedFiles(this.getProject(), (Object)input, ".restspec.json")) {
                if (pegasusClientOptions.hasRestModelFileName(((File)f).getName())) continue;
                pegasusClientOptions.addClientItem(((File)f).getName(), "", false);
                this.getProject().getLogger().lifecycle("Add interface file: {}", new Object[]{((File)f).getPath()});
            }
        }
        if (pegasusClientOptions.getClientItems().isEmpty()) {
            return;
        }
        this.getProject().getLogger().info("Generating REST client builders ...");
        String resolverPathStr = this._resolverPath.getAsPath();
        this._destinationDir.mkdirs();
        HashMap<String, List> version1Files = new HashMap<String, List>();
        HashMap<String, List> version2Files = new HashMap<String, List>();
        this.getProject().getLogger().lifecycle("Destination directory: {}", new Object[]{this._destinationDir});
        for (PegasusOptions.ClientItem clientItem : pegasusClientOptions.getClientItems()) {
            this.getProject().getLogger().lifecycle("Generating rest client source files for: {}", new Object[]{clientItem.restModelFileName});
            String defaultPackage2 = clientItem.defaultPackage.equals("") && this.getProject().hasProperty("idlDefaultPackage") ? (String)this.getProject().property("idlDefaultPackage") : clientItem.defaultPackage;
            String restModelFilePath = this._inputDir.toString() + File.separatorChar + clientItem.restModelFileName;
            version1Files.computeIfAbsent(defaultPackage2, key -> new ArrayList()).add(restModelFilePath);
            if (this._restli2FormatSuppressed) continue;
            version2Files.computeIfAbsent(defaultPackage2, key -> new ArrayList()).add(restModelFilePath);
        }
        String deprecatedVersion = this._restli1BuildersDeprecated ? "2.0.0" : null;
        version1Files.forEach((defaultPackage, files) -> this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setClasspath(this._runtimeClasspath.plus(this._codegenClasspath));
            javaExecSpec.setMain("com.linkedin.restli.tools.clientgen.RestRequestBuilderGenerator");
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.resolver.path=" + resolverPathStr});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.default.package=" + defaultPackage});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.generate.imported=false"});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.rest.generate.datatemplates=false"});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.rest.generate.version=1.0.0"});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.rest.generate.deprecated.version=" + deprecatedVersion});
            javaExecSpec.jvmArgs(new Object[]{"-Droot.path=" + this.getProject().getRootDir().getPath()});
            javaExecSpec.args(new Object[]{this._destinationDir.getAbsolutePath()});
            javaExecSpec.args((Iterable)files);
        }).assertNormalExitValue());
        version2Files.forEach((defaultPackage, files) -> this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setClasspath(this._runtimeClasspath.plus(this._codegenClasspath));
            javaExecSpec.setMain("com.linkedin.restli.tools.clientgen.RestRequestBuilderGenerator");
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.resolver.path=" + resolverPathStr});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.default.package=" + defaultPackage});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.generate.imported=false"});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.rest.generate.datatemplates=false"});
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.rest.generate.version=2.0.0"});
            javaExecSpec.jvmArgs(new Object[]{"-Droot.path=" + this.getProject().getRootDir().getPath()});
            javaExecSpec.args(new Object[]{this._destinationDir.getAbsolutePath()});
            javaExecSpec.args((Iterable)files);
        }).assertNormalExitValue());
    }

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getInputDir() {
        return this._inputDir;
    }

    public void setInputDir(File inputDir) {
        this._inputDir = inputDir;
    }

    @Classpath
    public FileCollection getResolverPath() {
        return this._resolverPath;
    }

    public void setResolverPath(FileCollection resolverPath) {
        this._resolverPath = resolverPath;
    }

    @Classpath
    public FileCollection getRuntimeClasspath() {
        return this._runtimeClasspath;
    }

    public void setRuntimeClasspath(FileCollection runtimeClasspath) {
        this._runtimeClasspath = runtimeClasspath;
    }

    @Classpath
    public FileCollection getCodegenClasspath() {
        return this._codegenClasspath;
    }

    public void setCodegenClasspath(FileCollection codegenClasspath) {
        this._codegenClasspath = codegenClasspath;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this._destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this._destinationDir = destinationDir;
    }

    @Deprecated
    public boolean getIsRestli2FormatSuppressed() {
        return this.isRestli2FormatSuppressed();
    }

    @Deprecated
    public boolean isIsRestli2FormatSuppressed() {
        return this.isRestli2FormatSuppressed();
    }

    @Internal
    public boolean isRestli2FormatSuppressed() {
        return this._restli2FormatSuppressed;
    }

    @Deprecated
    public void setIsRestli2FormatSuppressed(boolean restli2FormatSuppressed) {
        this.setRestli2FormatSuppressed(restli2FormatSuppressed);
    }

    public void setRestli2FormatSuppressed(boolean restli2FormatSuppressed) {
        this._restli2FormatSuppressed = restli2FormatSuppressed;
    }

    @Deprecated
    public boolean get_isRestli1BuildersDeprecated() {
        return this.isRestli1BuildersDeprecated();
    }

    @Deprecated
    public boolean is_isRestli1BuildersDeprecated() {
        return this.isRestli1BuildersDeprecated();
    }

    @Internal
    public boolean isRestli1BuildersDeprecated() {
        return this._restli1BuildersDeprecated;
    }

    @Deprecated
    public void set_isRestli1BuildersDeprecated(boolean restli1BuildersDeprecated) {
        this.setRestli1BuildersDeprecated(restli1BuildersDeprecated);
    }

    public void setRestli1BuildersDeprecated(boolean restli1BuildersDeprecated) {
        this._restli1BuildersDeprecated = restli1BuildersDeprecated;
    }
}

