/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import com.linkedin.pegasus.gradle.PathingJarUtil;
import com.linkedin.pegasus.gradle.PegasusOptions;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class GenerateRestModelTask
extends DefaultTask {
    public static final String INCLUDED_SOURCE_TYPES_PROPERTY = "pegasus.generateRestModel.includedSourceTypes";
    private FileCollection _watchedCodegenClasspath;
    private Set<File> _watchedInputDirs;
    private FileCollection _resolverPath;
    private File _idlDestinationDir;
    private File _snapshotDestinationDir;
    private PegasusOptions.IdlOptions _idlOptions;
    private FileCollection _pathedCodegenClasspath;
    private FileCollection _codegenClasspath;
    private Set<File> _inputDirs;

    @TaskAction
    public void generate() {
        boolean loadAdditionalDocProviders;
        List<String> inputDirPaths = this._inputDirs.stream().map(File::getPath).collect(Collectors.toList());
        this.getProject().getLogger().debug("GenerateRestModel using input directories {}", inputDirPaths);
        this.getProject().getLogger().debug("GenerateRestModel using destination dir {}", (Object)this._idlDestinationDir.getPath());
        this._snapshotDestinationDir.mkdirs();
        this._idlDestinationDir.mkdirs();
        List includedSourceTypes = (List)this.getProject().findProperty(INCLUDED_SOURCE_TYPES_PROPERTY);
        boolean ignoreNonJavaFiles = includedSourceTypes != null && includedSourceTypes.size() == 1 && includedSourceTypes.contains("JAVA");
        try {
            this._pathedCodegenClasspath = PathingJarUtil.generatePathingJar(this.getProject(), "generateRestModel", this._codegenClasspath, ignoreNonJavaFiles);
        }
        catch (IOException e) {
            throw new GradleException("Error occurred generating pathing JAR.", (Throwable)e);
        }
        boolean bl = loadAdditionalDocProviders = !ignoreNonJavaFiles && this.getProject().getTasks().findByName("scaladoc") != null;
        if (this._idlOptions.getIdlItems().isEmpty()) {
            this.executeSnapshotExporter(inputDirPaths, this._snapshotDestinationDir.getPath(), loadAdditionalDocProviders);
            this.executeResourceExporter(inputDirPaths, this._idlDestinationDir.getPath(), loadAdditionalDocProviders);
        } else {
            for (PegasusOptions.IdlItem idlItem : this._idlOptions.getIdlItems()) {
                if (idlItem.apiName.isEmpty()) {
                    this.getProject().getLogger().info("Generating interface for unnamed api ...");
                } else {
                    this.getProject().getLogger().info("Generating interface for api: {} ...", (Object)idlItem.apiName);
                }
                this.executeSnapshotExporter(idlItem.apiName, inputDirPaths, Arrays.asList(idlItem.packageNames), this._snapshotDestinationDir.getPath(), loadAdditionalDocProviders);
                this.executeResourceExporter(idlItem.apiName, inputDirPaths, Arrays.asList(idlItem.packageNames), this._idlDestinationDir.getPath(), loadAdditionalDocProviders);
            }
        }
    }

    @Classpath
    public FileCollection getWatchedCodegenClasspath() {
        return this._watchedCodegenClasspath;
    }

    public void setWatchedCodegenClasspath(FileCollection watchedCodegenClasspath) {
        this._watchedCodegenClasspath = watchedCodegenClasspath;
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public Set<File> getWatchedInputDirs() {
        return this._watchedInputDirs;
    }

    public void setWatchedInputDirs(Set<File> watchedInputDirs) {
        this._watchedInputDirs = watchedInputDirs;
    }

    @Classpath
    public FileCollection getResolverPath() {
        return this._resolverPath;
    }

    public void setResolverPath(FileCollection resolverPath) {
        this._resolverPath = resolverPath;
    }

    @OutputDirectory
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    public File getIdlDestinationDir() {
        return this._idlDestinationDir;
    }

    public void setIdlDestinationDir(File idlDestinationDir) {
        this._idlDestinationDir = idlDestinationDir;
    }

    @OutputDirectory
    public File getSnapshotDestinationDir() {
        return this._snapshotDestinationDir;
    }

    public void setSnapshotDestinationDir(File snapshotDestinationDir) {
        this._snapshotDestinationDir = snapshotDestinationDir;
    }

    @Internal
    public PegasusOptions.IdlOptions getIdlOptions() {
        return this._idlOptions;
    }

    public void setIdlOptions(PegasusOptions.IdlOptions idlOptions) {
        this._idlOptions = idlOptions;
    }

    @Internal
    public FileCollection getCodegenClasspath() {
        return this._codegenClasspath;
    }

    public void setCodegenClasspath(FileCollection codegenClasspath) {
        this._codegenClasspath = codegenClasspath;
    }

    @Internal
    public Set<File> getInputDirs() {
        return this._inputDirs;
    }

    public void setInputDirs(Set<File> inputDirs) {
        this._inputDirs = inputDirs;
    }

    private void executeSnapshotExporter(List<String> inputDirs, String destinationPath, boolean additionalDocProviders) {
        this.executeSnapshotExporter(null, inputDirs, null, destinationPath, additionalDocProviders);
    }

    private void executeSnapshotExporter(String name, List<String> inputDirs, List<String> packages, String destinationPath, boolean additionalDocProviders) {
        this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setMain("com.linkedin.restli.tools.snapshot.gen.RestLiSnapshotExporterCmdLineApp");
            javaExecSpec.setClasspath(this._pathedCodegenClasspath);
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.resolver.path=" + this._resolverPath.getAsPath()});
            javaExecSpec.systemProperty("scala.usejavacp", (Object)"true");
            if (name != null) {
                javaExecSpec.args(new Object[]{"-name", name});
            }
            javaExecSpec.args(GenerateRestModelTask.prepend("-sourcepath", inputDirs));
            javaExecSpec.args(new Object[]{"-outdir", destinationPath});
            if (packages != null) {
                javaExecSpec.args(GenerateRestModelTask.prepend("-resourcepackages", packages));
            }
            if (additionalDocProviders) {
                javaExecSpec.args(new Object[]{"-loadAdditionalDocProviders"});
            }
        });
    }

    private void executeResourceExporter(List<String> inputDirs, String destinationPath, boolean additionalDocProviders) {
        this.executeResourceExporter(null, inputDirs, null, destinationPath, additionalDocProviders);
    }

    private void executeResourceExporter(String name, List<String> inputDirs, List<String> packages, String destinationPath, boolean additionalDocProviders) {
        this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setMain("com.linkedin.restli.tools.idlgen.RestLiResourceModelExporterCmdLineApp");
            javaExecSpec.setClasspath(this._pathedCodegenClasspath);
            javaExecSpec.systemProperty("scala.usejavacp", (Object)"true");
            if (name != null) {
                javaExecSpec.args(new Object[]{"-name", name});
            }
            javaExecSpec.args(GenerateRestModelTask.prepend("-sourcepath", inputDirs));
            javaExecSpec.args(new Object[]{"-outdir", destinationPath});
            if (packages != null) {
                javaExecSpec.args(GenerateRestModelTask.prepend("-resourcepackages", packages));
            }
            if (additionalDocProviders) {
                javaExecSpec.args(new Object[]{"-loadAdditionalDocProviders"});
            }
        });
    }

    private static <T> List<T> prepend(T first, List<T> rest) {
        return Stream.concat(Stream.of(first), rest.stream()).collect(Collectors.toList());
    }
}

