/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import com.linkedin.pegasus.gradle.SharedFileUtils;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Copy;
import org.gradle.api.tasks.Internal;

@CacheableTask
public class PublishRestModelTask
extends Copy {
    private String _suffix;

    public void copy() {
        if (this.getSource().isEmpty()) {
            this.getProject().getLogger().error("No interface file is found. Skip publishing interface.");
            return;
        }
        this.getProject().getLogger().lifecycle("Publishing rest model to API project ...");
        FileTree apiRestModelFiles = SharedFileUtils.getSuffixedFiles(this.getProject(), (Object)this.getDestinationDir(), this._suffix);
        int apiRestModelFileCount = apiRestModelFiles.getFiles().size();
        super.copy();
        if (apiRestModelFileCount != 0 && apiRestModelFileCount != apiRestModelFiles.getFiles().size()) {
            this.getProject().getLogger().warn("{} files count changed after publish. You may have duplicate files with different names.", (Object)this._suffix);
        }
    }

    @Internal
    public String getSuffix() {
        return this._suffix;
    }

    public void setSuffix(String suffix) {
        this._suffix = suffix;
    }
}

