/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.pegasus.gradle.tasks;

import com.linkedin.pegasus.gradle.SchemaFileType;
import java.io.File;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.FileCollection;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
public class TranslateSchemasTask
extends DefaultTask {
    private File _inputDir;
    private FileCollection _resolverPath;
    private FileCollection _codegenClasspath;
    private File _destinationDir;
    private SchemaFileType _sourceFormat = SchemaFileType.PDSC;
    private SchemaFileType _destinationFormat = SchemaFileType.PDL;

    @TaskAction
    public void translate() {
        this.getProject().getLogger().info("Translating data schemas ...");
        this._destinationDir.mkdirs();
        String resolverPathStr = this._resolverPath.plus((FileCollection)this.getProject().files(new Object[]{this._inputDir})).getAsPath();
        this.getProject().javaexec(javaExecSpec -> {
            javaExecSpec.setMain("com.linkedin.restli.tools.data.SchemaFormatTranslator");
            javaExecSpec.setClasspath(this._codegenClasspath);
            javaExecSpec.jvmArgs(new Object[]{"-Dgenerator.resolver.path=" + resolverPathStr});
            javaExecSpec.args(new Object[]{"--source-format"});
            javaExecSpec.args(new Object[]{this._sourceFormat.getFileExtension()});
            javaExecSpec.args(new Object[]{"--destination-format"});
            javaExecSpec.args(new Object[]{this._destinationFormat.getFileExtension()});
            javaExecSpec.args(new Object[]{resolverPathStr});
            javaExecSpec.args(new Object[]{this._inputDir.getAbsolutePath()});
            javaExecSpec.args(new Object[]{this._destinationDir.getAbsolutePath()});
        });
    }

    @InputDirectory
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public File getInputDir() {
        return this._inputDir;
    }

    public void setInputDir(File inputDir) {
        this._inputDir = inputDir;
    }

    @Classpath
    public FileCollection getResolverPath() {
        return this._resolverPath;
    }

    public void setResolverPath(FileCollection resolverPath) {
        this._resolverPath = resolverPath;
    }

    @Classpath
    public FileCollection getCodegenClasspath() {
        return this._codegenClasspath;
    }

    public void setCodegenClasspath(FileCollection codegenClasspath) {
        this._codegenClasspath = codegenClasspath;
    }

    @OutputDirectory
    public File getDestinationDir() {
        return this._destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this._destinationDir = destinationDir;
    }

    @Internal
    public SchemaFileType getSourceFormat() {
        return this._sourceFormat;
    }

    public void setSourceFormat(SchemaFileType sourceFormat) {
        this._sourceFormat = sourceFormat;
    }

    @Internal
    public SchemaFileType getDestinationFormat() {
        return this._destinationFormat;
    }

    public void setDestinationFormat(SchemaFileType destinationFormat) {
        this._destinationFormat = destinationFormat;
    }
}

