/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls;

import com.linkedin.urls.UrlUtil;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;

class PathNormalizer {
    PathNormalizer() {
    }

    protected String normalizePath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            return path;
        }
        path = UrlUtil.decode(path);
        path = PathNormalizer.sanitizeDotsAndSlashes(path);
        return UrlUtil.encode(path);
    }

    private static String sanitizeDotsAndSlashes(String path) {
        StringBuilder stringBuilder = new StringBuilder(path);
        Stack<Integer> slashIndexStack = new Stack<Integer>();
        for (int index = 0; index < stringBuilder.length() - 1; ++index) {
            if (stringBuilder.charAt(index) != '/') continue;
            slashIndexStack.add(index);
            if (stringBuilder.charAt(index + 1) == '.') {
                boolean endOfPath;
                if (index < stringBuilder.length() - 2 && stringBuilder.charAt(index + 2) == '.') {
                    if ((index >= stringBuilder.length() - 3 || stringBuilder.charAt(index + 3) != '/') && index != stringBuilder.length() - 3) continue;
                    endOfPath = index == stringBuilder.length() - 3;
                    slashIndexStack.pop();
                    int endIndex = index + 3;
                    index = slashIndexStack.empty() ? -1 : (Integer)slashIndexStack.pop() - 1;
                    int startIndex = endOfPath ? index + 1 : index;
                    stringBuilder.delete(startIndex + 1, endIndex);
                    continue;
                }
                if ((index >= stringBuilder.length() - 2 || stringBuilder.charAt(index + 2) != '/') && index != stringBuilder.length() - 2) continue;
                endOfPath = index == stringBuilder.length() - 2;
                slashIndexStack.pop();
                int startIndex = endOfPath ? index + 1 : index;
                stringBuilder.delete(startIndex, index + 2);
                --index;
                continue;
            }
            if (stringBuilder.charAt(index + 1) != '/') continue;
            slashIndexStack.pop();
            stringBuilder.deleteCharAt(index);
            --index;
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("/");
        }
        return stringBuilder.toString();
    }
}

