/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls;

import com.linkedin.urls.NormalizedUrl;
import com.linkedin.urls.UrlMarker;
import com.linkedin.urls.UrlPart;
import com.linkedin.urls.UrlUtil;
import com.linkedin.urls.detection.UrlDetector;
import com.linkedin.urls.detection.UrlDetectorOptions;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Url {
    private static final String DEFAULT_SCHEME = "http";
    private static final Map<String, Integer> SCHEME_PORT_MAP = new HashMap<String, Integer>();
    private UrlMarker _urlMarker;
    private String _scheme;
    private String _username;
    private String _password;
    private String _host;
    private int _port = 0;
    private String _path;
    private String _query;
    private String _fragment;
    private String _originalUrl;

    protected Url(UrlMarker urlMarker) {
        this._urlMarker = urlMarker;
        this._originalUrl = urlMarker.getOriginalUrl();
    }

    public static Url create(String url) throws MalformedURLException {
        String formattedString = UrlUtil.removeSpecialSpaces(url.trim().replace(" ", "%20"));
        List<Url> urls = new UrlDetector(formattedString, UrlDetectorOptions.ALLOW_SINGLE_LEVEL_DOMAIN).detect();
        if (urls.size() == 1) {
            return urls.get(0);
        }
        if (urls.size() == 0) {
            throw new MalformedURLException("We couldn't find any urls in string: " + url);
        }
        throw new MalformedURLException("We found more than one url in string: " + url);
    }

    public NormalizedUrl normalize() {
        return new NormalizedUrl(this._urlMarker);
    }

    public String toString() {
        return this.getFullUrl();
    }

    public String getFullUrl() {
        return this.getFullUrlWithoutFragment() + StringUtils.defaultString((String)this.getFragment());
    }

    public String getFullUrlWithoutFragment() {
        StringBuilder url = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.getScheme())) {
            url.append(this.getScheme());
            url.append(":");
        }
        url.append("//");
        if (!StringUtils.isEmpty((CharSequence)this.getUsername())) {
            url.append(this.getUsername());
            if (!StringUtils.isEmpty((CharSequence)this.getPassword())) {
                url.append(":");
                url.append(this.getPassword());
            }
            url.append("@");
        }
        url.append(this.getHost());
        if (this.getPort() > 0 && this.getPort() != SCHEME_PORT_MAP.get(this.getScheme()).intValue()) {
            url.append(":");
            url.append(this.getPort());
        }
        url.append(this.getPath());
        url.append(this.getQuery());
        return url.toString();
    }

    public String getScheme() {
        if (this._scheme == null) {
            if (this.exists(UrlPart.SCHEME)) {
                this._scheme = this.getPart(UrlPart.SCHEME);
                int index = this._scheme.indexOf(":");
                if (index != -1) {
                    this._scheme = this._scheme.substring(0, index);
                }
            } else if (!this._originalUrl.startsWith("//")) {
                this._scheme = DEFAULT_SCHEME;
            }
        }
        return StringUtils.defaultString((String)this._scheme);
    }

    public String getUsername() {
        if (this._username == null) {
            this.populateUsernamePassword();
        }
        return StringUtils.defaultString((String)this._username);
    }

    public String getPassword() {
        if (this._password == null) {
            this.populateUsernamePassword();
        }
        return StringUtils.defaultString((String)this._password);
    }

    public String getHost() {
        if (this._host == null) {
            this._host = this.getPart(UrlPart.HOST);
            if (this.exists(UrlPart.PORT)) {
                this._host = this._host.substring(0, this._host.length() - 1);
            }
        }
        return this._host;
    }

    public int getPort() {
        if (this._port == 0) {
            String portString = this.getPart(UrlPart.PORT);
            if (portString != null && !portString.isEmpty()) {
                try {
                    this._port = Integer.parseInt(portString);
                }
                catch (NumberFormatException e) {
                    this._port = -1;
                }
            } else {
                this._port = SCHEME_PORT_MAP.containsKey(this.getScheme()) ? SCHEME_PORT_MAP.get(this.getScheme()) : -1;
            }
        }
        return this._port;
    }

    public String getPath() {
        if (this._path == null) {
            this._path = this.exists(UrlPart.PATH) ? this.getPart(UrlPart.PATH) : "/";
        }
        return this._path;
    }

    public String getQuery() {
        if (this._query == null) {
            this._query = this.getPart(UrlPart.QUERY);
        }
        return StringUtils.defaultString((String)this._query);
    }

    public String getFragment() {
        if (this._fragment == null) {
            this._fragment = this.getPart(UrlPart.FRAGMENT);
        }
        return StringUtils.defaultString((String)this._fragment);
    }

    public byte[] getHostBytes() {
        return null;
    }

    public String getOriginalUrl() {
        return this._originalUrl;
    }

    private void populateUsernamePassword() {
        if (this.exists(UrlPart.USERNAME_PASSWORD)) {
            String usernamePassword = this.getPart(UrlPart.USERNAME_PASSWORD);
            String[] usernamePasswordParts = usernamePassword.substring(0, usernamePassword.length() - 1).split(":");
            if (usernamePasswordParts.length == 1) {
                this._username = usernamePasswordParts[0];
            } else if (usernamePasswordParts.length == 2) {
                this._username = usernamePasswordParts[0];
                this._password = usernamePasswordParts[1];
            }
        }
    }

    private boolean exists(UrlPart urlPart) {
        return urlPart != null && this._urlMarker.indexOf(urlPart) >= 0;
    }

    private UrlPart nextExistingPart(UrlPart urlPart) {
        UrlPart nextPart = urlPart.getNextPart();
        if (this.exists(nextPart)) {
            return nextPart;
        }
        if (nextPart == null) {
            return null;
        }
        return this.nextExistingPart(nextPart);
    }

    private String getPart(UrlPart part) {
        if (!this.exists(part)) {
            return null;
        }
        UrlPart nextPart = this.nextExistingPart(part);
        if (nextPart == null) {
            return this._originalUrl.substring(this._urlMarker.indexOf(part));
        }
        return this._originalUrl.substring(this._urlMarker.indexOf(part), this._urlMarker.indexOf(nextPart));
    }

    protected void setRawPath(String path) {
        this._path = path;
    }

    protected void setRawHost(String host) {
        this._host = host;
    }

    protected String getRawPath() {
        return this._path;
    }

    protected String getRawHost() {
        return this._host;
    }

    protected UrlMarker getUrlMarker() {
        return this._urlMarker;
    }

    static {
        SCHEME_PORT_MAP.put(DEFAULT_SCHEME, 80);
        SCHEME_PORT_MAP.put("https", 443);
        SCHEME_PORT_MAP.put("ftp", 21);
    }
}

