/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls;

import com.linkedin.urls.detection.CharUtils;
import com.linkedin.urls.detection.InputTextReader;
import java.util.Stack;

class UrlUtil {
    protected static String decode(String url) {
        StringBuilder stringBuilder = new StringBuilder(url);
        Stack<Integer> nonDecodedPercentIndices = new Stack<Integer>();
        for (int i = 0; i < stringBuilder.length() - 2; ++i) {
            char curr = stringBuilder.charAt(i);
            if (curr != '%') continue;
            if (CharUtils.isHex(stringBuilder.charAt(i + 1)) && CharUtils.isHex(stringBuilder.charAt(i + 2))) {
                char decodedChar = String.format("%s", Character.valueOf((char)Short.parseShort(stringBuilder.substring(i + 1, i + 3), 16))).charAt(0);
                stringBuilder.delete(i, i + 3);
                stringBuilder.insert(i, decodedChar);
                if (decodedChar == '%') {
                    --i;
                    continue;
                }
                if (!nonDecodedPercentIndices.isEmpty() && CharUtils.isHex(decodedChar) && CharUtils.isHex(stringBuilder.charAt(i - 1)) && i - (Integer)nonDecodedPercentIndices.peek() == 2) {
                    i = (Integer)nonDecodedPercentIndices.pop() - 1;
                    continue;
                }
                if (nonDecodedPercentIndices.isEmpty() || i != stringBuilder.length() - 2) continue;
                i = (Integer)nonDecodedPercentIndices.pop() - 1;
                continue;
            }
            nonDecodedPercentIndices.add(i);
        }
        return stringBuilder.toString();
    }

    protected static String removeSpecialSpaces(String urlPart) {
        StringBuilder stringBuilder = new StringBuilder(urlPart);
        for (int i = 0; i < stringBuilder.length(); ++i) {
            char curr = stringBuilder.charAt(i);
            if (!CharUtils.isWhiteSpace(curr)) continue;
            stringBuilder.deleteCharAt(i);
        }
        return stringBuilder.toString();
    }

    protected static String encode(String url) {
        StringBuilder encoder = new StringBuilder();
        for (char chr : url.toCharArray()) {
            byte chrByte = (byte)chr;
            if (chrByte <= 32 || chrByte >= 127 || chr == '#' || chr == '%') {
                encoder.append(String.format("%%%02X", chrByte));
                continue;
            }
            encoder.append(chr);
        }
        return encoder.toString();
    }

    protected static String removeExtraDots(String host) {
        StringBuilder stringBuilder = new StringBuilder();
        InputTextReader reader = new InputTextReader(host);
        while (!reader.eof()) {
            char curr = reader.read();
            stringBuilder.append(curr);
            if (curr != '.') continue;
            char possibleDot = curr;
            while (possibleDot == '.' && !reader.eof()) {
                possibleDot = reader.read();
            }
            if (possibleDot == '.') continue;
            stringBuilder.append(possibleDot);
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '.') {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '.') {
            stringBuilder.deleteCharAt(0);
        }
        return stringBuilder.toString();
    }

    private UrlUtil() {
    }
}

