/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.urls.detection;

import com.linkedin.urls.Url;
import com.linkedin.urls.UrlMarker;
import com.linkedin.urls.UrlPart;
import com.linkedin.urls.detection.CharUtils;
import com.linkedin.urls.detection.DomainNameReader;
import com.linkedin.urls.detection.InputTextReader;
import com.linkedin.urls.detection.UrlDetectorOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UrlDetector {
    private static final String HTML_MAILTO = "mailto:";
    private static final Set<String> VALID_SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http://", "https://", "ftp://", "ftps://", "http%3a//", "https%3a//", "ftp%3a//", "ftps%3a//")));
    private final UrlDetectorOptions _options;
    private final InputTextReader _reader;
    private StringBuilder _buffer = new StringBuilder();
    private boolean _hasScheme = false;
    private boolean _quoteStart = false;
    private boolean _singleQuoteStart = false;
    private boolean _dontMatchIpv6 = false;
    private ArrayList<Url> _urlList = new ArrayList();
    private HashMap<Character, Integer> _characterMatch = new HashMap();
    private UrlMarker _currentUrlMarker = new UrlMarker();

    public UrlDetector(String content, UrlDetectorOptions options) {
        this._reader = new InputTextReader(content);
        this._options = options;
    }

    public int getBacktracked() {
        return this._reader.getBacktrackedCount();
    }

    public List<Url> detect() {
        this.readDefault();
        return this._urlList;
    }

    private void readDefault() {
        int length = 0;
        block9: while (!this._reader.eof()) {
            char curr = this._reader.read();
            switch (curr) {
                case ' ': {
                    if (this._options.hasFlag(UrlDetectorOptions.ALLOW_SINGLE_LEVEL_DOMAIN) && this._buffer.length() > 0 && this._hasScheme) {
                        this._reader.goBack();
                        this.readDomainName(this._buffer.substring(length));
                    }
                    this._buffer.append(curr);
                    this.readEnd(ReadEndState.InvalidUrl);
                    length = 0;
                    continue block9;
                }
                case '%': {
                    if (!this._reader.canReadChars(2)) continue block9;
                    if (this._reader.peek(2).equalsIgnoreCase("3a")) {
                        this._buffer.append(curr);
                        this._buffer.append(this._reader.read());
                        this._buffer.append(this._reader.read());
                        length = this.processColon(length);
                        continue block9;
                    }
                    if (!CharUtils.isHex(this._reader.peekChar(0)) || !CharUtils.isHex(this._reader.peekChar(1))) continue block9;
                    this._buffer.append(curr);
                    this._buffer.append(this._reader.read());
                    this._buffer.append(this._reader.read());
                    this.readDomainName(this._buffer.substring(length));
                    length = 0;
                    continue block9;
                }
                case '.': 
                case '\u3002': 
                case '\uff0e': 
                case '\uff61': {
                    this._buffer.append(curr);
                    this.readDomainName(this._buffer.substring(length));
                    length = 0;
                    continue block9;
                }
                case '@': {
                    if (this._buffer.length() <= 0) continue block9;
                    this._currentUrlMarker.setIndex(UrlPart.USERNAME_PASSWORD, length);
                    this._buffer.append(curr);
                    this.readDomainName(null);
                    length = 0;
                    continue block9;
                }
                case '[': {
                    if (this._dontMatchIpv6 && this.checkMatchingCharacter(curr) != CharacterMatch.CharacterNotMatched) {
                        this.readEnd(ReadEndState.InvalidUrl);
                        length = 0;
                    }
                    int beginning = this._reader.getPosition();
                    if (!this._hasScheme) {
                        this._buffer.delete(0, this._buffer.length());
                    }
                    this._buffer.append(curr);
                    if (!this.readDomainName(this._buffer.substring(length))) {
                        this._reader.seek(beginning);
                        this._dontMatchIpv6 = true;
                    }
                    length = 0;
                    continue block9;
                }
                case '/': {
                    if (this._hasScheme || this._options.hasFlag(UrlDetectorOptions.ALLOW_SINGLE_LEVEL_DOMAIN) && this._buffer.length() > 1) {
                        this._reader.goBack();
                        this.readDomainName(this._buffer.substring(length));
                        length = 0;
                        continue block9;
                    }
                    this.readEnd(ReadEndState.InvalidUrl);
                    this._buffer.append(curr);
                    this._hasScheme = this.readHtml5Root();
                    length = this._buffer.length();
                    continue block9;
                }
                case ':': {
                    this._buffer.append(curr);
                    length = this.processColon(length);
                    continue block9;
                }
            }
            if (this.checkMatchingCharacter(curr) != CharacterMatch.CharacterNotMatched) {
                this.readEnd(ReadEndState.InvalidUrl);
                length = 0;
                continue;
            }
            this._buffer.append(curr);
        }
        if (this._options.hasFlag(UrlDetectorOptions.ALLOW_SINGLE_LEVEL_DOMAIN) && this._buffer.length() > 0 && this._hasScheme) {
            this.readDomainName(this._buffer.substring(length));
        }
    }

    private int processColon(int length) {
        if (this._hasScheme) {
            if (!this.readUserPass(length) && this._buffer.length() > 0) {
                this._reader.goBack();
                this._buffer.delete(this._buffer.length() - 1, this._buffer.length());
                int backtrackOnFail = this._reader.getPosition() - this._buffer.length() + length;
                if (!this.readDomainName(this._buffer.substring(length))) {
                    this._reader.seek(backtrackOnFail);
                    this.readEnd(ReadEndState.InvalidUrl);
                }
                length = 0;
            }
        } else if (this.readScheme() && this._buffer.length() > 0) {
            this._hasScheme = true;
            length = this._buffer.length();
        } else if (this._buffer.length() > 0 && this._options.hasFlag(UrlDetectorOptions.ALLOW_SINGLE_LEVEL_DOMAIN) && this._reader.canReadChars(1)) {
            this._reader.goBack();
            this._buffer.delete(this._buffer.length() - 1, this._buffer.length());
            this.readDomainName(this._buffer.toString());
        } else {
            this.readEnd(ReadEndState.InvalidUrl);
            length = 0;
        }
        return length;
    }

    private int getCharacterCount(char curr) {
        Integer count = this._characterMatch.get(Character.valueOf(curr));
        return count == null ? 0 : count;
    }

    private CharacterMatch checkMatchingCharacter(char curr) {
        if (curr == '\"' && this._options.hasFlag(UrlDetectorOptions.QUOTE_MATCH) || curr == '\'' && this._options.hasFlag(UrlDetectorOptions.SINGLE_QUOTE_MATCH)) {
            boolean quoteStart;
            if (curr == '\"') {
                quoteStart = this._quoteStart;
                this._quoteStart = true;
            } else {
                quoteStart = this._singleQuoteStart;
                this._singleQuoteStart = true;
            }
            Integer currVal = this.getCharacterCount(curr) + 1;
            this._characterMatch.put(Character.valueOf(curr), currVal);
            return quoteStart || currVal % 2 == 0 ? CharacterMatch.CharacterMatchStop : CharacterMatch.CharacterMatchStart;
        }
        if (this._options.hasFlag(UrlDetectorOptions.BRACKET_MATCH) && (curr == '[' || curr == '{' || curr == '(')) {
            this._characterMatch.put(Character.valueOf(curr), this.getCharacterCount(curr) + 1);
            return CharacterMatch.CharacterMatchStart;
        }
        if (this._options.hasFlag(UrlDetectorOptions.XML) && curr == '<') {
            this._characterMatch.put(Character.valueOf(curr), this.getCharacterCount(curr) + 1);
            return CharacterMatch.CharacterMatchStart;
        }
        if (this._options.hasFlag(UrlDetectorOptions.BRACKET_MATCH) && (curr == ']' || curr == '}' || curr == ')') || this._options.hasFlag(UrlDetectorOptions.XML) && curr == '>') {
            Integer currVal = this.getCharacterCount(curr) + 1;
            this._characterMatch.put(Character.valueOf(curr), currVal);
            char match = '\u0000';
            switch (curr) {
                case ']': {
                    match = '[';
                    break;
                }
                case '}': {
                    match = '{';
                    break;
                }
                case ')': {
                    match = '(';
                    break;
                }
                case '>': {
                    match = '<';
                    break;
                }
            }
            return this.getCharacterCount(match) > currVal ? CharacterMatch.CharacterMatchStop : CharacterMatch.CharacterMatchStart;
        }
        return CharacterMatch.CharacterNotMatched;
    }

    private boolean readHtml5Root() {
        if (this._reader.eof()) {
            return false;
        }
        char curr = this._reader.read();
        if (curr == '/') {
            this._buffer.append(curr);
            return true;
        }
        this._reader.goBack();
        this.readEnd(ReadEndState.InvalidUrl);
        return false;
    }

    private boolean readScheme() {
        if (this._options.hasFlag(UrlDetectorOptions.HTML) && this._buffer.length() >= HTML_MAILTO.length() && HTML_MAILTO.equalsIgnoreCase(this._buffer.substring(this._buffer.length() - HTML_MAILTO.length()))) {
            return this.readEnd(ReadEndState.InvalidUrl);
        }
        int originalLength = this._buffer.length();
        int numSlashes = 0;
        while (!this._reader.eof()) {
            char curr = this._reader.read();
            if (curr == '/') {
                this._buffer.append(curr);
                if (numSlashes == 1) {
                    if (VALID_SCHEMES.contains(this._buffer.toString().toLowerCase())) {
                        this._currentUrlMarker.setIndex(UrlPart.SCHEME, 0);
                        return true;
                    }
                    return false;
                }
                ++numSlashes;
                continue;
            }
            if (curr == ' ' || this.checkMatchingCharacter(curr) != CharacterMatch.CharacterNotMatched) {
                this._buffer.append(curr);
                return false;
            }
            if (curr == '[') {
                this._reader.goBack();
                return false;
            }
            if (originalLength <= 0 && numSlashes <= 0 && CharUtils.isAlpha(curr)) continue;
            this._reader.goBack();
            return this.readUserPass(0);
        }
        return false;
    }

    private boolean readUserPass(int beginningOfUsername) {
        int start = this._buffer.length();
        boolean done = false;
        boolean rollback = false;
        while (!done && !this._reader.eof()) {
            char curr = this._reader.read();
            if (curr == '@') {
                this._buffer.append(curr);
                this._currentUrlMarker.setIndex(UrlPart.USERNAME_PASSWORD, beginningOfUsername);
                return this.readDomainName("");
            }
            if (CharUtils.isDot(curr) || curr == '[') {
                this._buffer.append(curr);
                rollback = true;
                continue;
            }
            if (curr == '#' || curr == ' ' || curr == '/' || this.checkMatchingCharacter(curr) != CharacterMatch.CharacterNotMatched) {
                rollback = true;
                done = true;
                continue;
            }
            this._buffer.append(curr);
        }
        if (rollback) {
            int distance = this._buffer.length() - start;
            this._buffer.delete(start, this._buffer.length());
            int currIndex = Math.max(this._reader.getPosition() - distance - (done ? 1 : 0), 0);
            this._reader.seek(currIndex);
            return false;
        }
        return this.readEnd(ReadEndState.InvalidUrl);
    }

    private boolean readDomainName(String current) {
        int hostIndex = current == null ? this._buffer.length() : this._buffer.length() - current.length();
        this._currentUrlMarker.setIndex(UrlPart.HOST, hostIndex);
        DomainNameReader reader = new DomainNameReader(this._reader, this._buffer, current, this._options, new DomainNameReader.CharacterHandler(){

            @Override
            public void addCharacter(char character) {
                UrlDetector.this.checkMatchingCharacter(character);
            }
        });
        DomainNameReader.ReaderNextState state = reader.readDomainName();
        switch (state) {
            case ValidDomainName: {
                return this.readEnd(ReadEndState.ValidUrl);
            }
            case ReadFragment: {
                return this.readFragment();
            }
            case ReadPath: {
                return this.readPath();
            }
            case ReadPort: {
                return this.readPort();
            }
            case ReadQueryString: {
                return this.readQueryString();
            }
        }
        return this.readEnd(ReadEndState.InvalidUrl);
    }

    private boolean readFragment() {
        this._currentUrlMarker.setIndex(UrlPart.FRAGMENT, this._buffer.length() - 1);
        while (!this._reader.eof()) {
            char curr = this._reader.read();
            if (curr == ' ' || this.checkMatchingCharacter(curr) != CharacterMatch.CharacterNotMatched) {
                return this.readEnd(ReadEndState.ValidUrl);
            }
            this._buffer.append(curr);
        }
        return this.readEnd(ReadEndState.ValidUrl);
    }

    private boolean readQueryString() {
        this._currentUrlMarker.setIndex(UrlPart.QUERY, this._buffer.length() - 1);
        while (!this._reader.eof()) {
            char curr = this._reader.read();
            if (curr == '#') {
                this._buffer.append(curr);
                return this.readFragment();
            }
            if (curr == ' ' || this.checkMatchingCharacter(curr) != CharacterMatch.CharacterNotMatched) {
                return this.readEnd(ReadEndState.ValidUrl);
            }
            this._buffer.append(curr);
        }
        return this.readEnd(ReadEndState.ValidUrl);
    }

    private boolean readPort() {
        this._currentUrlMarker.setIndex(UrlPart.PORT, this._buffer.length());
        int portLen = 0;
        while (!this._reader.eof()) {
            char curr = this._reader.read();
            ++portLen;
            if (curr == '/') {
                this._buffer.append(curr);
                return this.readPath();
            }
            if (curr == '?') {
                this._buffer.append(curr);
                return this.readQueryString();
            }
            if (curr == '#') {
                this._buffer.append(curr);
                return this.readFragment();
            }
            if (this.checkMatchingCharacter(curr) == CharacterMatch.CharacterMatchStop || !CharUtils.isNumeric(curr)) {
                this._reader.goBack();
                if (portLen == 1) {
                    this._buffer.delete(this._buffer.length() - 1, this._buffer.length());
                }
                this._currentUrlMarker.unsetIndex(UrlPart.PORT);
                return this.readEnd(ReadEndState.ValidUrl);
            }
            this._buffer.append(curr);
        }
        return this.readEnd(ReadEndState.ValidUrl);
    }

    private boolean readPath() {
        this._currentUrlMarker.setIndex(UrlPart.PATH, this._buffer.length() - 1);
        while (!this._reader.eof()) {
            char curr = this._reader.read();
            if (curr == ' ' || this.checkMatchingCharacter(curr) != CharacterMatch.CharacterNotMatched) {
                return this.readEnd(ReadEndState.ValidUrl);
            }
            this._buffer.append(curr);
            if (curr == '?') {
                return this.readQueryString();
            }
            if (curr != '#') continue;
            return this.readFragment();
        }
        return this.readEnd(ReadEndState.ValidUrl);
    }

    private boolean readEnd(ReadEndState state) {
        if (state == ReadEndState.ValidUrl && this._buffer.length() > 0) {
            int len = this._buffer.length();
            if (this._quoteStart && this._buffer.charAt(len - 1) == '\"') {
                this._buffer.delete(len - 1, len);
            }
            if (this._buffer.length() > 0) {
                this._currentUrlMarker.setOriginalUrl(this._buffer.toString());
                this._urlList.add(this._currentUrlMarker.createUrl());
            }
        }
        this._buffer.delete(0, this._buffer.length());
        this._quoteStart = false;
        this._hasScheme = false;
        this._dontMatchIpv6 = false;
        this._currentUrlMarker = new UrlMarker();
        return state == ReadEndState.ValidUrl;
    }

    public static enum ReadEndState {
        ValidUrl,
        InvalidUrl;

    }

    private static enum CharacterMatch {
        CharacterNotMatched,
        CharacterMatchStop,
        CharacterMatchStart;

    }
}

