/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.snowflake.sequence;

import com.twitter.snowflake.exception.SnowFlakeException;
import com.twitter.snowflake.sequence.BitsAllocator;
import com.twitter.snowflake.sequence.IdSequence;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class SnowFlakeSequence
implements IdSequence {
    private TimeUnit timeUnit;
    private long epochTimestamp;
    private long workerId;
    private BitsAllocator bitsAllocator;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowFlakeSequence(int timeBits, int workerBits, int seqBits, long epochTimestamp, long workerId) {
        this.bitsAllocator = new BitsAllocator(timeBits, workerBits, seqBits);
        if (workerId > this.bitsAllocator.getMaxWorkerId()) {
            throw new SnowFlakeException("Worker id " + workerId + " exceeds the max " + this.bitsAllocator.getMaxWorkerId());
        }
        this.workerId = workerId;
        if (epochTimestamp > this.bitsAllocator.getMaxDeltaTime()) {
            throw new SnowFlakeException("epoch timestamp " + epochTimestamp + " exceeds the max " + this.bitsAllocator.getMaxDeltaTime());
        }
        this.epochTimestamp = epochTimestamp;
    }

    public SnowFlakeSequence(TimeUnit timeUnit, int timeBits, int workerBits, int seqBits, long epochTimestamp, long workerId) {
        this.timeUnit = timeUnit;
        this.bitsAllocator = new BitsAllocator(timeBits, workerBits, seqBits);
        if (workerId > this.bitsAllocator.getMaxWorkerId()) {
            throw new SnowFlakeException("Worker id " + workerId + " exceeds the max " + this.bitsAllocator.getMaxWorkerId());
        }
        this.workerId = workerId;
        this.epochTimestamp = epochTimestamp;
    }

    @Override
    public synchronized long nextId() {
        long currentTime = this.getTimestamp();
        if (currentTime < this.lastTimestamp) {
            long refusedTimeStamp = this.lastTimestamp - currentTime;
            throw new SnowFlakeException("Clock moved backwards. Refusing for %s timeStamp", refusedTimeStamp);
        }
        if (currentTime == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & this.bitsAllocator.getMaxSequence();
            if (this.sequence == 0L) {
                currentTime = this.getNextTime(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTime;
        return this.bitsAllocator.allocate(currentTime - this.epochTimestamp, this.workerId, this.sequence);
    }

    @Override
    public String parse(long id) {
        long totalBits = 64L;
        long signBits = this.bitsAllocator.getSignBits();
        long timestampBits = this.bitsAllocator.getTimestampBits();
        long workerIdBits = this.bitsAllocator.getWorkerIdBits();
        long sequenceBits = this.bitsAllocator.getSequenceBits();
        long sequence = id << (int)(totalBits - sequenceBits) >>> (int)(totalBits - sequenceBits);
        long workerId = id << (int)(timestampBits + signBits) >>> (int)(totalBits - workerIdBits);
        long deltaMillis = id >>> (int)(workerIdBits + sequenceBits);
        Date thatTime = new Date(this.timeUnit.toMillis(this.epochTimestamp + deltaMillis));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        String thatTimeStr = simpleDateFormat.format(thatTime);
        return String.format("{\"id\":\"%d\",\"timestamp\":\"%s\",\"workerId\":\"%d\",\"sequence\":\"%d\"}", id, thatTimeStr, workerId, sequence);
    }

    private long getNextTime(long lastTimestamp) {
        long timestamp = this.getTimestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getTimestamp();
        }
        return timestamp;
    }

    private long getTimestamp() {
        long millis = System.currentTimeMillis();
        long timestamp = this.timeUnit.convert(millis, TimeUnit.MILLISECONDS);
        if (timestamp - this.epochTimestamp > this.bitsAllocator.getMaxDeltaTime()) {
            throw new SnowFlakeException("Timestamp bits is exhausted. Refusing UID generate. Now: " + timestamp);
        }
        return timestamp;
    }
}

