/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.snowflake.support;

import com.twitter.snowflake.sequence.IdSequence;
import com.twitter.snowflake.sequence.SnowFlakeSequence;
import com.twitter.snowflake.support.IdSequenceFactory;
import com.twitter.snowflake.worker.WorkerIdAssigner;
import java.util.concurrent.TimeUnit;

public class ElasticIdSequenceFactory
implements IdSequenceFactory {
    protected int timeBits;
    protected int workerBits;
    protected int seqBits;
    protected long epochTimestamp;
    protected TimeUnit timeUnit;

    @Override
    public IdSequence create(WorkerIdAssigner workerIdAssigner) {
        return this.create(workerIdAssigner.assignWorkerId());
    }

    @Override
    public IdSequence create(long workerId) {
        return new SnowFlakeSequence(this.timeUnit, this.timeBits, this.workerBits, this.seqBits, this.epochTimestamp, workerId);
    }

    public void setTimeBits(int timeBits) {
        this.timeBits = timeBits;
    }

    public void setWorkerBits(int workerBits) {
        this.workerBits = workerBits;
    }

    public void setSeqBits(int seqBits) {
        this.seqBits = seqBits;
    }

    public void setEpochTimestamp(long epochTimestamp) {
        this.epochTimestamp = epochTimestamp;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}

