/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.snowflake.support;

import com.twitter.snowflake.sequence.IdGenerator;
import com.twitter.snowflake.sequence.SnowFlakeGenerator;
import com.twitter.snowflake.support.IdGeneratorFactory;
import com.twitter.snowflake.worker.WorkerIdAssigner;
import java.util.concurrent.TimeUnit;

public class ElasticIdGeneratorFactory
implements IdGeneratorFactory {
    protected int timeBits;
    protected int workerBits;
    protected int seqBits;
    protected long epochTimestamp;
    protected TimeUnit timeUnit;

    @Override
    public IdGenerator create(WorkerIdAssigner workerIdAssigner) {
        return this.create(workerIdAssigner.assignWorkerId());
    }

    @Override
    public IdGenerator create(long workerId) {
        return new SnowFlakeGenerator(this.timeUnit, this.timeBits, this.workerBits, this.seqBits, this.epochTimestamp, workerId);
    }

    public void setTimeBits(int timeBits) {
        this.timeBits = timeBits;
    }

    public void setWorkerBits(int workerBits) {
        this.workerBits = workerBits;
    }

    public void setSeqBits(int seqBits) {
        this.seqBits = seqBits;
    }

    public void setEpochTimestamp(long epochTimestamp) {
        this.epochTimestamp = epochTimestamp;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }
}

