/*
 * Decompiled with CFR 0.152.
 */
package com.littlenb.snowflake.sequence;

import com.littlenb.snowflake.exception.SnowFlakeException;

public class BitsAllocator {
    public static final int TOTAL_BITS = 64;
    private int signBits = 1;
    private final int timestampBits;
    private final int workerIdBits;
    private final int sequenceBits;
    private final long maxDeltaTime;
    private final long maxWorkerId;
    private final long maxSequence;
    private final int timestampShift;
    private final int workerIdShift;

    public BitsAllocator(int timestampBits, int workerIdBits, int sequenceBits) {
        int allocateTotalBits = this.signBits + timestampBits + workerIdBits + sequenceBits;
        if (allocateTotalBits != 64) {
            throw new SnowFlakeException("allocate not enough 64 bits");
        }
        this.timestampBits = timestampBits;
        this.workerIdBits = workerIdBits;
        this.sequenceBits = sequenceBits;
        this.maxDeltaTime = -1L << timestampBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxWorkerId = -1L << workerIdBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.maxSequence = -1L << sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        this.timestampShift = workerIdBits + sequenceBits;
        this.workerIdShift = sequenceBits;
    }

    public long allocate(long deltaTime, long workerId, long sequence) {
        return deltaTime << this.timestampShift | workerId << this.workerIdShift | sequence;
    }

    public int getSignBits() {
        return this.signBits;
    }

    public int getTimestampBits() {
        return this.timestampBits;
    }

    public int getWorkerIdBits() {
        return this.workerIdBits;
    }

    public int getSequenceBits() {
        return this.sequenceBits;
    }

    public long getMaxDeltaTime() {
        return this.maxDeltaTime;
    }

    public long getMaxWorkerId() {
        return this.maxWorkerId;
    }

    public long getMaxSequence() {
        return this.maxSequence;
    }

    public int getTimestampShift() {
        return this.timestampShift;
    }

    public int getWorkerIdShift() {
        return this.workerIdShift;
    }
}

