/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadSpeedMonitor;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloadMessenger;
import com.liulishuo.filedownloader.FileDownloadMonitor;
import com.liulishuo.filedownloader.FileDownloadServiceProxy;
import com.liulishuo.filedownloader.FileDownloadTaskLauncher;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.IDownloadSpeed;
import com.liulishuo.filedownloader.IFileDownloadMessenger;
import com.liulishuo.filedownloader.ILostServiceConnectedHandler;
import com.liulishuo.filedownloader.ITaskHunter;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotTaker;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class DownloadTaskHunter
implements ITaskHunter,
ITaskHunter.IStarter,
ITaskHunter.IMessageHandler,
BaseDownloadTask.LifeCycleCallback {
    private IFileDownloadMessenger mMessenger;
    private final Object mPauseLock;
    private final ICaptureTask mTask;
    private volatile byte mStatus = 0;
    private Throwable mThrowable = null;
    private final IDownloadSpeed.Monitor mSpeedMonitor;
    private final IDownloadSpeed.Lookup mSpeedLookup;
    private long mSoFarBytes;
    private long mTotalBytes;
    private int mRetryingTimes;
    private boolean mIsLargeFile;
    private boolean mIsResuming;
    private String mEtag;
    private boolean mIsReusedOldFile = false;

    @Override
    public boolean updateKeepAhead(MessageSnapshot snapshot) {
        if (!FileDownloadStatus.isKeepAhead(this.getStatus(), snapshot.getStatus())) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "can't update mStatus change by keep ahead, %d, but the current mStatus is %d, %d", this.mStatus, this.getStatus(), this.getId());
            }
            return false;
        }
        this.update(snapshot);
        return true;
    }

    @Override
    public boolean updateKeepFlow(MessageSnapshot snapshot) {
        byte currentStatus = this.getStatus();
        byte nextStatus = snapshot.getStatus();
        if (-2 == currentStatus && FileDownloadStatus.isIng(nextStatus)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "High concurrent cause, callback pending, but has already be paused %d", this.getId());
            }
            return true;
        }
        if (!FileDownloadStatus.isKeepFlow(currentStatus, nextStatus)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "can't update mStatus change by keep flow, %d, but the current mStatus is %d, %d", this.mStatus, this.getStatus(), this.getId());
            }
            return false;
        }
        this.update(snapshot);
        return true;
    }

    @Override
    public boolean updateMoreLikelyCompleted(MessageSnapshot snapshot) {
        if (!FileDownloadStatus.isMoreLikelyCompleted(this.mTask.getRunningTask().getOrigin())) {
            return false;
        }
        this.update(snapshot);
        return true;
    }

    @Override
    public boolean updateSameFilePathTaskRunning(MessageSnapshot snapshot) {
        if (!this.mTask.getRunningTask().getOrigin().isPathAsDirectory()) {
            return false;
        }
        if (snapshot.getStatus() != -4 || this.getStatus() != 2) {
            return false;
        }
        this.update(snapshot);
        return true;
    }

    @Override
    public IFileDownloadMessenger getMessenger() {
        return this.mMessenger;
    }

    @Override
    public MessageSnapshot prepareErrorMessage(Throwable cause) {
        this.mStatus = (byte)-1;
        this.mThrowable = cause;
        return MessageSnapshotTaker.catchException(this.mTask.getRunningTask().getOrigin());
    }

    private void update(MessageSnapshot snapshot) {
        byte status;
        BaseDownloadTask task = this.mTask.getRunningTask().getOrigin();
        this.mStatus = status = snapshot.getStatus();
        this.mIsLargeFile = snapshot.isLargeFile();
        switch (status) {
            case 1: {
                this.mSoFarBytes = snapshot.getLargeSofarBytes();
                this.mTotalBytes = snapshot.getLargeTotalBytes();
                this.mMessenger.notifyPending(snapshot);
                break;
            }
            case 6: {
                this.mMessenger.notifyStarted(snapshot);
                break;
            }
            case 2: {
                this.mTotalBytes = snapshot.getLargeTotalBytes();
                this.mIsResuming = snapshot.isResuming();
                this.mEtag = snapshot.getEtag();
                String filename = snapshot.getFileName();
                if (filename != null) {
                    if (task.getFilename() != null) {
                        FileDownloadLog.w(this, "already has mFilename[%s], but assign mFilename[%s] again", task.getFilename(), filename);
                    }
                    this.mTask.setFileName(filename);
                }
                this.mSpeedMonitor.start();
                this.mMessenger.notifyConnected(snapshot);
                break;
            }
            case 3: {
                this.mSoFarBytes = snapshot.getLargeSofarBytes();
                this.mSpeedMonitor.update(snapshot.getLargeSofarBytes());
                this.mMessenger.notifyProgress(snapshot);
                break;
            }
            case 5: {
                this.mSoFarBytes = snapshot.getLargeSofarBytes();
                this.mThrowable = snapshot.getThrowable();
                this.mRetryingTimes = snapshot.getRetryingTimes();
                this.mSpeedMonitor.reset();
                this.mMessenger.notifyRetry(snapshot);
                break;
            }
            case -1: {
                this.mThrowable = snapshot.getThrowable();
                this.mSoFarBytes = snapshot.getLargeSofarBytes();
                this.mSpeedMonitor.end(this.mSoFarBytes);
                FileDownloadList.getImpl().remove(this.mTask.getRunningTask(), snapshot);
                break;
            }
            case -2: {
                break;
            }
            case -3: {
                this.mIsReusedOldFile = snapshot.isReusedDownloadedFile();
                this.mSoFarBytes = snapshot.getLargeTotalBytes();
                this.mTotalBytes = snapshot.getLargeTotalBytes();
                this.mSpeedMonitor.end(this.mSoFarBytes);
                FileDownloadList.getImpl().remove(this.mTask.getRunningTask(), snapshot);
                break;
            }
            case -4: {
                this.mSpeedMonitor.reset();
                int sameIdTaskCount = FileDownloadList.getImpl().count(task.getId());
                int sameStoreTaskCount = sameIdTaskCount <= 1 && task.isPathAsDirectory() ? FileDownloadList.getImpl().count(FileDownloadUtils.generateId(task.getUrl(), task.getTargetFilePath())) : 0;
                if (sameIdTaskCount + sameStoreTaskCount <= 1) {
                    byte currentStatus = FileDownloadServiceProxy.getImpl().getStatus(task.getId());
                    FileDownloadLog.w(this, "warn, but no mListener to receive, switch to pending %d %d", task.getId(), currentStatus);
                    if (FileDownloadStatus.isIng(currentStatus)) {
                        this.mStatus = 1;
                        this.mTotalBytes = snapshot.getLargeTotalBytes();
                        this.mSoFarBytes = snapshot.getLargeSofarBytes();
                        this.mSpeedMonitor.start();
                        this.mMessenger.notifyPending(((MessageSnapshot.IWarnMessageSnapshot)((Object)snapshot)).turnToPending());
                        break;
                    }
                }
                FileDownloadList.getImpl().remove(this.mTask.getRunningTask(), snapshot);
            }
        }
    }

    @Override
    public void onBegin() {
        if (FileDownloadMonitor.isValid()) {
            FileDownloadMonitor.getMonitor().onTaskBegin(this.mTask.getRunningTask().getOrigin());
        }
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "filedownloader:lifecycle:start %s by %d ", this.toString(), this.getStatus());
        }
    }

    @Override
    public void onIng() {
        if (FileDownloadMonitor.isValid() && this.getStatus() == 6) {
            FileDownloadMonitor.getMonitor().onTaskStarted(this.mTask.getRunningTask().getOrigin());
        }
    }

    @Override
    public void onOver() {
        BaseDownloadTask origin = this.mTask.getRunningTask().getOrigin();
        if (FileDownloadMonitor.isValid()) {
            FileDownloadMonitor.getMonitor().onTaskOver(origin);
        }
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "filedownloader:lifecycle:over %s by %d ", this.toString(), this.getStatus());
        }
        if (this.mTask.getFinishListenerList() != null) {
            ArrayList listenersCopy = (ArrayList)this.mTask.getFinishListenerList().clone();
            int numListeners = listenersCopy.size();
            for (int i = 0; i < numListeners; ++i) {
                ((BaseDownloadTask.FinishListener)listenersCopy.get(i)).over(origin);
            }
        }
        FileDownloader.getImpl().getLostConnectedHandler().taskWorkFine(this.mTask.getRunningTask());
    }

    DownloadTaskHunter(ICaptureTask task, Object pauseLock) {
        this.mPauseLock = pauseLock;
        this.mTask = task;
        DownloadSpeedMonitor monitor = new DownloadSpeedMonitor();
        this.mSpeedMonitor = monitor;
        this.mSpeedLookup = monitor;
        this.mMessenger = new FileDownloadMessenger(task.getRunningTask(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void intoLaunchPool() {
        Object object = this.mPauseLock;
        synchronized (object) {
            if (this.mStatus != 0) {
                FileDownloadLog.w(this, "High concurrent cause, this task %d will not input to launch pool, because of the status isn't idle : %d", this.getId(), this.mStatus);
                return;
            }
            this.mStatus = (byte)10;
        }
        BaseDownloadTask.IRunningTask runningTask = this.mTask.getRunningTask();
        BaseDownloadTask origin = runningTask.getOrigin();
        if (FileDownloadMonitor.isValid()) {
            FileDownloadMonitor.getMonitor().onRequestStart(origin);
        }
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "call start Url[%s], Path[%s] Listener[%s], Tag[%s]", origin.getUrl(), origin.getPath(), origin.getListener(), origin.getTag());
        }
        boolean ready = true;
        try {
            this.prepare();
        }
        catch (Throwable e) {
            ready = false;
            FileDownloadList.getImpl().add(runningTask);
            FileDownloadList.getImpl().remove(runningTask, this.prepareErrorMessage(e));
        }
        if (ready) {
            FileDownloadTaskLauncher.getImpl().launch(this);
        }
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "the task[%d] has been into the launch pool.", this.getId());
        }
    }

    @Override
    public boolean pause() {
        if (FileDownloadStatus.isOver(this.getStatus())) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "High concurrent cause, Already is over, can't pause again, %d %d", this.getStatus(), this.mTask.getRunningTask().getOrigin().getId());
            }
            return false;
        }
        this.mStatus = (byte)-2;
        BaseDownloadTask.IRunningTask runningTask = this.mTask.getRunningTask();
        BaseDownloadTask origin = runningTask.getOrigin();
        FileDownloadTaskLauncher.getImpl().expire(this);
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(this, "the task[%d] has been expired from the launch pool.", this.getId());
        }
        if (!FileDownloader.getImpl().isServiceConnected()) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "request pause the task[%d] to the download service, but the download service isn't connected yet.", origin.getId());
            }
        } else {
            FileDownloadServiceProxy.getImpl().pause(origin.getId());
        }
        this.mSpeedMonitor.end(this.mSoFarBytes);
        FileDownloadList.getImpl().add(runningTask);
        FileDownloadList.getImpl().remove(runningTask, MessageSnapshotTaker.catchPause(origin));
        FileDownloader.getImpl().getLostConnectedHandler().taskWorkFine(runningTask);
        return true;
    }

    @Override
    public byte getStatus() {
        return this.mStatus;
    }

    @Override
    public void reset() {
        this.mThrowable = null;
        this.mEtag = null;
        this.mIsResuming = false;
        this.mRetryingTimes = 0;
        this.mIsReusedOldFile = false;
        this.mIsLargeFile = false;
        this.mSoFarBytes = 0L;
        this.mTotalBytes = 0L;
        this.mSpeedMonitor.reset();
        if (FileDownloadStatus.isOver(this.mStatus)) {
            this.mMessenger.discard();
            this.mMessenger = new FileDownloadMessenger(this.mTask.getRunningTask(), this);
        } else {
            this.mMessenger.reAppointment(this.mTask.getRunningTask(), this);
        }
        this.mStatus = 0;
    }

    @Override
    public void setMinIntervalUpdateSpeed(int minIntervalUpdateSpeed) {
        this.mSpeedLookup.setMinIntervalUpdateSpeed(minIntervalUpdateSpeed);
    }

    @Override
    public int getSpeed() {
        return this.mSpeedLookup.getSpeed();
    }

    @Override
    public long getSofarBytes() {
        return this.mSoFarBytes;
    }

    @Override
    public long getTotalBytes() {
        return this.mTotalBytes;
    }

    @Override
    public Throwable getErrorCause() {
        return this.mThrowable;
    }

    @Override
    public int getRetryingTimes() {
        return this.mRetryingTimes;
    }

    @Override
    public boolean isReusedOldFile() {
        return this.mIsReusedOldFile;
    }

    @Override
    public boolean isResuming() {
        return this.mIsResuming;
    }

    @Override
    public String getEtag() {
        return this.mEtag;
    }

    @Override
    public boolean isLargeFile() {
        return this.mIsLargeFile;
    }

    @Override
    public void free() {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "free the task %d, when the status is %d", this.getId(), this.mStatus);
        }
        this.mStatus = 0;
    }

    private void prepare() {
        File dir;
        BaseDownloadTask.IRunningTask runningTask = this.mTask.getRunningTask();
        BaseDownloadTask origin = runningTask.getOrigin();
        if (origin.getPath() == null) {
            origin.setPath(FileDownloadUtils.getDefaultSaveFilePath(origin.getUrl()));
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "save Path is null to %s", origin.getPath());
            }
        }
        if (origin.isPathAsDirectory()) {
            dir = new File(origin.getPath());
        } else {
            String dirString = FileDownloadUtils.getParent(origin.getPath());
            if (dirString == null) {
                throw new InvalidParameterException(FileDownloadUtils.formatString("the provided mPath[%s] is invalid, can't find its directory", origin.getPath()));
            }
            dir = new File(dirString);
        }
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }

    private int getId() {
        return this.mTask.getRunningTask().getOrigin().getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.mStatus != 10) {
            FileDownloadLog.w(this, "High concurrent cause, this task %d will not start, because the of status isn't toLaunchPool: %d", this.getId(), this.mStatus);
            return;
        }
        BaseDownloadTask.IRunningTask runningTask = this.mTask.getRunningTask();
        BaseDownloadTask origin = runningTask.getOrigin();
        ILostServiceConnectedHandler lostConnectedHandler = FileDownloader.getImpl().getLostConnectedHandler();
        try {
            if (lostConnectedHandler.dispatchTaskStart(runningTask)) {
                return;
            }
            Object object = this.mPauseLock;
            synchronized (object) {
                if (this.mStatus != 10) {
                    FileDownloadLog.w(this, "High concurrent cause, this task %d will not start, the status can't assign to toFileDownloadService, because the status isn't toLaunchPool: %d", this.getId(), this.mStatus);
                    return;
                }
                this.mStatus = (byte)11;
            }
            FileDownloadList.getImpl().add(runningTask);
            if (FileDownloadHelper.inspectAndInflowDownloaded(origin.getId(), origin.getTargetFilePath(), origin.isForceReDownload(), true)) {
                return;
            }
            boolean succeed = FileDownloadServiceProxy.getImpl().start(origin.getUrl(), origin.getPath(), origin.isPathAsDirectory(), origin.getCallbackProgressTimes(), origin.getCallbackProgressMinInterval(), origin.getAutoRetryTimes(), origin.isForceReDownload(), this.mTask.getHeader(), origin.isWifiRequired());
            if (this.mStatus == -2) {
                FileDownloadLog.w(this, "High concurrent cause, this task %d will be paused,because of the status is paused, so the pause action must be applied", this.getId());
                if (succeed) {
                    FileDownloadServiceProxy.getImpl().pause(this.getId());
                }
                return;
            }
            if (!succeed) {
                if (!lostConnectedHandler.dispatchTaskStart(runningTask)) {
                    MessageSnapshot snapshot = this.prepareErrorMessage(new RuntimeException("Occur Unknow Error, when request to start maybe some problem in binder, maybe the process was killed in unexpected."));
                    if (FileDownloadList.getImpl().isNotContains(runningTask)) {
                        lostConnectedHandler.taskWorkFine(runningTask);
                        FileDownloadList.getImpl().add(runningTask);
                    }
                    FileDownloadList.getImpl().remove(runningTask, snapshot);
                }
            } else {
                lostConnectedHandler.taskWorkFine(runningTask);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            FileDownloadList.getImpl().remove(runningTask, this.prepareErrorMessage(e));
        }
    }

    @Override
    public boolean equalListener(FileDownloadListener listener) {
        return this.mTask.getRunningTask().getOrigin().getListener() == listener;
    }

    static interface ICaptureTask {
        public FileDownloadHeader getHeader();

        public BaseDownloadTask.IRunningTask getRunningTask();

        public void setFileName(String var1);

        public ArrayList<BaseDownloadTask.FinishListener> getFinishListenerList();
    }
}

