/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.IFileDownloadMessenger;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotTaker;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.util.ArrayList;
import java.util.List;

public class FileDownloadList {
    private final ArrayList<BaseDownloadTask.IRunningTask> mList = new ArrayList();

    public static FileDownloadList getImpl() {
        return HolderClass.INSTANCE;
    }

    private FileDownloadList() {
    }

    boolean isEmpty() {
        return this.mList.isEmpty();
    }

    int size() {
        return this.mList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int count(int id) {
        int size = 0;
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            for (BaseDownloadTask.IRunningTask task : this.mList) {
                if (!task.is(id)) continue;
                ++size;
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseDownloadTask.IRunningTask get(int id) {
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            for (BaseDownloadTask.IRunningTask task : this.mList) {
                if (!task.is(id)) continue;
                return task;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BaseDownloadTask.IRunningTask> getReceiveServiceTaskList(int id) {
        ArrayList<BaseDownloadTask.IRunningTask> list = new ArrayList<BaseDownloadTask.IRunningTask>();
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            for (BaseDownloadTask.IRunningTask task : this.mList) {
                byte status;
                if (!task.is(id) || task.isOver() || (status = task.getOrigin().getStatus()) == 0 || status == 10) continue;
                list.add(task);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BaseDownloadTask.IRunningTask> getDownloadingList(int id) {
        ArrayList<BaseDownloadTask.IRunningTask> list = new ArrayList<BaseDownloadTask.IRunningTask>();
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            for (BaseDownloadTask.IRunningTask task : this.mList) {
                if (!task.is(id) || task.isOver()) continue;
                list.add(task);
            }
        }
        return list;
    }

    boolean isNotContains(BaseDownloadTask.IRunningTask download) {
        return this.mList.isEmpty() || !this.mList.contains(download);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BaseDownloadTask.IRunningTask> copy(FileDownloadListener listener) {
        ArrayList<BaseDownloadTask.IRunningTask> targetList = new ArrayList<BaseDownloadTask.IRunningTask>();
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            for (BaseDownloadTask.IRunningTask task : this.mList) {
                if (!task.is(listener)) continue;
                targetList.add(task);
            }
            return targetList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<BaseDownloadTask.IRunningTask> assembleTasksToStart(int attachKey, FileDownloadListener listener) {
        ArrayList<BaseDownloadTask.IRunningTask> targetList = new ArrayList<BaseDownloadTask.IRunningTask>();
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            for (BaseDownloadTask.IRunningTask task : this.mList) {
                if (task.getOrigin().getListener() != listener || task.getOrigin().isAttached()) continue;
                task.setAttachKeyByQueue(attachKey);
                targetList.add(task);
            }
            return targetList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BaseDownloadTask.IRunningTask[] copy() {
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            BaseDownloadTask.IRunningTask[] copy = new BaseDownloadTask.IRunningTask[this.mList.size()];
            return this.mList.toArray(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void divertAndIgnoreDuplicate(List<BaseDownloadTask.IRunningTask> destination) {
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            for (BaseDownloadTask.IRunningTask iRunningTask : this.mList) {
                if (destination.contains(iRunningTask)) continue;
                destination.add(iRunningTask);
            }
            this.mList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(BaseDownloadTask.IRunningTask willRemoveDownload, MessageSnapshot snapshot) {
        boolean succeed;
        byte removeByStatus = snapshot.getStatus();
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            succeed = this.mList.remove(willRemoveDownload);
        }
        if (FileDownloadLog.NEED_LOG && this.mList.size() == 0) {
            FileDownloadLog.v(this, "remove %s left %d %d", willRemoveDownload, removeByStatus, this.mList.size());
        }
        if (succeed) {
            IFileDownloadMessenger messenger = willRemoveDownload.getMessageHandler().getMessenger();
            switch (removeByStatus) {
                case -4: {
                    messenger.notifyWarn(snapshot);
                    break;
                }
                case -1: {
                    messenger.notifyError(snapshot);
                    break;
                }
                case -2: {
                    messenger.notifyPaused(snapshot);
                    break;
                }
                case -3: {
                    messenger.notifyBlockComplete(MessageSnapshotTaker.takeBlockCompleted(snapshot));
                }
            }
        } else {
            FileDownloadLog.e((Object)this, "remove error, not exist: %s %d", willRemoveDownload, removeByStatus);
        }
        return succeed;
    }

    void add(BaseDownloadTask.IRunningTask task) {
        if (!task.getOrigin().isAttached()) {
            task.setAttachKeyDefault();
        }
        if (task.getMessageHandler().getMessenger().notifyBegin()) {
            this.addUnchecked(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addUnchecked(BaseDownloadTask.IRunningTask task) {
        if (task.isMarkedAdded2List()) {
            return;
        }
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mList;
        synchronized (arrayList) {
            if (this.mList.contains(task)) {
                FileDownloadLog.w(this, "already has %s", task);
            } else {
                task.markAdded2List();
                this.mList.add(task);
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.v(this, "add list in all %s %d %d", task, task.getOrigin().getStatus(), this.mList.size());
                }
            }
        }
    }

    private static final class HolderClass {
        private static final FileDownloadList INSTANCE = new FileDownloadList();

        private HolderClass() {
        }
    }
}

