/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadLargeFileListener;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloadMessageStation;
import com.liulishuo.filedownloader.FileDownloadMonitor;
import com.liulishuo.filedownloader.IFileDownloadMessenger;
import com.liulishuo.filedownloader.ITaskHunter;
import com.liulishuo.filedownloader.message.BlockCompleteMessage;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.Assert;

class FileDownloadMessenger
implements IFileDownloadMessenger {
    private BaseDownloadTask.IRunningTask mTask;
    private BaseDownloadTask.LifeCycleCallback mLifeCycleCallback;
    private Queue<MessageSnapshot> parcelQueue;
    private boolean mIsDiscard = false;

    FileDownloadMessenger(BaseDownloadTask.IRunningTask task, BaseDownloadTask.LifeCycleCallback callback) {
        this.init(task, callback);
    }

    private void init(BaseDownloadTask.IRunningTask task, BaseDownloadTask.LifeCycleCallback callback) {
        this.mTask = task;
        this.mLifeCycleCallback = callback;
        this.parcelQueue = new LinkedBlockingQueue<MessageSnapshot>();
    }

    @Override
    public boolean notifyBegin() {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify begin %s", this.mTask);
        }
        if (this.mTask == null) {
            FileDownloadLog.w(this, "can't begin the task, the holder fo the messenger is nil, %d", this.parcelQueue.size());
            return false;
        }
        this.mLifeCycleCallback.onBegin();
        return true;
    }

    @Override
    public void notifyPending(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify pending %s", this.mTask);
        }
        this.mLifeCycleCallback.onIng();
        this.process(snapshot);
    }

    @Override
    public void notifyStarted(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify started %s", this.mTask);
        }
        this.mLifeCycleCallback.onIng();
        this.process(snapshot);
    }

    @Override
    public void notifyConnected(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify connected %s", this.mTask);
        }
        this.mLifeCycleCallback.onIng();
        this.process(snapshot);
    }

    @Override
    public void notifyProgress(MessageSnapshot snapshot) {
        BaseDownloadTask originTask = this.mTask.getOrigin();
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify progress %s %d %d", originTask, originTask.getLargeFileSoFarBytes(), originTask.getLargeFileTotalBytes());
        }
        if (originTask.getCallbackProgressTimes() <= 0) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "notify progress but client not request notify %s", this.mTask);
            }
            return;
        }
        this.mLifeCycleCallback.onIng();
        this.process(snapshot);
    }

    @Override
    public void notifyBlockComplete(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify block completed %s %s", this.mTask, Thread.currentThread().getName());
        }
        this.mLifeCycleCallback.onIng();
        this.process(snapshot);
    }

    @Override
    public void notifyRetry(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            BaseDownloadTask originTask = this.mTask.getOrigin();
            FileDownloadLog.d(this, "notify retry %s %d %d %s", this.mTask, originTask.getAutoRetryTimes(), originTask.getRetryingTimes(), originTask.getErrorCause());
        }
        this.mLifeCycleCallback.onIng();
        this.process(snapshot);
    }

    @Override
    public void notifyWarn(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify warn %s", this.mTask);
        }
        this.mLifeCycleCallback.onOver();
        this.process(snapshot);
    }

    @Override
    public void notifyError(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify error %s %s", this.mTask, this.mTask.getOrigin().getErrorCause());
        }
        this.mLifeCycleCallback.onOver();
        this.process(snapshot);
    }

    @Override
    public void notifyPaused(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify paused %s", this.mTask);
        }
        this.mLifeCycleCallback.onOver();
        this.process(snapshot);
    }

    @Override
    public void notifyCompleted(MessageSnapshot snapshot) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "notify completed %s", this.mTask);
        }
        this.mLifeCycleCallback.onOver();
        this.process(snapshot);
    }

    private void process(MessageSnapshot snapshot) {
        if (this.mTask == null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "occur this case, it would be the host task of this messenger has been over(paused/warn/completed/error) on the other thread before receiving the snapshot(id[%d], status[%d])", snapshot.getId(), snapshot.getStatus());
            }
            return;
        }
        if (this.mIsDiscard || this.mTask.getOrigin().getListener() == null) {
            if (FileDownloadMonitor.isValid() && snapshot.getStatus() == 4) {
                this.mLifeCycleCallback.onOver();
            }
            this.inspectAndHandleOverStatus(snapshot.getStatus());
        } else {
            this.parcelQueue.offer(snapshot);
            FileDownloadMessageStation.getImpl().requestEnqueue(this);
        }
    }

    private void inspectAndHandleOverStatus(int status) {
        if (FileDownloadStatus.isOver(status)) {
            if (!this.parcelQueue.isEmpty()) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the messenger[%s] has already accomplished all his job, but there still are some messages in parcel queue[%d]", this, this.parcelQueue.size()));
            }
            this.mTask = null;
        }
    }

    @Override
    public void handoverMessage() {
        if (this.mIsDiscard) {
            return;
        }
        MessageSnapshot message = this.parcelQueue.poll();
        byte currentStatus = message.getStatus();
        BaseDownloadTask.IRunningTask task = this.mTask;
        Assert.assertTrue((String)FileDownloadUtils.formatString("can't handover the message, no master to receive this message(status[%d]) size[%d]", currentStatus, this.parcelQueue.size()), (task != null ? 1 : 0) != 0);
        BaseDownloadTask originTask = task.getOrigin();
        FileDownloadListener listener = originTask.getListener();
        ITaskHunter.IMessageHandler messageHandler = task.getMessageHandler();
        this.inspectAndHandleOverStatus(currentStatus);
        if (listener == null || listener.isInvalid()) {
            return;
        }
        if (currentStatus == 4) {
            try {
                listener.blockComplete(originTask);
                this.notifyCompleted(((BlockCompleteMessage)((Object)message)).transmitToCompleted());
            }
            catch (Throwable throwable) {
                this.notifyError(messageHandler.prepareErrorMessage(throwable));
            }
        } else {
            FileDownloadLargeFileListener largeFileListener = null;
            if (listener instanceof FileDownloadLargeFileListener) {
                largeFileListener = (FileDownloadLargeFileListener)listener;
            }
            switch (currentStatus) {
                case 1: {
                    if (largeFileListener != null) {
                        largeFileListener.pending(originTask, message.getLargeSofarBytes(), message.getLargeTotalBytes());
                        break;
                    }
                    listener.pending(originTask, message.getSmallSofarBytes(), message.getSmallTotalBytes());
                    break;
                }
                case 6: {
                    listener.started(originTask);
                    break;
                }
                case 2: {
                    if (largeFileListener != null) {
                        largeFileListener.connected(originTask, message.getEtag(), message.isResuming(), originTask.getLargeFileSoFarBytes(), message.getLargeTotalBytes());
                        break;
                    }
                    listener.connected(originTask, message.getEtag(), message.isResuming(), originTask.getSmallFileSoFarBytes(), message.getSmallTotalBytes());
                    break;
                }
                case 3: {
                    if (largeFileListener != null) {
                        largeFileListener.progress(originTask, message.getLargeSofarBytes(), originTask.getLargeFileTotalBytes());
                        break;
                    }
                    listener.progress(originTask, message.getSmallSofarBytes(), originTask.getSmallFileTotalBytes());
                    break;
                }
                case 5: {
                    if (largeFileListener != null) {
                        largeFileListener.retry(originTask, message.getThrowable(), message.getRetryingTimes(), message.getLargeSofarBytes());
                        break;
                    }
                    listener.retry(originTask, message.getThrowable(), message.getRetryingTimes(), message.getSmallSofarBytes());
                    break;
                }
                case -3: {
                    listener.completed(originTask);
                    break;
                }
                case -1: {
                    listener.error(originTask, message.getThrowable());
                    break;
                }
                case -2: {
                    if (largeFileListener != null) {
                        largeFileListener.paused(originTask, message.getLargeSofarBytes(), message.getLargeTotalBytes());
                        break;
                    }
                    listener.paused(originTask, message.getSmallSofarBytes(), message.getSmallTotalBytes());
                    break;
                }
                case -4: {
                    listener.warn(originTask);
                }
            }
        }
    }

    @Override
    public boolean handoverDirectly() {
        return this.mTask.getOrigin().isSyncCallback();
    }

    @Override
    public void reAppointment(BaseDownloadTask.IRunningTask task, BaseDownloadTask.LifeCycleCallback callback) {
        if (this.mTask != null) {
            throw new IllegalStateException(FileDownloadUtils.formatString("the messenger is working, can't re-appointment for %s", task));
        }
        this.init(task, callback);
    }

    @Override
    public boolean isBlockingCompleted() {
        return this.parcelQueue.peek().getStatus() == 4;
    }

    @Override
    public void discard() {
        this.mIsDiscard = true;
    }

    public String toString() {
        return FileDownloadUtils.formatString("%d:%s", this.mTask.getOrigin().getId(), super.toString());
    }
}

