/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.app.Notification;
import android.content.Context;
import android.content.Intent;
import com.liulishuo.filedownloader.FileDownloadEventPool;
import com.liulishuo.filedownloader.IFileDownloadServiceProxy;
import com.liulishuo.filedownloader.event.DownloadServiceConnectChangedEvent;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.services.FDServiceSharedHandler;
import com.liulishuo.filedownloader.services.FileDownloadService;
import com.liulishuo.filedownloader.util.DownloadServiceNotConnectedHelper;
import java.util.ArrayList;
import java.util.List;

class FileDownloadServiceSharedTransmit
implements IFileDownloadServiceProxy,
FDServiceSharedHandler.FileDownloadServiceSharedConnection {
    private static final Class<?> SERVICE_CLASS = FileDownloadService.SharedMainProcessService.class;
    private final ArrayList<Runnable> connectedRunnableList = new ArrayList();
    private FDServiceSharedHandler handler;

    FileDownloadServiceSharedTransmit() {
    }

    @Override
    public boolean start(String url, String path, boolean pathAsDirectory, int callbackProgressTimes, int callbackProgressMinIntervalMillis, int autoRetryTimes, boolean forceReDownload, FileDownloadHeader header, boolean isWifiRequired) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.start(url, path, pathAsDirectory);
        }
        this.handler.start(url, path, pathAsDirectory, callbackProgressTimes, callbackProgressMinIntervalMillis, autoRetryTimes, forceReDownload, header, isWifiRequired);
        return true;
    }

    @Override
    public boolean pause(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.pause(id);
        }
        return this.handler.pause(id);
    }

    @Override
    public boolean isDownloading(String url, String path) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.isDownloading(url, path);
        }
        return this.handler.checkDownloading(url, path);
    }

    @Override
    public long getSofar(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getSofar(id);
        }
        return this.handler.getSofar(id);
    }

    @Override
    public long getTotal(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getTotal(id);
        }
        return this.handler.getTotal(id);
    }

    @Override
    public byte getStatus(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.getStatus(id);
        }
        return this.handler.getStatus(id);
    }

    @Override
    public void pauseAllTasks() {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.pauseAllTasks();
            return;
        }
        this.handler.pauseAllTasks();
    }

    @Override
    public boolean isIdle() {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.isIdle();
        }
        return this.handler.isIdle();
    }

    @Override
    public boolean isConnected() {
        return this.handler != null;
    }

    @Override
    public void bindStartByContext(Context context) {
        this.bindStartByContext(context, null);
    }

    @Override
    public void bindStartByContext(Context context, Runnable connectedRunnable) {
        if (connectedRunnable != null && !this.connectedRunnableList.contains(connectedRunnable)) {
            this.connectedRunnableList.add(connectedRunnable);
        }
        Intent i = new Intent(context, SERVICE_CLASS);
        context.startService(i);
    }

    @Override
    public void unbindByContext(Context context) {
        Intent i = new Intent(context, SERVICE_CLASS);
        context.stopService(i);
        this.handler = null;
    }

    @Override
    public void startForeground(int notificationId, Notification notification) {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.startForeground(notificationId, notification);
            return;
        }
        this.handler.startForeground(notificationId, notification);
    }

    @Override
    public void stopForeground(boolean removeNotification) {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.stopForeground(removeNotification);
            return;
        }
        this.handler.stopForeground(removeNotification);
    }

    @Override
    public boolean setMaxNetworkThreadCount(int count) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.setMaxNetworkThreadCount(count);
        }
        return this.handler.setMaxNetworkThreadCount(count);
    }

    @Override
    public boolean clearTaskData(int id) {
        if (!this.isConnected()) {
            return DownloadServiceNotConnectedHelper.clearTaskData(id);
        }
        return this.handler.clearTaskData(id);
    }

    @Override
    public void clearAllTaskData() {
        if (!this.isConnected()) {
            DownloadServiceNotConnectedHelper.clearAllTaskData();
            return;
        }
        this.handler.clearAllTaskData();
    }

    @Override
    public void onConnected(FDServiceSharedHandler handler) {
        this.handler = handler;
        List runnableList = (List)this.connectedRunnableList.clone();
        this.connectedRunnableList.clear();
        for (Runnable runnable : runnableList) {
            runnable.run();
        }
        FileDownloadEventPool.getImpl().asyncPublishInNewThread(new DownloadServiceConnectChangedEvent(DownloadServiceConnectChangedEvent.ConnectStatus.connected, SERVICE_CLASS));
    }

    @Override
    public void onDisconnected() {
        this.handler = null;
        FileDownloadEventPool.getImpl().asyncPublishInNewThread(new DownloadServiceConnectChangedEvent(DownloadServiceConnectChangedEvent.ConnectStatus.disconnected, SERVICE_CLASS));
    }
}

