/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.ITaskHunter;
import com.liulishuo.filedownloader.MessageSnapshotGate;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;

class FileDownloadTaskLauncher {
    private final LaunchTaskPool mLaunchTaskPool = new LaunchTaskPool();

    FileDownloadTaskLauncher() {
    }

    public static FileDownloadTaskLauncher getImpl() {
        return HolderClass.INSTANCE;
    }

    synchronized void launch(ITaskHunter.IStarter taskStarter) {
        this.mLaunchTaskPool.asyncExecute(taskStarter);
    }

    synchronized void expireAll() {
        this.mLaunchTaskPool.expireAll();
    }

    synchronized void expire(ITaskHunter.IStarter taskStarter) {
        this.mLaunchTaskPool.expire(taskStarter);
    }

    synchronized void expire(FileDownloadListener lis) {
        this.mLaunchTaskPool.expire(lis);
    }

    private static class LaunchTaskRunnable
    implements Runnable {
        private final ITaskHunter.IStarter mTaskStarter;
        private boolean mExpired;

        LaunchTaskRunnable(ITaskHunter.IStarter taskStarter) {
            this.mTaskStarter = taskStarter;
            this.mExpired = false;
        }

        @Override
        public void run() {
            if (this.mExpired) {
                return;
            }
            this.mTaskStarter.start();
        }

        public boolean isSameListener(FileDownloadListener listener) {
            return this.mTaskStarter != null && this.mTaskStarter.equalListener(listener);
        }

        public boolean equals(Object obj) {
            return super.equals(obj) || obj == this.mTaskStarter;
        }

        public void expire() {
            this.mExpired = true;
        }
    }

    private static class LaunchTaskPool {
        private ThreadPoolExecutor mPool;
        private LinkedBlockingQueue<Runnable> mWorkQueue;

        public LaunchTaskPool() {
            this.init();
        }

        public void asyncExecute(ITaskHunter.IStarter taskStarter) {
            this.mPool.execute(new LaunchTaskRunnable(taskStarter));
        }

        public void expire(ITaskHunter.IStarter starter) {
            this.mWorkQueue.remove(starter);
        }

        public void expire(FileDownloadListener listener) {
            if (listener == null) {
                FileDownloadLog.w(this, "want to expire by listener, but the listener provided is null", new Object[0]);
                return;
            }
            ArrayList<Runnable> needPauseList = new ArrayList<Runnable>();
            for (Runnable runnable : this.mWorkQueue) {
                LaunchTaskRunnable launchTaskRunnable = (LaunchTaskRunnable)runnable;
                if (!launchTaskRunnable.isSameListener(listener)) continue;
                launchTaskRunnable.expire();
                needPauseList.add(runnable);
            }
            if (needPauseList.isEmpty()) {
                return;
            }
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "expire %d tasks with listener[%s]", needPauseList.size(), listener);
            }
            for (Runnable runnable : needPauseList) {
                this.mPool.remove(runnable);
            }
        }

        public void expireAll() {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "expire %d tasks", this.mWorkQueue.size());
            }
            this.mPool.shutdownNow();
            this.init();
        }

        private void init() {
            this.mWorkQueue = new LinkedBlockingQueue();
            this.mPool = FileDownloadExecutors.newDefaultThreadPool(3, this.mWorkQueue, "LauncherTask");
        }
    }

    private static class HolderClass {
        private static final FileDownloadTaskLauncher INSTANCE = new FileDownloadTaskLauncher();

        private HolderClass() {
        }

        static {
            MessageSnapshotFlow.getImpl().setReceiver(new MessageSnapshotGate());
        }
    }
}

