/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.util.List;

public class MessageSnapshotGate
implements MessageSnapshotFlow.MessageReceiver {
    private boolean transmitMessage(List<BaseDownloadTask.IRunningTask> taskList, MessageSnapshot snapshot) {
        if (taskList.size() > 1 && snapshot.getStatus() == -3) {
            for (BaseDownloadTask.IRunningTask task : taskList) {
                if (!task.getMessageHandler().updateMoreLikelyCompleted(snapshot)) continue;
                return true;
            }
        }
        for (BaseDownloadTask.IRunningTask task : taskList) {
            if (!task.getMessageHandler().updateKeepFlow(snapshot)) continue;
            return true;
        }
        if (-4 == snapshot.getStatus()) {
            for (BaseDownloadTask.IRunningTask task : taskList) {
                if (!task.getMessageHandler().updateSameFilePathTaskRunning(snapshot)) continue;
                return true;
            }
        }
        if (taskList.size() == 1) {
            return taskList.get(0).getMessageHandler().updateKeepAhead(snapshot);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(MessageSnapshot snapshot) {
        String updateSyncLock = Integer.toString(snapshot.getId());
        String string = updateSyncLock.intern();
        synchronized (string) {
            List<BaseDownloadTask.IRunningTask> taskList = FileDownloadList.getImpl().getReceiveServiceTaskList(snapshot.getId());
            if (taskList.size() > 0) {
                BaseDownloadTask topOriginTask = taskList.get(0).getOrigin();
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, "~~~callback %s old[%s] new[%s] %d", snapshot.getId(), topOriginTask.getStatus(), snapshot.getStatus(), taskList.size());
                }
                if (!this.transmitMessage(taskList, snapshot)) {
                    String log = "The event isn't consumed, id:" + snapshot.getId() + " status:" + snapshot.getStatus() + " task-count:" + taskList.size();
                    for (BaseDownloadTask.IRunningTask task : taskList) {
                        log = log + " | " + task.getOrigin().getStatus();
                    }
                    FileDownloadLog.i(this, log, new Object[0]);
                }
            } else {
                FileDownloadLog.i(this, "Receive the event %d, but there isn't any running task in the upper layer", snapshot.getStatus());
            }
        }
    }
}

