/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.util.SparseArray;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadListener;
import com.liulishuo.filedownloader.FileDownloadMonitor;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.IQueuesHandler;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.lang.ref.WeakReference;
import java.util.List;

class QueuesHandler
implements IQueuesHandler {
    private final SparseArray<Handler> mRunningSerialMap = new SparseArray();
    static final int WHAT_SERIAL_NEXT = 1;
    static final int WHAT_FREEZE = 2;
    static final int WHAT_UNFREEZE = 3;

    @Override
    public boolean startQueueParallel(FileDownloadListener listener) {
        List<BaseDownloadTask.IRunningTask> list;
        int attachKey = listener.hashCode();
        if (this.onAssembledTasksToStart(attachKey, list = FileDownloadList.getImpl().assembleTasksToStart(attachKey, listener), listener, false)) {
            return false;
        }
        for (BaseDownloadTask.IRunningTask task : list) {
            task.startTaskByQueue();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startQueueSerial(FileDownloadListener listener) {
        List<BaseDownloadTask.IRunningTask> list;
        SerialHandlerCallback callback = new SerialHandlerCallback();
        int attachKey = callback.hashCode();
        if (this.onAssembledTasksToStart(attachKey, list = FileDownloadList.getImpl().assembleTasksToStart(attachKey, listener), listener, true)) {
            return false;
        }
        HandlerThread serialThread = new HandlerThread(FileDownloadUtils.formatString("filedownloader serial thread %s-%d", listener, attachKey));
        serialThread.start();
        Handler serialHandler = new Handler(serialThread.getLooper(), (Handler.Callback)callback);
        callback.setHandler(serialHandler);
        callback.setList(list);
        callback.goNext(0);
        SparseArray<Handler> sparseArray = this.mRunningSerialMap;
        synchronized (sparseArray) {
            this.mRunningSerialMap.put(attachKey, (Object)serialHandler);
        }
        return true;
    }

    @Override
    public void freezeAllSerialQueues() {
        for (int i = 0; i < this.mRunningSerialMap.size(); ++i) {
            int key = this.mRunningSerialMap.keyAt(i);
            Handler handler = (Handler)this.mRunningSerialMap.get(key);
            this.freezeSerialHandler(handler);
        }
    }

    @Override
    public void unFreezeSerialQueues(List<Integer> attachKeyList) {
        for (Integer attachKey : attachKeyList) {
            Handler handler = (Handler)this.mRunningSerialMap.get(attachKey.intValue());
            this.unFreezeSerialHandler(handler);
        }
    }

    @Override
    public int serialQueueSize() {
        return this.mRunningSerialMap.size();
    }

    @Override
    public boolean contain(int attachKey) {
        return this.mRunningSerialMap.get(attachKey) != null;
    }

    private boolean onAssembledTasksToStart(int attachKey, List<BaseDownloadTask.IRunningTask> list, FileDownloadListener listener, boolean isSerial) {
        if (FileDownloadMonitor.isValid()) {
            FileDownloadMonitor.getMonitor().onRequestStart(list.size(), true, listener);
        }
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.v(FileDownloader.class, "start list attachKey[%d] size[%d] listener[%s] isSerial[%B]", attachKey, list.size(), listener, isSerial);
        }
        if (list == null || list.isEmpty()) {
            FileDownloadLog.w(FileDownloader.class, "Tasks with the listener can't start, because can't find any task with the provided listener, maybe tasks instance has been started in the past, so they are all are inUsing, if in this case, you can use [BaseDownloadTask#reuse] to reuse theme first then start again: [%s, %B]", listener, isSerial);
            return true;
        }
        return false;
    }

    private void freezeSerialHandler(Handler handler) {
        handler.sendEmptyMessage(2);
    }

    private void unFreezeSerialHandler(Handler handler) {
        handler.sendEmptyMessage(3);
    }

    private static class SerialFinishListener
    implements BaseDownloadTask.FinishListener {
        private final WeakReference<SerialHandlerCallback> wSerialHandlerCallback;
        private int nextIndex;

        private SerialFinishListener(WeakReference<SerialHandlerCallback> wSerialHandlerCallback) {
            this.wSerialHandlerCallback = wSerialHandlerCallback;
        }

        public BaseDownloadTask.FinishListener setNextIndex(int index) {
            this.nextIndex = index;
            return this;
        }

        @Override
        public void over(BaseDownloadTask task) {
            if (this.wSerialHandlerCallback != null && this.wSerialHandlerCallback.get() != null) {
                ((SerialHandlerCallback)this.wSerialHandlerCallback.get()).goNext(this.nextIndex);
            }
        }
    }

    private class SerialHandlerCallback
    implements Handler.Callback {
        private Handler mHandler;
        private List<BaseDownloadTask.IRunningTask> mList;
        private int mRunningIndex = 0;
        private SerialFinishListener mSerialFinishListener = new SerialFinishListener(new WeakReference<SerialHandlerCallback>(this));

        SerialHandlerCallback() {
        }

        public void setHandler(Handler handler) {
            this.mHandler = handler;
        }

        public void setList(List<BaseDownloadTask.IRunningTask> list) {
            this.mList = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean handleMessage(Message msg) {
            if (msg.what == 1) {
                if (msg.arg1 >= this.mList.size()) {
                    SparseArray sparseArray = QueuesHandler.this.mRunningSerialMap;
                    synchronized (sparseArray) {
                        QueuesHandler.this.mRunningSerialMap.remove(this.mList.get(0).getAttachKey());
                    }
                    if (this.mHandler != null && this.mHandler.getLooper() != null) {
                        this.mHandler.getLooper().quit();
                        this.mHandler = null;
                        this.mList = null;
                        this.mSerialFinishListener = null;
                    }
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(SerialHandlerCallback.class, "final serial %s %d", this.mList == null ? null : (this.mList.get(0) == null ? null : this.mList.get(0).getOrigin().getListener()), msg.arg1);
                    }
                    return true;
                }
                this.mRunningIndex = msg.arg1;
                BaseDownloadTask.IRunningTask stackTopTask = this.mList.get(this.mRunningIndex);
                Object object = stackTopTask.getPauseLock();
                synchronized (object) {
                    if (stackTopTask.getOrigin().getStatus() != 0 || FileDownloadList.getImpl().isNotContains(stackTopTask)) {
                        if (FileDownloadLog.NEED_LOG) {
                            FileDownloadLog.d(SerialHandlerCallback.class, "direct go next by not contains %s %d", stackTopTask, msg.arg1);
                        }
                        this.goNext(msg.arg1 + 1);
                        return true;
                    }
                    stackTopTask.getOrigin().addFinishListener(this.mSerialFinishListener.setNextIndex(this.mRunningIndex + 1));
                    stackTopTask.startTaskByQueue();
                }
            }
            if (msg.what == 2) {
                this.freeze();
            } else if (msg.what == 3) {
                this.unfreeze();
            }
            return true;
        }

        public void freeze() {
            this.mList.get(this.mRunningIndex).getOrigin().removeFinishListener(this.mSerialFinishListener);
            this.mHandler.removeCallbacksAndMessages(null);
        }

        public void unfreeze() {
            this.goNext(this.mRunningIndex);
        }

        private void goNext(int nextIndex) {
            if (this.mHandler == null || this.mList == null) {
                FileDownloadLog.w(this, "need go next %d, but params is not ready %s %s", nextIndex, this.mHandler, this.mList);
                return;
            }
            Message nextMsg = this.mHandler.obtainMessage();
            nextMsg.what = 1;
            nextMsg.arg1 = nextIndex;
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(SerialHandlerCallback.class, "start next %s %s", this.mList == null ? null : (this.mList.get(0) == null ? null : this.mList.get(0).getOrigin().getListener()), nextMsg.arg1);
            }
            this.mHandler.sendMessage(nextMsg);
        }
    }
}

