/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.exception;

import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileDownloadHttpException
extends RuntimeException {
    private final int mCode;
    private final Map<String, List<String>> mRequestHeaderMap;
    private final Map<String, List<String>> mResponseHeaderMap;

    public FileDownloadHttpException(int code, Map<String, List<String>> requestHeaderMap, Map<String, List<String>> responseHeaderMap) {
        super(FileDownloadUtils.formatString("response code error: %d, \n request headers: %s \n response headers: %s", code, requestHeaderMap, responseHeaderMap));
        this.mCode = code;
        this.mRequestHeaderMap = FileDownloadHttpException.cloneSerializableMap(requestHeaderMap);
        this.mResponseHeaderMap = FileDownloadHttpException.cloneSerializableMap(requestHeaderMap);
    }

    public Map<String, List<String>> getRequestHeader() {
        return this.mRequestHeaderMap;
    }

    public Map<String, List<String>> getResponseHeader() {
        return this.mResponseHeaderMap;
    }

    public int getCode() {
        return this.mCode;
    }

    private static Map<String, List<String>> cloneSerializableMap(Map<String, List<String>> originMap) {
        HashMap<String, List<String>> serialMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : originMap.entrySet()) {
            String key = entry.getKey();
            ArrayList values = new ArrayList(entry.getValue());
            serialMap.put(key, values);
        }
        return serialMap;
    }
}

