/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import android.os.Parcel;
import android.os.Parcelable;
import com.liulishuo.filedownloader.message.IMessageSnapshot;
import com.liulishuo.filedownloader.message.LargeMessageSnapshot;
import com.liulishuo.filedownloader.message.SmallMessageSnapshot;
import com.liulishuo.filedownloader.util.FileDownloadUtils;

public abstract class MessageSnapshot
implements IMessageSnapshot,
Parcelable {
    private final int id;
    protected boolean isLargeFile;
    public static final Parcelable.Creator<MessageSnapshot> CREATOR = new Parcelable.Creator<MessageSnapshot>(){

        public MessageSnapshot createFromParcel(Parcel source) {
            MessageSnapshot snapshot;
            boolean largeFile = source.readByte() == 1;
            byte status = source.readByte();
            switch (status) {
                case 1: {
                    if (largeFile) {
                        snapshot = new LargeMessageSnapshot.PendingMessageSnapshot(source);
                        break;
                    }
                    snapshot = new SmallMessageSnapshot.PendingMessageSnapshot(source);
                    break;
                }
                case 6: {
                    snapshot = new StartedMessageSnapshot(source);
                    break;
                }
                case 2: {
                    if (largeFile) {
                        snapshot = new LargeMessageSnapshot.ConnectedMessageSnapshot(source);
                        break;
                    }
                    snapshot = new SmallMessageSnapshot.ConnectedMessageSnapshot(source);
                    break;
                }
                case 3: {
                    if (largeFile) {
                        snapshot = new LargeMessageSnapshot.ProgressMessageSnapshot(source);
                        break;
                    }
                    snapshot = new SmallMessageSnapshot.ProgressMessageSnapshot(source);
                    break;
                }
                case 5: {
                    if (largeFile) {
                        snapshot = new LargeMessageSnapshot.RetryMessageSnapshot(source);
                        break;
                    }
                    snapshot = new SmallMessageSnapshot.RetryMessageSnapshot(source);
                    break;
                }
                case -1: {
                    if (largeFile) {
                        snapshot = new LargeMessageSnapshot.ErrorMessageSnapshot(source);
                        break;
                    }
                    snapshot = new SmallMessageSnapshot.ErrorMessageSnapshot(source);
                    break;
                }
                case -3: {
                    if (largeFile) {
                        snapshot = new LargeMessageSnapshot.CompletedSnapshot(source);
                        break;
                    }
                    snapshot = new SmallMessageSnapshot.CompletedSnapshot(source);
                    break;
                }
                case -4: {
                    if (largeFile) {
                        snapshot = new LargeMessageSnapshot.WarnMessageSnapshot(source);
                        break;
                    }
                    snapshot = new SmallMessageSnapshot.WarnMessageSnapshot(source);
                    break;
                }
                default: {
                    snapshot = null;
                }
            }
            if (snapshot == null) {
                throw new IllegalStateException("Can't restore the snapshot because unknow status: " + status);
            }
            snapshot.isLargeFile = largeFile;
            return snapshot;
        }

        public MessageSnapshot[] newArray(int size) {
            return new MessageSnapshot[size];
        }
    };

    MessageSnapshot(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public Throwable getThrowable() {
        throw new NoFieldException("getThrowable", this);
    }

    @Override
    public int getRetryingTimes() {
        throw new NoFieldException("getRetryingTimes", this);
    }

    @Override
    public boolean isResuming() {
        throw new NoFieldException("isResuming", this);
    }

    @Override
    public String getEtag() {
        throw new NoFieldException("getEtag", this);
    }

    @Override
    public long getLargeSofarBytes() {
        throw new NoFieldException("getLargeSofarBytes", this);
    }

    @Override
    public long getLargeTotalBytes() {
        throw new NoFieldException("getLargeTotalBytes", this);
    }

    @Override
    public int getSmallSofarBytes() {
        throw new NoFieldException("getSmallSofarBytes", this);
    }

    @Override
    public int getSmallTotalBytes() {
        throw new NoFieldException("getSmallTotalBytes", this);
    }

    @Override
    public boolean isReusedDownloadedFile() {
        throw new NoFieldException("isReusedDownloadedFile", this);
    }

    @Override
    public String getFileName() {
        throw new NoFieldException("getFileName", this);
    }

    @Override
    public boolean isLargeFile() {
        return this.isLargeFile;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.isLargeFile ? 1 : 0));
        dest.writeByte(this.getStatus());
        dest.writeInt(this.id);
    }

    MessageSnapshot(Parcel in) {
        this.id = in.readInt();
    }

    public static class StartedMessageSnapshot
    extends MessageSnapshot {
        StartedMessageSnapshot(int id) {
            super(id);
        }

        StartedMessageSnapshot(Parcel in) {
            super(in);
        }

        @Override
        public byte getStatus() {
            return 6;
        }
    }

    public static class NoFieldException
    extends IllegalStateException {
        NoFieldException(String methodName, MessageSnapshot snapshot) {
            super(FileDownloadUtils.formatString("There isn't a field for '%s' in this message %d %d %s", methodName, snapshot.getId(), snapshot.getStatus(), snapshot.getClass().getName()));
        }
    }

    public static interface IWarnMessageSnapshot {
        public MessageSnapshot turnToPending();
    }
}

