/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.message;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.message.BlockCompleteMessage;
import com.liulishuo.filedownloader.message.LargeMessageSnapshot;
import com.liulishuo.filedownloader.message.MessageSnapshot;
import com.liulishuo.filedownloader.message.SmallMessageSnapshot;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.services.FileDownloadRunnable;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;

public class MessageSnapshotTaker {
    public static MessageSnapshot take(byte status, FileDownloadModel model) {
        return MessageSnapshotTaker.take(status, model, null);
    }

    public static MessageSnapshot catchCanReusedOldFile(int id, File oldFile, boolean flowDirectly) {
        long totalBytes = oldFile.length();
        if (totalBytes > Integer.MAX_VALUE) {
            if (flowDirectly) {
                return new LargeMessageSnapshot.CompletedFlowDirectlySnapshot(id, true, totalBytes);
            }
            return new LargeMessageSnapshot.CompletedSnapshot(id, true, totalBytes);
        }
        if (flowDirectly) {
            return new SmallMessageSnapshot.CompletedFlowDirectlySnapshot(id, true, (int)totalBytes);
        }
        return new SmallMessageSnapshot.CompletedSnapshot(id, true, (int)totalBytes);
    }

    public static MessageSnapshot catchWarn(int id, long sofar, long total, boolean flowDirectly) {
        if (total > Integer.MAX_VALUE) {
            if (flowDirectly) {
                return new LargeMessageSnapshot.WarnFlowDirectlySnapshot(id, sofar, total);
            }
            return new LargeMessageSnapshot.WarnMessageSnapshot(id, sofar, total);
        }
        if (flowDirectly) {
            return new SmallMessageSnapshot.WarnFlowDirectlySnapshot(id, (int)sofar, (int)total);
        }
        return new SmallMessageSnapshot.WarnMessageSnapshot(id, (int)sofar, (int)total);
    }

    public static MessageSnapshot catchException(BaseDownloadTask task) {
        if (task.isLargeFile()) {
            return new LargeMessageSnapshot.ErrorMessageSnapshot(task.getId(), task.getLargeFileSoFarBytes(), task.getErrorCause());
        }
        return new SmallMessageSnapshot.ErrorMessageSnapshot(task.getId(), task.getSmallFileSoFarBytes(), task.getErrorCause());
    }

    public static MessageSnapshot catchPause(BaseDownloadTask task) {
        if (task.isLargeFile()) {
            return new LargeMessageSnapshot.PausedSnapshot(task.getId(), task.getLargeFileSoFarBytes(), task.getLargeFileTotalBytes());
        }
        return new SmallMessageSnapshot.PausedSnapshot(task.getId(), task.getSmallFileSoFarBytes(), task.getSmallFileTotalBytes());
    }

    public static MessageSnapshot takeBlockCompleted(MessageSnapshot snapshot) {
        if (snapshot.getStatus() != -3) {
            throw new IllegalStateException(FileDownloadUtils.formatString("take block completed snapshot, must has already be completed. %d %d", snapshot.getId(), snapshot.getStatus()));
        }
        return new BlockCompleteMessage.BlockCompleteMessageImpl(snapshot);
    }

    public static MessageSnapshot take(byte status, FileDownloadModel model, FileDownloadRunnable runnable) {
        MessageSnapshot snapShot;
        int id = model.getId();
        if (status == -4) {
            throw new IllegalStateException(FileDownloadUtils.formatString("please use #catchWarn instead %d", id));
        }
        switch (status) {
            case 1: {
                if (model.isLargeFile()) {
                    snapShot = new LargeMessageSnapshot.PendingMessageSnapshot(id, model.getSoFar(), model.getTotal());
                    break;
                }
                snapShot = new SmallMessageSnapshot.PendingMessageSnapshot(id, (int)model.getSoFar(), (int)model.getTotal());
                break;
            }
            case 6: {
                snapShot = new MessageSnapshot.StartedMessageSnapshot(id);
                break;
            }
            case 2: {
                String filename;
                String string = filename = model.isPathAsDirectory() ? model.getFilename() : null;
                if (model.isLargeFile()) {
                    snapShot = new LargeMessageSnapshot.ConnectedMessageSnapshot(id, runnable.isResuming(), model.getTotal(), model.getETag(), filename);
                    break;
                }
                snapShot = new SmallMessageSnapshot.ConnectedMessageSnapshot(id, runnable.isResuming(), (int)model.getTotal(), model.getETag(), filename);
                break;
            }
            case 3: {
                if (model.isLargeFile()) {
                    snapShot = new LargeMessageSnapshot.ProgressMessageSnapshot(id, model.getSoFar());
                    break;
                }
                snapShot = new SmallMessageSnapshot.ProgressMessageSnapshot(id, (int)model.getSoFar());
                break;
            }
            case -3: {
                if (model.isLargeFile()) {
                    snapShot = new LargeMessageSnapshot.CompletedSnapshot(id, false, model.getTotal());
                    break;
                }
                snapShot = new SmallMessageSnapshot.CompletedSnapshot(id, false, (int)model.getTotal());
                break;
            }
            case 5: {
                if (model.isLargeFile()) {
                    snapShot = new LargeMessageSnapshot.RetryMessageSnapshot(id, model.getSoFar(), runnable.getThrowable(), runnable.getRetryingTimes());
                    break;
                }
                snapShot = new SmallMessageSnapshot.RetryMessageSnapshot(id, (int)model.getSoFar(), runnable.getThrowable(), runnable.getRetryingTimes());
                break;
            }
            case -1: {
                if (model.isLargeFile()) {
                    snapShot = new LargeMessageSnapshot.ErrorMessageSnapshot(id, model.getSoFar(), runnable.getThrowable());
                    break;
                }
                snapShot = new SmallMessageSnapshot.ErrorMessageSnapshot(id, (int)model.getSoFar(), runnable.getThrowable());
                break;
            }
            default: {
                String message = FileDownloadUtils.formatString("it can't takes a snapshot for the task(%s) when its status is %d,", model, status);
                FileDownloadLog.w(MessageSnapshotTaker.class, message, new Object[0]);
                IllegalStateException throwable = runnable.getThrowable() != null ? new IllegalStateException(message, runnable.getThrowable()) : new IllegalStateException(message);
                snapShot = model.isLargeFile() ? new LargeMessageSnapshot.ErrorMessageSnapshot(id, model.getSoFar(), throwable) : new SmallMessageSnapshot.ErrorMessageSnapshot(id, (int)model.getSoFar(), throwable);
            }
        }
        return snapShot;
    }
}

