/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.model;

import android.content.ContentValues;
import com.liulishuo.filedownloader.util.FileDownloadUtils;

public class FileDownloadModel {
    public static final int DEFAULT_CALLBACK_PROGRESS_TIMES = 100;
    private int id;
    public static final String ID = "_id";
    private String url;
    public static final String URL = "url";
    private String path;
    public static final String PATH = "path";
    private boolean pathAsDirectory;
    public static final String PATH_AS_DIRECTORY = "pathAsDirectory";
    private String filename;
    public static final String FILENAME = "filename";
    private byte status;
    public static final String STATUS = "status";
    private long soFar;
    private long total;
    public static final String SOFAR = "sofar";
    public static final String TOTAL = "total";
    private String errMsg;
    public static final String ERR_MSG = "errMsg";
    private String eTag;
    public static final String ETAG = "etag";
    private boolean isLargeFile;

    public void setId(int id) {
        this.id = id;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPath(String path, boolean pathAsDirectory) {
        this.path = path;
        this.pathAsDirectory = pathAsDirectory;
    }

    public void setStatus(byte status) {
        this.status = status;
    }

    public void setSoFar(long soFar) {
        this.soFar = soFar;
    }

    public void setTotal(long total) {
        this.isLargeFile = total > Integer.MAX_VALUE;
        this.total = total;
    }

    public int getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPath() {
        return this.path;
    }

    public String getTargetFilePath() {
        return FileDownloadUtils.getTargetFilePath(this.getPath(), this.isPathAsDirectory(), this.getFilename());
    }

    public String getTempFilePath() {
        if (this.getTargetFilePath() == null) {
            return null;
        }
        return FileDownloadUtils.getTempPath(this.getTargetFilePath());
    }

    public byte getStatus() {
        return this.status;
    }

    public long getSoFar() {
        return this.soFar;
    }

    public long getTotal() {
        return this.total;
    }

    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isPathAsDirectory() {
        return this.pathAsDirectory;
    }

    public String getFilename() {
        return this.filename;
    }

    public ContentValues toContentValues() {
        ContentValues cv = new ContentValues();
        cv.put(ID, Integer.valueOf(this.getId()));
        cv.put(URL, this.getUrl());
        cv.put(PATH, this.getPath());
        cv.put(STATUS, Byte.valueOf(this.getStatus()));
        cv.put(SOFAR, Long.valueOf(this.getSoFar()));
        cv.put(TOTAL, Long.valueOf(this.getTotal()));
        cv.put(ERR_MSG, this.getErrMsg());
        cv.put(ETAG, this.getETag());
        cv.put(PATH_AS_DIRECTORY, Boolean.valueOf(this.isPathAsDirectory()));
        if (this.isPathAsDirectory() && this.getFilename() != null) {
            cv.put(FILENAME, this.getFilename());
        }
        return cv;
    }

    public boolean isLargeFile() {
        return this.isLargeFile;
    }

    public String toString() {
        return FileDownloadUtils.formatString("id[%d], url[%s], path[%s], status[%d], sofar[%d], total[%d], etag[%s], %s", this.id, this.url, this.path, this.status, this.soFar, this.total, this.eTag, super.toString());
    }
}

