/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.SparseArray;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.services.DefaultDatabaseOpenHelper;
import com.liulishuo.filedownloader.services.FileDownloadDatabase;
import com.liulishuo.filedownloader.services.FileDownloadMgr;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class DefaultDatabaseImpl
implements FileDownloadDatabase {
    private final SQLiteDatabase db;
    public static final String TABLE_NAME = "filedownloader";
    private final SparseArray<FileDownloadModel> downloaderModelMap = new SparseArray();

    public DefaultDatabaseImpl() {
        DefaultDatabaseOpenHelper openHelper = new DefaultDatabaseOpenHelper(FileDownloadHelper.getAppContext());
        this.db = openHelper.getWritableDatabase();
        this.refreshDataFromDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshDataFromDB() {
        long start = System.currentTimeMillis();
        Cursor c = this.db.rawQuery("SELECT * FROM filedownloader", null);
        ArrayList<Integer> dirtyList = new ArrayList<Integer>();
        try {
            while (c.moveToNext()) {
                File tempFile;
                String targetFilePath;
                FileDownloadModel model = new FileDownloadModel();
                model.setId(c.getInt(c.getColumnIndex("_id")));
                model.setUrl(c.getString(c.getColumnIndex("url")));
                model.setPath(c.getString(c.getColumnIndex("path")), c.getShort(c.getColumnIndex("pathAsDirectory")) == 1);
                model.setStatus((byte)c.getShort(c.getColumnIndex("status")));
                model.setSoFar(c.getLong(c.getColumnIndex("sofar")));
                model.setTotal(c.getLong(c.getColumnIndex("total")));
                model.setErrMsg(c.getString(c.getColumnIndex("errMsg")));
                model.setETag(c.getString(c.getColumnIndex("etag")));
                model.setFilename(c.getString(c.getColumnIndex("filename")));
                if (model.getStatus() == 3 || model.getStatus() == 2 || model.getStatus() == -1 || model.getStatus() == 1 && model.getSoFar() > 0L) {
                    model.setStatus((byte)-2);
                }
                if ((targetFilePath = model.getTargetFilePath()) == null) {
                    dirtyList.add(model.getId());
                    continue;
                }
                File targetFile = new File(targetFilePath);
                if (model.getStatus() == -2 && FileDownloadMgr.isBreakpointAvailable(model.getId(), model, model.getPath(), null) && !(tempFile = new File(model.getTempFilePath())).exists() && targetFile.exists()) {
                    boolean successRename = targetFile.renameTo(tempFile);
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(this, "resume from the old no-temp-file architecture [%B], [%s]->[%s]", successRename, targetFile.getPath(), tempFile.getPath());
                    }
                }
                if (model.getStatus() == 1 && model.getSoFar() <= 0L) {
                    dirtyList.add(model.getId());
                    continue;
                }
                if (!FileDownloadMgr.isBreakpointAvailable(model.getId(), model)) {
                    dirtyList.add(model.getId());
                    continue;
                }
                if (targetFile.exists()) {
                    dirtyList.add(model.getId());
                    continue;
                }
                this.downloaderModelMap.put(model.getId(), (Object)model);
            }
        }
        catch (Throwable throwable) {
            c.close();
            FileDownloadUtils.markConverted(FileDownloadHelper.getAppContext());
            if (dirtyList.size() > 0) {
                String args = TextUtils.join((CharSequence)", ", dirtyList);
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, "delete %s", args);
                }
                this.db.execSQL(FileDownloadUtils.formatString("DELETE FROM %s WHERE %s IN (%s);", TABLE_NAME, "_id", args));
            }
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "refresh data %d , will delete: %d consume %d", this.downloaderModelMap.size(), dirtyList.size(), System.currentTimeMillis() - start);
            }
            throw throwable;
        }
        c.close();
        FileDownloadUtils.markConverted(FileDownloadHelper.getAppContext());
        if (dirtyList.size() > 0) {
            String args = TextUtils.join((CharSequence)", ", dirtyList);
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "delete %s", args);
            }
            this.db.execSQL(FileDownloadUtils.formatString("DELETE FROM %s WHERE %s IN (%s);", TABLE_NAME, "_id", args));
        }
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "refresh data %d , will delete: %d consume %d", this.downloaderModelMap.size(), dirtyList.size(), System.currentTimeMillis() - start);
        }
    }

    @Override
    public FileDownloadModel find(int id) {
        return (FileDownloadModel)this.downloaderModelMap.get(id);
    }

    @Override
    public void insert(FileDownloadModel downloadModel) {
        this.downloaderModelMap.put(downloadModel.getId(), (Object)downloadModel);
        this.db.insert(TABLE_NAME, null, downloadModel.toContentValues());
    }

    @Override
    public void update(FileDownloadModel downloadModel) {
        if (downloadModel == null) {
            FileDownloadLog.w(this, "update but model == null!", new Object[0]);
            return;
        }
        if (this.find(downloadModel.getId()) != null) {
            this.downloaderModelMap.remove(downloadModel.getId());
            this.downloaderModelMap.put(downloadModel.getId(), (Object)downloadModel);
            ContentValues cv = downloadModel.toContentValues();
            this.db.update(TABLE_NAME, cv, "_id = ? ", new String[]{String.valueOf(downloadModel.getId())});
        } else {
            this.insert(downloadModel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(List<FileDownloadModel> downloadModelList) {
        if (downloadModelList == null) {
            FileDownloadLog.w(this, "update a download list, but list == null!", new Object[0]);
            return;
        }
        this.db.beginTransaction();
        try {
            for (FileDownloadModel model : downloadModelList) {
                if (this.find(model.getId()) != null) {
                    this.downloaderModelMap.remove(model.getId());
                    this.downloaderModelMap.put(model.getId(), (Object)model);
                    this.db.update(TABLE_NAME, model.toContentValues(), "_id = ? ", new String[]{String.valueOf(model.getId())});
                    continue;
                }
                this.downloaderModelMap.put(model.getId(), (Object)model);
                this.db.insert(TABLE_NAME, null, model.toContentValues());
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    @Override
    public boolean remove(int id) {
        this.downloaderModelMap.remove(id);
        return this.db.delete(TABLE_NAME, "_id = ?", new String[]{String.valueOf(id)}) != 0;
    }

    @Override
    public void clear() {
        this.downloaderModelMap.clear();
        this.db.delete(TABLE_NAME, null, null);
    }

    @Override
    public void updateConnected(FileDownloadModel model, long total, String etag, String filename) {
        model.setStatus((byte)2);
        ContentValues cv = new ContentValues();
        cv.put("status", Byte.valueOf((byte)2));
        long oldTotal = model.getTotal();
        if (oldTotal != total) {
            model.setTotal(total);
            cv.put("total", Long.valueOf(total));
        }
        String oldEtag = model.getETag();
        if (etag != null && !etag.equals(oldEtag) || oldEtag != null && !oldEtag.equals(etag)) {
            model.setETag(etag);
            cv.put("etag", etag);
        }
        if (model.isPathAsDirectory() && model.getFilename() == null && filename != null) {
            model.setFilename(filename);
            cv.put("filename", filename);
        }
        this.update(model.getId(), cv);
    }

    @Override
    public void updateProgress(FileDownloadModel model, long soFar) {
        model.setStatus((byte)3);
        model.setSoFar(soFar);
        ContentValues cv = new ContentValues();
        cv.put("status", Byte.valueOf((byte)3));
        cv.put("sofar", Long.valueOf(soFar));
        this.update(model.getId(), cv);
    }

    @Override
    public void updateError(FileDownloadModel model, Throwable throwable, long sofar) {
        String errMsg = throwable.toString();
        model.setStatus((byte)-1);
        model.setErrMsg(errMsg);
        model.setSoFar(sofar);
        ContentValues cv = new ContentValues();
        cv.put("errMsg", errMsg);
        cv.put("status", Byte.valueOf((byte)-1));
        cv.put("sofar", Long.valueOf(sofar));
        this.update(model.getId(), cv);
    }

    @Override
    public void updateRetry(FileDownloadModel model, Throwable throwable) {
        String errMsg = throwable.toString();
        model.setStatus((byte)5);
        model.setErrMsg(errMsg);
        ContentValues cv = new ContentValues();
        cv.put("errMsg", errMsg);
        cv.put("status", Byte.valueOf((byte)5));
        this.update(model.getId(), cv);
    }

    @Override
    public void updateComplete(FileDownloadModel model, long total) {
        model.setStatus((byte)-3);
        model.setSoFar(total);
        model.setTotal(total);
        ContentValues cv = new ContentValues();
        cv.put("status", Byte.valueOf((byte)-3));
        cv.put("total", Long.valueOf(total));
        cv.put("sofar", Long.valueOf(total));
        this.update(model.getId(), cv);
    }

    @Override
    public void updatePause(FileDownloadModel model, long sofar) {
        model.setStatus((byte)-2);
        model.setSoFar(sofar);
        ContentValues cv = new ContentValues();
        cv.put("status", Byte.valueOf((byte)-2));
        cv.put("sofar", Long.valueOf(sofar));
        this.update(model.getId(), cv);
    }

    @Override
    public void updatePending(FileDownloadModel model) {
        model.setStatus((byte)1);
        ContentValues cv = new ContentValues();
        cv.put("status", Byte.valueOf((byte)1));
        this.update(model.getId(), cv);
    }

    private void update(int id, ContentValues cv) {
        this.db.update(TABLE_NAME, cv, "_id = ? ", new String[]{String.valueOf(id)});
    }
}

