/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import com.liulishuo.filedownloader.connection.FileDownloadUrlConnection;
import com.liulishuo.filedownloader.services.DefaultDatabaseImpl;
import com.liulishuo.filedownloader.services.FileDownloadDatabase;
import com.liulishuo.filedownloader.stream.FileDownloadRandomAccessFile;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;

public class DownloadMgrInitialParams {
    private final InitCustomMaker mMaker;

    public DownloadMgrInitialParams(InitCustomMaker maker) {
        this.mMaker = maker;
        if (maker != null) {
            maker.securityCheck();
        }
    }

    int getMaxNetworkThreadCount() {
        if (this.mMaker == null) {
            return this.getDefaultMaxNetworkThreadCount();
        }
        Integer customizeMaxNetworkThreadCount = this.mMaker.mMaxNetworkThreadCount;
        if (customizeMaxNetworkThreadCount != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize maxNetworkThreadCount: %d", customizeMaxNetworkThreadCount);
            }
            return FileDownloadProperties.getValidNetworkThreadCount(customizeMaxNetworkThreadCount);
        }
        return this.getDefaultMaxNetworkThreadCount();
    }

    FileDownloadDatabase createDatabase() {
        if (this.mMaker == null || this.mMaker.mDatabaseCustomMaker == null) {
            return this.createDefaultDatabase();
        }
        FileDownloadDatabase customDatabase = this.mMaker.mDatabaseCustomMaker.customMake();
        if (customDatabase != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize database: %s", customDatabase);
            }
            return customDatabase;
        }
        return this.createDefaultDatabase();
    }

    FileDownloadHelper.OutputStreamCreator createOutputStreamCreator() {
        if (this.mMaker == null) {
            return this.createDefaultOutputStreamCreator();
        }
        FileDownloadHelper.OutputStreamCreator outputStreamCreator = this.mMaker.mOutputStreamCreator;
        if (outputStreamCreator != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize output stream: %s", outputStreamCreator);
            }
            return outputStreamCreator;
        }
        return this.createDefaultOutputStreamCreator();
    }

    FileDownloadHelper.ConnectionCreator createConnectionCreator() {
        if (this.mMaker == null) {
            return this.createDefaultConnectionCreator();
        }
        FileDownloadHelper.ConnectionCreator connectionCreator = this.mMaker.mConnectionCreator;
        if (connectionCreator != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "initial FileDownloader manager with the customize connection creator: %s", connectionCreator);
            }
            return connectionCreator;
        }
        return this.createDefaultConnectionCreator();
    }

    private int getDefaultMaxNetworkThreadCount() {
        return FileDownloadProperties.getImpl().DOWNLOAD_MAX_NETWORK_THREAD_COUNT;
    }

    private FileDownloadDatabase createDefaultDatabase() {
        return new DefaultDatabaseImpl();
    }

    private FileDownloadHelper.OutputStreamCreator createDefaultOutputStreamCreator() {
        return new FileDownloadRandomAccessFile.Creator();
    }

    private FileDownloadHelper.ConnectionCreator createDefaultConnectionCreator() {
        return new FileDownloadUrlConnection.Creator();
    }

    public static class InitCustomMaker {
        FileDownloadHelper.DatabaseCustomMaker mDatabaseCustomMaker;
        Integer mMaxNetworkThreadCount;
        FileDownloadHelper.OutputStreamCreator mOutputStreamCreator;
        FileDownloadHelper.ConnectionCreator mConnectionCreator;

        public InitCustomMaker database(FileDownloadHelper.DatabaseCustomMaker maker) {
            this.mDatabaseCustomMaker = maker;
            return this;
        }

        public InitCustomMaker maxNetworkThreadCount(int maxNetworkThreadCount) {
            if (maxNetworkThreadCount > 0) {
                this.mMaxNetworkThreadCount = maxNetworkThreadCount;
            }
            return this;
        }

        public InitCustomMaker outputStreamCreator(FileDownloadHelper.OutputStreamCreator creator) {
            this.mOutputStreamCreator = creator;
            return this;
        }

        public InitCustomMaker connectionCreator(FileDownloadHelper.ConnectionCreator creator) {
            this.mConnectionCreator = creator;
            return this;
        }

        private void securityCheck() {
            if (this.mOutputStreamCreator != null && !this.mOutputStreamCreator.supportSeek() && !FileDownloadProperties.getImpl().FILE_NON_PRE_ALLOCATION) {
                throw new IllegalArgumentException("Since the provided FileDownloadOutputStream does not support the seek function, if FileDownloader pre-allocates file size at the beginning of the download, it will can not be resumed from the breakpoint. If you need to ensure that the resumption is available, please add and set the value of 'file.non-pre-allocation' field to 'true' in the 'filedownloader.properties' file which is in your application assets folder manually for resolving this problem.");
            }
        }
    }
}

