/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.app.Notification;
import android.content.Intent;
import android.os.IBinder;
import com.liulishuo.filedownloader.FileDownloadServiceProxy;
import com.liulishuo.filedownloader.i.IFileDownloadIPCCallback;
import com.liulishuo.filedownloader.i.IFileDownloadIPCService;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.services.FileDownloadMgr;
import com.liulishuo.filedownloader.services.FileDownloadService;
import com.liulishuo.filedownloader.services.IFileDownloadServiceHandler;
import java.lang.ref.WeakReference;

public class FDServiceSharedHandler
extends IFileDownloadIPCService.Stub
implements IFileDownloadServiceHandler {
    private final FileDownloadMgr downloadManager;
    private final WeakReference<FileDownloadService> wService;

    FDServiceSharedHandler(WeakReference<FileDownloadService> wService, FileDownloadMgr manager) {
        this.wService = wService;
        this.downloadManager = manager;
    }

    @Override
    public void registerCallback(IFileDownloadIPCCallback callback) {
    }

    @Override
    public void unregisterCallback(IFileDownloadIPCCallback callback) {
    }

    @Override
    public boolean checkDownloading(String url, String path) {
        return this.downloadManager.isDownloading(url, path);
    }

    @Override
    public void start(String url, String path, boolean pathAsDirectory, int callbackProgressTimes, int callbackProgressMinIntervalMillis, int autoRetryTimes, boolean forceReDownload, FileDownloadHeader header, boolean isWifiRequired) {
        this.downloadManager.start(url, path, pathAsDirectory, callbackProgressTimes, callbackProgressMinIntervalMillis, autoRetryTimes, forceReDownload, header, isWifiRequired);
    }

    @Override
    public boolean pause(int downloadId) {
        return this.downloadManager.pause(downloadId);
    }

    @Override
    public void pauseAllTasks() {
        this.downloadManager.pauseAll();
    }

    @Override
    public boolean setMaxNetworkThreadCount(int count) {
        return this.downloadManager.setMaxNetworkThreadCount(count);
    }

    @Override
    public long getSofar(int downloadId) {
        return this.downloadManager.getSoFar(downloadId);
    }

    @Override
    public long getTotal(int downloadId) {
        return this.downloadManager.getTotal(downloadId);
    }

    @Override
    public byte getStatus(int downloadId) {
        return this.downloadManager.getStatus(downloadId);
    }

    @Override
    public boolean isIdle() {
        return this.downloadManager.isIdle();
    }

    @Override
    public void startForeground(int id, Notification notification) {
        if (this.wService != null && this.wService.get() != null) {
            ((FileDownloadService)((Object)this.wService.get())).startForeground(id, notification);
        }
    }

    @Override
    public void stopForeground(boolean removeNotification) {
        if (this.wService != null && this.wService.get() != null) {
            ((FileDownloadService)((Object)this.wService.get())).stopForeground(removeNotification);
        }
    }

    @Override
    public boolean clearTaskData(int id) {
        return this.downloadManager.clearTaskData(id);
    }

    @Override
    public void clearAllTaskData() {
        this.downloadManager.clearAllTaskData();
    }

    @Override
    public void onStartCommand(Intent intent, int flags, int startId) {
        FileDownloadServiceProxy.getConnectionListener().onConnected(this);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return null;
    }

    @Override
    public void onDestroy() {
        FileDownloadServiceProxy.getConnectionListener().onDisconnected();
    }

    public static interface FileDownloadServiceSharedConnection {
        public void onConnected(FDServiceSharedHandler var1);

        public void onDisconnected();
    }
}

