/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import com.liulishuo.filedownloader.IThreadPoolMonitor;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.model.FileDownloadStatus;
import com.liulishuo.filedownloader.services.DownloadMgrInitialParams;
import com.liulishuo.filedownloader.services.FileDownloadDatabase;
import com.liulishuo.filedownloader.services.FileDownloadRunnable;
import com.liulishuo.filedownloader.services.FileDownloadThreadPool;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.util.List;

class FileDownloadMgr
implements IThreadPoolMonitor {
    private final FileDownloadDatabase mDatabase;
    private final FileDownloadThreadPool mThreadPool;
    private final FileDownloadHelper.OutputStreamCreator mOutputStreamCreator;
    private final FileDownloadHelper.ConnectionCreator mConnectionCreator;

    public FileDownloadMgr(DownloadMgrInitialParams params) {
        this.mDatabase = params.createDatabase();
        this.mThreadPool = new FileDownloadThreadPool(params.getMaxNetworkThreadCount());
        this.mOutputStreamCreator = params.createOutputStreamCreator();
        this.mConnectionCreator = params.createConnectionCreator();
    }

    public synchronized void start(String url, String path, boolean pathAsDirectory, int callbackProgressTimes, int callbackProgressMinIntervalMillis, int autoRetryTimes, boolean forceReDownload, FileDownloadHeader header, boolean isWifiRequired) {
        boolean needUpdate2DB;
        String targetFilePath;
        int dirCaseId;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "request start the task with url(%s) path(%s) isDirectory(%B)", url, path, pathAsDirectory);
        }
        int id = FileDownloadUtils.generateId(url, path, pathAsDirectory);
        FileDownloadModel model = this.mDatabase.find(id);
        if (!pathAsDirectory && model == null && (model = this.mDatabase.find(dirCaseId = FileDownloadUtils.generateId(url, FileDownloadUtils.getParent(path), true))) != null && path.equals(model.getTargetFilePath()) && FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "task[%d] find model by dirCaseId[%d]", id, dirCaseId);
        }
        if (FileDownloadHelper.inspectAndInflowDownloading(id, model, this, true)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "has already started download %d", id);
            }
            return;
        }
        String string = targetFilePath = model != null ? model.getTargetFilePath() : FileDownloadUtils.getTargetFilePath(path, pathAsDirectory, null);
        if (FileDownloadHelper.inspectAndInflowDownloaded(id, targetFilePath, forceReDownload, true)) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "has already completed downloading %d", id);
            }
            return;
        }
        if (model != null && (model.getStatus() == -2 || model.getStatus() == -1)) {
            if (model.getId() != id) {
                this.mDatabase.remove(model.getId());
                model.setId(id);
                model.setPath(path, pathAsDirectory);
                needUpdate2DB = true;
            } else {
                needUpdate2DB = false;
            }
        } else {
            if (model == null) {
                model = new FileDownloadModel();
            }
            model.setUrl(url);
            model.setPath(path, pathAsDirectory);
            model.setId(id);
            model.setSoFar(0L);
            model.setTotal(0L);
            model.setStatus((byte)1);
            needUpdate2DB = true;
        }
        if (needUpdate2DB) {
            this.mDatabase.update(model);
        }
        this.mThreadPool.execute(new FileDownloadRunnable(this, this.mOutputStreamCreator, this.mConnectionCreator, model, this.mDatabase, autoRetryTimes, header, callbackProgressMinIntervalMillis, callbackProgressTimes, forceReDownload, isWifiRequired));
    }

    public boolean isDownloading(String url, String path) {
        return this.isDownloading(FileDownloadUtils.generateId(url, path));
    }

    public boolean isDownloading(int id) {
        return this.isDownloading(this.mDatabase.find(id));
    }

    public static boolean isBreakpointAvailable(int id, FileDownloadModel model) {
        return FileDownloadMgr.isBreakpointAvailable(id, model, null);
    }

    public static boolean isBreakpointAvailable(int id, FileDownloadModel model, Boolean outputStreamSupportSeek) {
        if (model == null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(FileDownloadMgr.class, "can't continue %d model == null", id);
            }
            return false;
        }
        if (model.getTempFilePath() == null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(FileDownloadMgr.class, "can't continue %d temp path == null", id);
            }
            return false;
        }
        return FileDownloadMgr.isBreakpointAvailable(id, model, model.getTempFilePath(), outputStreamSupportSeek);
    }

    public static boolean isBreakpointAvailable(int id, FileDownloadModel model, String path, Boolean outputStreamSupportSeek) {
        boolean result = false;
        if (path == null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(FileDownloadMgr.class, "can't continue %d path = null", id);
            }
        } else {
            File file = new File(path);
            boolean isExists = file.exists();
            boolean isDirectory = file.isDirectory();
            if (!isExists || isDirectory) {
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(FileDownloadMgr.class, "can't continue %d file not suit, exists[%B], directory[%B]", id, isExists, isDirectory);
                }
            } else {
                long fileLength = file.length();
                if (model.getSoFar() == 0L) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(FileDownloadMgr.class, "can't continue %d the downloaded-record is zero.", id);
                    }
                } else if (fileLength < model.getSoFar() || model.getTotal() != -1L && (fileLength > model.getTotal() || model.getSoFar() >= model.getTotal())) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(FileDownloadMgr.class, "can't continue %d dirty data fileLength[%d] sofar[%d] total[%d]", id, fileLength, model.getSoFar(), model.getTotal());
                    }
                } else if (outputStreamSupportSeek != null && !outputStreamSupportSeek.booleanValue() && model.getTotal() == fileLength) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(FileDownloadMgr.class, "can't continue %d, because of the output stream doesn't support seek, but the task has already pre-allocated, so we only can download it from the very beginning.", id);
                    }
                } else {
                    result = true;
                }
            }
        }
        return result;
    }

    public boolean pause(int id) {
        FileDownloadModel model;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "request pause the task %d", id);
        }
        if ((model = this.mDatabase.find(id)) == null) {
            return false;
        }
        this.mThreadPool.cancel(id);
        return true;
    }

    public void pauseAll() {
        List<Integer> list = this.mThreadPool.getAllExactRunningDownloadIds();
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "pause all tasks %d", list.size());
        }
        for (Integer id : list) {
            this.pause(id);
        }
    }

    public long getSoFar(int id) {
        FileDownloadModel model = this.mDatabase.find(id);
        if (model == null) {
            return 0L;
        }
        return model.getSoFar();
    }

    public long getTotal(int id) {
        FileDownloadModel model = this.mDatabase.find(id);
        if (model == null) {
            return 0L;
        }
        return model.getTotal();
    }

    public byte getStatus(int id) {
        FileDownloadModel model = this.mDatabase.find(id);
        if (model == null) {
            return 0;
        }
        return model.getStatus();
    }

    public boolean isIdle() {
        return this.mThreadPool.exactSize() <= 0;
    }

    public synchronized boolean setMaxNetworkThreadCount(int count) {
        return this.mThreadPool.setMaxNetworkThreadCount(count);
    }

    @Override
    public boolean isDownloading(FileDownloadModel model) {
        boolean isDownloading;
        if (model == null) {
            return false;
        }
        boolean isInPool = this.mThreadPool.isInThreadPool(model.getId());
        if (FileDownloadStatus.isOver(model.getStatus())) {
            isDownloading = isInPool;
        } else if (isInPool) {
            isDownloading = true;
        } else {
            FileDownloadLog.e((Object)this, "%d status is[%s](not finish) & but not in the pool", model.getId(), model.getStatus());
            isDownloading = false;
        }
        return isDownloading;
    }

    public boolean clearTaskData(int id) {
        if (id == 0) {
            FileDownloadLog.w(this, "The task[%d] id is invalid, can't clear it.", id);
            return false;
        }
        if (this.isDownloading(id)) {
            FileDownloadLog.w(this, "The task[%d] is downloading, can't clear it.", id);
            return false;
        }
        this.mDatabase.remove(id);
        return true;
    }

    public void clearAllTaskData() {
        this.mDatabase.clear();
    }
}

