/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.database.sqlite.SQLiteFullException;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import com.liulishuo.filedownloader.IThreadPoolMonitor;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadHttpException;
import com.liulishuo.filedownloader.exception.FileDownloadNetworkPolicyException;
import com.liulishuo.filedownloader.exception.FileDownloadOutOfSpaceException;
import com.liulishuo.filedownloader.message.MessageSnapshotFlow;
import com.liulishuo.filedownloader.message.MessageSnapshotTaker;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.services.FileDownloadDatabase;
import com.liulishuo.filedownloader.services.FileDownloadMgr;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FileDownloadRunnable
implements Runnable {
    private static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final int NO_ANY_PROGRESS_CALLBACK = -1;
    private static final int TOTAL_VALUE_IN_CHUNKED_RESOURCE = -1;
    private static final int CALLBACK_SAFE_MIN_INTERVAL_BYTES = 1;
    private static final int CALLBACK_SAFE_MIN_INTERVAL_MILLIS = 5;
    private static final int BUFFER_SIZE = 4096;
    private int maxProgressCount = 0;
    private final boolean isForceReDownload;
    private boolean isResumeDownloadAvailable;
    private boolean isResuming;
    private Throwable throwable;
    private int retryingTimes;
    private FileDownloadModel model;
    private volatile boolean isRunning = false;
    private volatile boolean isPending = false;
    private final FileDownloadDatabase helper;
    private final int autoRetryTimes;
    private final FileDownloadHeader header;
    private volatile boolean isCanceled = false;
    private final int callbackMinIntervalMillis;
    private long callbackMinIntervalBytes;
    private final IThreadPoolMonitor threadPoolMonitor;
    private final boolean mIsWifiRequired;
    private final int mId;
    private final FileDownloadHelper.OutputStreamCreator mOutputStreamCreator;
    private final FileDownloadHelper.ConnectionCreator mConnectionCreator;
    private long lastCallbackBytes = 0L;
    private long lastCallbackTime = 0L;
    private long lastUpdateBytes = 0L;
    private long lastUpdateTime = 0L;
    private final Object statusChangedNotifyLock = new Object();

    public FileDownloadRunnable(IThreadPoolMonitor threadPoolMonitor, FileDownloadHelper.OutputStreamCreator outputStreamCreator, FileDownloadHelper.ConnectionCreator connectionCreator, FileDownloadModel model, FileDownloadDatabase helper, int autoRetryTimes, FileDownloadHeader header, int minIntervalMillis, int callbackProgressTimes, boolean isForceReDownload, boolean isWifiRequired) {
        this.mId = model.getId();
        this.mIsWifiRequired = isWifiRequired;
        this.isPending = true;
        this.isRunning = false;
        this.threadPoolMonitor = threadPoolMonitor;
        this.mOutputStreamCreator = outputStreamCreator;
        this.helper = helper;
        this.header = header;
        this.callbackMinIntervalMillis = minIntervalMillis < 5 ? 5 : minIntervalMillis;
        this.maxProgressCount = callbackProgressTimes;
        this.isForceReDownload = isForceReDownload;
        this.isResumeDownloadAvailable = false;
        this.model = model;
        this.autoRetryTimes = autoRetryTimes;
        this.mConnectionCreator = connectionCreator;
    }

    public int getId() {
        return this.mId;
    }

    public boolean isExist() {
        return this.isPending || this.isRunning;
    }

    public boolean isResuming() {
        return this.isResuming;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public int getRetryingTimes() {
        return this.retryingTimes;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        this.isPending = false;
        this.isRunning = true;
        try {
            if (this.model == null) {
                FileDownloadLog.e((Object)this, "start runnable but model == null?? %s", this.mId);
                this.model = this.helper.find(this.mId);
                if (this.model == null) {
                    FileDownloadLog.e((Object)this, "start runnable but downloadMode == null?? %s", this.mId);
                    return;
                }
            }
            if (this.model.getStatus() != 1) {
                if (this.model.getStatus() == -2) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(this, "High concurrent cause, start runnable but already paused %d", this.mId);
                    }
                } else {
                    this.onError(new RuntimeException(FileDownloadUtils.formatString("Task[%d] can't start the download runnable, because its status is %d not %d", this.mId, this.model.getStatus(), (byte)1)));
                }
                return;
            }
            if (this.mIsWifiRequired && !FileDownloadUtils.checkPermission("android.permission.ACCESS_NETWORK_STATE")) {
                this.onError(new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("Task[%d] can't start the download runnable, because this task require wifi, but user application nor current process has %s, so we can't check whether the network type connection.", this.mId, "android.permission.ACCESS_NETWORK_STATE")));
                return;
            }
            this.onStarted();
            this.loop(this.model);
        }
        finally {
            this.isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void loop(FileDownloadModel model) {
        retryingTimes = 0;
        revisedInterval = false;
        connection = null;
        while (true) lbl-1000:
        // 6 sources

        {
            soFar = 0L;
            id = this.mId;
            try {
                block33: {
                    if (this.checkState()) {
                        if (FileDownloadLog.NEED_LOG) {
                            FileDownloadLog.d(this, "already canceled %d %d", new Object[]{id, model.getStatus()});
                        }
                        this.onPause();
                        break;
                    }
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(FileDownloadRunnable.class, "start download %s %s", new Object[]{id, model.getUrl()});
                    }
                    this.checkIsResumeAvailable();
                    connection = this.mConnectionCreator.create(model.getUrl());
                    this.addHeader(connection);
                    requestHeader = connection.getRequestHeaderFields();
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(this, "%s request header %s", new Object[]{id, requestHeader});
                    }
                    connection.execute();
                    code = connection.getResponseCode();
                    isSucceedStart = code == 200 || code == 0;
                    v0 = isSucceedResume = (code == 206 || code == 1) && this.isResumeDownloadAvailable != false;
                    if (this.isResumeDownloadAvailable && !isSucceedResume) {
                        FileDownloadLog.w(this, "tried to resume from the break point[%d], but the response code is %d, not 206(PARTIAL).", new Object[]{model.getSoFar(), code});
                    }
                    if (!isSucceedStart && !isSucceedResume) break block33;
                    total = model.getTotal();
                    transferEncoding = connection.getResponseHeaderField("Transfer-Encoding");
                    if (isSucceedStart || total <= 0L) {
                        total = transferEncoding == null ? FileDownloadUtils.convertContentLengthString(connection.getResponseHeaderField("Content-Length")) : -1L;
                    }
                    if (total < 0L) {
                        v1 = isEncodingChunked = transferEncoding != null && transferEncoding.equals("chunked") != false;
                        if (!isEncodingChunked) {
                            if (FileDownloadProperties.getImpl().HTTP_LENIENT) {
                                total = -1L;
                                if (FileDownloadLog.NEED_LOG) {
                                    FileDownloadLog.d(this, "%d response header is not legal but HTTP lenient is true, so handle as the case of transfer encoding chunk", new Object[]{id});
                                }
                            } else {
                                throw new FileDownloadGiveUpRetryException("can't know the size of the download file, and its Transfer-Encoding is not Chunked either.\nyou can ignore such exception by add http.lenient=true to the filedownloader.properties");
                            }
                        }
                    }
                    if (isSucceedResume) {
                        soFar = model.getSoFar();
                    }
                    this.onConnected(isSucceedResume, total, this.findEtag(connection), this.findFilename(connection));
                    if (!model.isPathAsDirectory()) ** GOTO lbl65
                    fileCaseId = FileDownloadUtils.generateId(model.getUrl(), model.getTargetFilePath());
                    if (FileDownloadHelper.inspectAndInflowDownloaded(id, model.getTargetFilePath(), this.isForceReDownload, false)) {
                        this.helper.remove(id);
                        break;
                    }
                    fileCaseModel = this.helper.find(fileCaseId);
                    if (fileCaseModel == null) ** GOTO lbl65
                    if (FileDownloadHelper.inspectAndInflowDownloading(id, fileCaseModel, this.threadPoolMonitor, false)) {
                        this.helper.remove(id);
                    } else {
                        this.helper.remove(fileCaseId);
                        this.deleteTargetFile();
                        if (FileDownloadMgr.isBreakpointAvailable(fileCaseId, fileCaseModel)) {
                            model.setSoFar(fileCaseModel.getSoFar());
                            model.setTotal(fileCaseModel.getTotal());
                            model.setETag(fileCaseModel.getETag());
                            this.helper.update(model);
                            continue;
                        }
lbl65:
                        // 4 sources

                        if (!this.fetch(connection, isSucceedResume, soFar, total)) {
                            continue;
                        }
                    }
                    break;
                }
                httpException = new FileDownloadHttpException(code, requestHeader, connection.getResponseHeaderFields());
                if (revisedInterval) {
                    throw httpException;
                }
                revisedInterval = true;
                switch (code) {
                    case 416: {
                        this.deleteTaskFiles();
                        FileDownloadLog.w(FileDownloadRunnable.class, "%d response code %d, range[%d] isn't make sense, so delete the dirty file[%s], and try to redownload it from byte-0.", new Object[]{id, code, model.getSoFar(), model.getTempFilePath()});
                        this.onRetry(httpException, retryingTimes++);
                        ** break;
                    }
                    default: {
                        throw httpException;
                    }
                }
            }
            catch (Throwable ex) {
                if (this.autoRetryTimes > retryingTimes++ && !(ex instanceof FileDownloadGiveUpRetryException)) {
                    this.onRetry(ex, retryingTimes);
                    continue;
                }
                this.onError(ex);
            }
            finally {
                if (connection == null) continue;
                connection.ending();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetch(FileDownloadConnection connection, boolean isSucceedContinue, long soFar, long total) throws Throwable {
        InputStream inputStream = null;
        FileDownloadOutputStream outputStream = this.getOutputStream(isSucceedContinue, total);
        try {
            int byteCount;
            inputStream = connection.getInputStream();
            byte[] buff = new byte[4096];
            this.callbackMinIntervalBytes = this.calculateCallbackMinIntervalBytes(total, this.maxProgressCount);
            while ((byteCount = inputStream.read(buff)) != -1) {
                outputStream.write(buff, 0, byteCount);
                this.onProgress(soFar += (long)byteCount, total, outputStream);
                if (!this.checkState()) continue;
                this.onPause();
                boolean bl = true;
                return bl;
            }
            if (total == -1L) {
                total = soFar;
            }
            if (soFar == total) {
                this.renameTempFile();
                this.helper.remove(this.mId);
                this.onComplete(total);
                boolean bl = true;
                return bl;
            }
            throw new RuntimeException(FileDownloadUtils.formatString("sofar[%d] not equal total[%d]", soFar, total));
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.sync();
                }
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void renameTempFile() {
        String tempPath = this.model.getTempFilePath();
        String targetPath = this.model.getTargetFilePath();
        File tempFile = new File(tempPath);
        try {
            File targetFile = new File(targetPath);
            if (targetFile.exists()) {
                long oldTargetFileLength = targetFile.length();
                if (!targetFile.delete()) {
                    throw new IllegalStateException(FileDownloadUtils.formatString("Can't delete the old file([%s], [%d]), so can't replace it with the new downloaded one.", targetPath, oldTargetFileLength));
                }
                FileDownloadLog.w(this, "The target file([%s], [%d]) will be replaced with the new downloaded file[%d]", targetPath, oldTargetFileLength, tempFile.length());
            }
            if (!tempFile.renameTo(targetFile)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("Can't rename the  temp downloaded file(%s) to the target file(%s)", tempPath, targetPath));
            }
            if (!tempFile.exists() || tempFile.delete()) return;
        }
        catch (Throwable throwable) {
            if (!tempFile.exists() || tempFile.delete()) throw throwable;
            FileDownloadLog.w(this, "delete the temp file(%s) failed, on completed downloading.", tempPath);
            throw throwable;
        }
        FileDownloadLog.w(this, "delete the temp file(%s) failed, on completed downloading.", tempPath);
    }

    private long calculateCallbackMinIntervalBytes(long total, long maxProgressCount) {
        if (maxProgressCount <= 0L) {
            return -1L;
        }
        if (total == -1L) {
            return 1L;
        }
        long minIntervalBytes = total / (maxProgressCount + 1L);
        return minIntervalBytes <= 0L ? 1L : minIntervalBytes;
    }

    private void addHeader(FileDownloadConnection connection) {
        HashMap<String, List<String>> additionHeaders;
        if (this.header != null && (additionHeaders = this.header.getHeaders()) != null) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.v(this, "%d add outside header: %s", this.mId, additionHeaders);
            }
            Set<Map.Entry<String, List<String>>> entries = additionHeaders.entrySet();
            for (Map.Entry<String, List<String>> e : entries) {
                String name = e.getKey();
                List<String> list = e.getValue();
                if (list == null) continue;
                for (String value : list) {
                    connection.addHeader(name, value);
                }
            }
        }
        String etag = this.model.getETag();
        long offset = this.model.getSoFar();
        if (this.isResumeDownloadAvailable && !connection.dispatchAddResumeOffset(etag, offset)) {
            if (!TextUtils.isEmpty((CharSequence)etag)) {
                connection.addHeader("If-Match", etag);
            }
            connection.addHeader("Range", FileDownloadUtils.formatString("bytes=%d-", offset));
        }
    }

    private String findEtag(FileDownloadConnection connection) {
        if (connection == null) {
            throw new RuntimeException("connection is null when findEtag");
        }
        String newEtag = connection.getResponseHeaderField("Etag");
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "etag find by header %d %s", this.mId, newEtag);
        }
        return newEtag;
    }

    private String findFilename(FileDownloadConnection connection) {
        String filename;
        if (this.model.isPathAsDirectory() && this.model.getFilename() == null) {
            filename = FileDownloadUtils.parseContentDisposition(connection.getResponseHeaderField("Content-Disposition"));
            if (TextUtils.isEmpty((CharSequence)filename)) {
                filename = FileDownloadUtils.generateFileName(this.model.getUrl());
            }
        } else {
            filename = null;
        }
        return filename;
    }

    public void cancelRunnable() {
        this.isCanceled = true;
        this.onPause();
    }

    private void onConnected(boolean resuming, long total, String etag, String filename) {
        this.helper.updateConnected(this.model, total, etag, filename);
        this.isResuming = resuming;
        this.onStatusChanged(this.model.getStatus());
    }

    private void onProgress(long soFar, long total, FileDownloadOutputStream outputStream) {
        if (soFar == total) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        long bytesDelta = soFar - this.lastUpdateBytes;
        long timeDelta = now - this.lastUpdateTime;
        if (bytesDelta > (long)FileDownloadUtils.getMinProgressStep() && timeDelta > FileDownloadUtils.getMinProgressTime()) {
            try {
                outputStream.sync();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.helper.updateProgress(this.model, soFar);
            this.lastUpdateBytes = soFar;
            this.lastUpdateTime = now;
        } else {
            if (this.model.getStatus() != 3) {
                this.model.setStatus((byte)3);
            }
            this.model.setSoFar(soFar);
        }
        long callbackBytesDelta = soFar - this.lastCallbackBytes;
        long callbackTimeDelta = now - this.lastCallbackTime;
        if (this.callbackMinIntervalBytes == -1L || callbackBytesDelta < this.callbackMinIntervalBytes) {
            return;
        }
        if (callbackTimeDelta < (long)this.callbackMinIntervalMillis) {
            return;
        }
        this.lastCallbackTime = now;
        this.lastCallbackBytes = soFar;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "On progress %d %d %d", this.mId, soFar, total);
        }
        this.onStatusChanged(this.model.getStatus());
    }

    private void onRetry(Throwable ex, int retryTimes) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "On retry %d %s %d %d", this.mId, ex, retryTimes, this.autoRetryTimes);
        }
        ex = this.exFiltrate(ex);
        this.helper.updateRetry(this.model, ex);
        this.throwable = ex;
        this.retryingTimes = retryTimes;
        this.onStatusChanged(this.model.getStatus());
    }

    private void onError(Throwable originError) {
        Throwable processError;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "On error %d %s", this.mId, originError);
        }
        if ((processError = this.exFiltrate(originError)) instanceof SQLiteFullException) {
            this.handleSQLiteFullException((SQLiteFullException)processError);
        } else {
            try {
                this.helper.updateError(this.model, processError, this.model.getSoFar());
                processError = originError;
            }
            catch (SQLiteFullException fullException) {
                processError = fullException;
                this.handleSQLiteFullException((SQLiteFullException)processError);
            }
        }
        this.throwable = processError;
        this.onStatusChanged(this.model.getStatus());
    }

    private void handleSQLiteFullException(SQLiteFullException sqLiteFullException) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "the data of the task[%d] is dirty, because the SQLite full exception[%s], so remove it from the database directly.", this.mId, sqLiteFullException.toString());
        }
        this.model.setErrMsg(sqLiteFullException.toString());
        this.model.setStatus((byte)-1);
        this.helper.remove(this.mId);
    }

    private void onComplete(long total) {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "On completed %d %d %B", this.mId, total, this.isCanceled);
        }
        this.helper.updateComplete(this.model, total);
        this.onStatusChanged(this.model.getStatus());
    }

    private void onPause() {
        this.isRunning = false;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "On paused %d %d %d", this.mId, this.model.getSoFar(), this.model.getTotal());
        }
        this.helper.updatePause(this.model, this.model.getSoFar());
        this.onStatusChanged(this.model.getStatus());
    }

    private void onStarted() {
        this.model.setStatus((byte)6);
        this.onStatusChanged(this.model.getStatus());
    }

    public void onPending() {
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "On resume %d", this.mId);
        }
        this.isPending = true;
        this.helper.updatePending(this.model);
        this.onStatusChanged(this.model.getStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStatusChanged(byte status) {
        Object object = this.statusChangedNotifyLock;
        synchronized (object) {
            if (this.model.getStatus() == -2) {
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, "High concurrent cause, Already paused and we don't need to call-back to Task in here, %d", this.mId);
                }
                return;
            }
            MessageSnapshotFlow.getImpl().inflow(MessageSnapshotTaker.take(status, this.model, this));
        }
    }

    private boolean checkState() {
        if (this.isCanceled) {
            return true;
        }
        if (this.mIsWifiRequired && !FileDownloadUtils.isNetworkOnWifiType()) {
            throw new FileDownloadNetworkPolicyException();
        }
        return false;
    }

    private FileDownloadOutputStream getOutputStream(boolean append, long totalBytes) throws IOException, IllegalAccessException {
        String tempPath = this.model.getTempFilePath();
        if (TextUtils.isEmpty((CharSequence)tempPath)) {
            throw new RuntimeException("found invalid internal destination path, empty");
        }
        if (!FileDownloadUtils.isFilenameValid(tempPath)) {
            throw new RuntimeException(FileDownloadUtils.formatString("found invalid internal destination filename %s", tempPath));
        }
        File file = new File(tempPath);
        if (file.exists() && file.isDirectory()) {
            throw new RuntimeException(FileDownloadUtils.formatString("found invalid internal destination path[%s], & path is directory[%B]", tempPath, file.isDirectory()));
        }
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException(FileDownloadUtils.formatString("create new file error  %s", file.getAbsolutePath()));
        }
        FileDownloadOutputStream outputStream = this.mOutputStreamCreator.create(file);
        if (totalBytes > 0L) {
            long breakpointBytes = file.length();
            long requiredSpaceBytes = totalBytes - breakpointBytes;
            long freeSpaceBytes = FileDownloadUtils.getFreeSpaceBytes(tempPath);
            if (freeSpaceBytes < requiredSpaceBytes) {
                outputStream.close();
                throw new FileDownloadOutOfSpaceException(freeSpaceBytes, requiredSpaceBytes, breakpointBytes);
            }
            if (!FileDownloadProperties.getImpl().FILE_NON_PRE_ALLOCATION) {
                outputStream.setLength(totalBytes);
            }
        }
        if (append && this.mOutputStreamCreator.supportSeek()) {
            outputStream.seek(this.model.getSoFar());
        }
        return outputStream;
    }

    private void checkIsResumeAvailable() {
        boolean outputStreamSupportSeek = this.mOutputStreamCreator.supportSeek();
        if (FileDownloadMgr.isBreakpointAvailable(this.mId, this.model, outputStreamSupportSeek)) {
            this.isResumeDownloadAvailable = true;
            if (!outputStreamSupportSeek) {
                this.model.setSoFar(new File(this.model.getTempFilePath()).length());
            }
        } else {
            this.isResumeDownloadAvailable = false;
            this.deleteTaskFiles();
        }
    }

    private void deleteTaskFiles() {
        this.deleteTempFile();
        this.deleteTargetFile();
    }

    private void deleteTempFile() {
        File tempFile;
        String tempFilePath = this.model.getTempFilePath();
        if (tempFilePath != null && (tempFile = new File(tempFilePath)).exists()) {
            tempFile.delete();
        }
    }

    private void deleteTargetFile() {
        File targetFile;
        String targetFilePath = this.model.getTargetFilePath();
        if (targetFilePath != null && (targetFile = new File(targetFilePath)).exists()) {
            targetFile.delete();
        }
    }

    private Throwable exFiltrate(Throwable ex) {
        long freeSpaceBytes;
        String tempPath = this.model.getTempFilePath();
        if ((this.model.getTotal() == -1L || FileDownloadProperties.getImpl().FILE_NON_PRE_ALLOCATION) && ex instanceof IOException && new File(tempPath).exists() && (freeSpaceBytes = FileDownloadUtils.getFreeSpaceBytes(tempPath)) <= 4096L) {
            long downloadedSize = 0L;
            File file = new File(tempPath);
            if (!file.exists()) {
                FileDownloadLog.e(FileDownloadRunnable.class, ex, "Exception with: free space isn't enough, and the target file not exist.", new Object[0]);
            } else {
                downloadedSize = file.length();
            }
            ex = Build.VERSION.SDK_INT >= 9 ? new FileDownloadOutOfSpaceException(freeSpaceBytes, 4096L, downloadedSize, ex) : new FileDownloadOutOfSpaceException(freeSpaceBytes, 4096L, downloadedSize);
        }
        return ex;
    }
}

