/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.services;

import android.util.SparseArray;
import com.liulishuo.filedownloader.services.FileDownloadRunnable;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;

class FileDownloadThreadPool {
    private SparseArray<FileDownloadRunnable> runnablePool = new SparseArray();
    private ThreadPoolExecutor mThreadPool;
    private final String THREAD_PREFIX = "Network";
    private int mMaxThreadCount;
    private int mIgnoreCheckTimes = 0;

    FileDownloadThreadPool(int maxNetworkThreadCount) {
        this.mThreadPool = FileDownloadExecutors.newDefaultThreadPool(maxNetworkThreadCount, "Network");
        this.mMaxThreadCount = maxNetworkThreadCount;
    }

    public synchronized boolean setMaxNetworkThreadCount(int count) {
        if (this.exactSize() > 0) {
            FileDownloadLog.w(this, "Can't change the max network thread count, because the  network thread pool isn't in IDLE, please try again after all running tasks are completed or invoking FileDownloader#pauseAll directly.", new Object[0]);
            return false;
        }
        int validCount = FileDownloadProperties.getValidNetworkThreadCount(count);
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "change the max network thread count, from %d to %d", this.mMaxThreadCount, validCount);
        }
        List<Runnable> taskQueue = this.mThreadPool.shutdownNow();
        this.mThreadPool = FileDownloadExecutors.newDefaultThreadPool(validCount, "Network");
        if (taskQueue.size() > 0) {
            FileDownloadLog.w(this, "recreate the network thread pool and discard %d tasks", taskQueue.size());
        }
        this.mMaxThreadCount = validCount;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(FileDownloadRunnable runnable) {
        runnable.onPending();
        FileDownloadThreadPool fileDownloadThreadPool = this;
        synchronized (fileDownloadThreadPool) {
            this.runnablePool.put(runnable.getId(), (Object)runnable);
        }
        this.mThreadPool.execute(runnable);
        int CHECK_THRESHOLD_VALUE = 600;
        if (this.mIgnoreCheckTimes >= 600) {
            this.checkNoExist();
            this.mIgnoreCheckTimes = 0;
        } else {
            ++this.mIgnoreCheckTimes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(int id) {
        this.checkNoExist();
        FileDownloadThreadPool fileDownloadThreadPool = this;
        synchronized (fileDownloadThreadPool) {
            FileDownloadRunnable r = (FileDownloadRunnable)this.runnablePool.get(id);
            if (r != null) {
                r.cancelRunnable();
                boolean result = this.mThreadPool.remove(r);
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, "successful cancel %d %B", id, result);
                }
            }
            this.runnablePool.remove(id);
        }
    }

    private synchronized void checkNoExist() {
        SparseArray correctedRunnablePool = new SparseArray();
        for (int i = 0; i < this.runnablePool.size(); ++i) {
            int key = this.runnablePool.keyAt(i);
            FileDownloadRunnable runnable = (FileDownloadRunnable)this.runnablePool.get(key);
            if (!runnable.isExist()) continue;
            correctedRunnablePool.put(key, (Object)runnable);
        }
        this.runnablePool = correctedRunnablePool;
    }

    public boolean isInThreadPool(int downloadId) {
        FileDownloadRunnable runnable = (FileDownloadRunnable)this.runnablePool.get(downloadId);
        return runnable != null && runnable.isExist();
    }

    public synchronized int exactSize() {
        this.checkNoExist();
        return this.runnablePool.size();
    }

    public synchronized List<Integer> getAllExactRunningDownloadIds() {
        this.checkNoExist();
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < this.runnablePool.size(); ++i) {
            list.add(((FileDownloadRunnable)this.runnablePool.get(this.runnablePool.keyAt(i))).getId());
        }
        return list;
    }
}

