/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.stream;

import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileDownloadBufferedOutputStream
implements FileDownloadOutputStream {
    private final BufferedOutputStream mStream;

    FileDownloadBufferedOutputStream(File file) throws FileNotFoundException {
        this.mStream = new BufferedOutputStream(new FileOutputStream(file, true));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mStream.write(b, off, len);
    }

    @Override
    public void sync() throws IOException {
        this.mStream.flush();
    }

    @Override
    public void close() throws IOException {
        this.mStream.close();
    }

    @Override
    public void seek(long offset) throws IOException, IllegalAccessException {
        throw new IllegalAccessException("Can't support 'seek' in BufferedOutputStream.");
    }

    @Override
    public void setLength(long totalBytes) throws IOException, IllegalAccessException {
        throw new IllegalAccessException("Can't support 'setLength' in BufferedOutputStream.");
    }

    public static class Creator
    implements FileDownloadHelper.OutputStreamCreator {
        @Override
        public FileDownloadOutputStream create(File file) throws FileNotFoundException {
            return new FileDownloadBufferedOutputStream(file);
        }

        @Override
        public boolean supportSeek() {
            return false;
        }
    }
}

