/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.stream;

import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class FileDownloadRandomAccessFile
implements FileDownloadOutputStream {
    private final RandomAccessFile mAccessFile;

    FileDownloadRandomAccessFile(File file) throws FileNotFoundException {
        this.mAccessFile = new RandomAccessFile(file, "rw");
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.mAccessFile.write(b, off, len);
    }

    @Override
    public void sync() throws IOException {
        this.mAccessFile.getFD().sync();
    }

    @Override
    public void close() throws IOException {
        this.mAccessFile.close();
    }

    @Override
    public void seek(long offset) throws IOException {
        this.mAccessFile.seek(offset);
    }

    @Override
    public void setLength(long totalBytes) throws IOException {
        this.mAccessFile.setLength(totalBytes);
    }

    public static class Creator
    implements FileDownloadHelper.OutputStreamCreator {
        @Override
        public FileDownloadOutputStream create(File file) throws FileNotFoundException {
            return new FileDownloadRandomAccessFile(file);
        }

        @Override
        public boolean supportSeek() {
            return true;
        }
    }
}

