/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FileDownloadProperties {
    private static final String KEY_HTTP_LENIENT = "http.lenient";
    private static final String KEY_PROCESS_NON_SEPARATE = "process.non-separate";
    private static final String KEY_DOWNLOAD_MIN_PROGRESS_STEP = "download.min-progress-step";
    private static final String KEY_DOWNLOAD_MIN_PROGRESS_TIME = "download.min-progress-time";
    private static final String KEY_DOWNLOAD_MAX_NETWORK_THREAD_COUNT = "download.max-network-thread-count";
    private static final String KEY_FILE_NON_PRE_ALLOCATION = "file.non-pre-allocation";
    public final int DOWNLOAD_MIN_PROGRESS_STEP;
    public final long DOWNLOAD_MIN_PROGRESS_TIME;
    public final boolean HTTP_LENIENT;
    public final boolean PROCESS_NON_SEPARATE;
    public final int DOWNLOAD_MAX_NETWORK_THREAD_COUNT;
    public final boolean FILE_NON_PRE_ALLOCATION;
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";

    public static FileDownloadProperties getImpl() {
        return HolderClass.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDownloadProperties() {
        if (FileDownloadHelper.getAppContext() == null) {
            throw new IllegalStateException("Please invoke the FileDownloader#init in Application#onCreate first.");
        }
        long start = System.currentTimeMillis();
        String httpLenient = null;
        String processNonSeparate = null;
        String downloadMinProgressStep = null;
        String downloadMinProgressTime = null;
        String downloadMaxNetworkThreadCount = null;
        String fileNonPreAllocation = null;
        Properties p = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = FileDownloadHelper.getAppContext().getAssets().open("filedownloader.properties");
            if (inputStream != null) {
                p.load(inputStream);
                httpLenient = p.getProperty(KEY_HTTP_LENIENT);
                processNonSeparate = p.getProperty(KEY_PROCESS_NON_SEPARATE);
                downloadMinProgressStep = p.getProperty(KEY_DOWNLOAD_MIN_PROGRESS_STEP);
                downloadMinProgressTime = p.getProperty(KEY_DOWNLOAD_MIN_PROGRESS_TIME);
                downloadMaxNetworkThreadCount = p.getProperty(KEY_DOWNLOAD_MAX_NETWORK_THREAD_COUNT);
                fileNonPreAllocation = p.getProperty(KEY_FILE_NON_PRE_ALLOCATION);
            }
        }
        catch (IOException e) {
            if (e instanceof FileNotFoundException) {
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(FileDownloadProperties.class, "not found filedownloader.properties", new Object[0]);
                }
            } else {
                e.printStackTrace();
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (httpLenient != null) {
            if (!httpLenient.equals(TRUE_STRING) && !httpLenient.equals(FALSE_STRING)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the value of '%s' must be '%s' or '%s'", KEY_HTTP_LENIENT, TRUE_STRING, FALSE_STRING));
            }
            this.HTTP_LENIENT = httpLenient.equals(TRUE_STRING);
        } else {
            this.HTTP_LENIENT = false;
        }
        if (processNonSeparate != null) {
            if (!processNonSeparate.equals(TRUE_STRING) && !processNonSeparate.equals(FALSE_STRING)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the value of '%s' must be '%s' or '%s'", KEY_PROCESS_NON_SEPARATE, TRUE_STRING, FALSE_STRING));
            }
            this.PROCESS_NON_SEPARATE = processNonSeparate.equals(TRUE_STRING);
        } else {
            this.PROCESS_NON_SEPARATE = false;
        }
        if (downloadMinProgressStep != null) {
            int processDownloadMinProgressStep = Integer.valueOf(downloadMinProgressStep);
            this.DOWNLOAD_MIN_PROGRESS_STEP = processDownloadMinProgressStep = Math.max(0, processDownloadMinProgressStep);
        } else {
            this.DOWNLOAD_MIN_PROGRESS_STEP = 65536;
        }
        if (downloadMinProgressTime != null) {
            long processDownloadMinProgressTime = Long.valueOf(downloadMinProgressTime);
            this.DOWNLOAD_MIN_PROGRESS_TIME = processDownloadMinProgressTime = Math.max(0L, processDownloadMinProgressTime);
        } else {
            this.DOWNLOAD_MIN_PROGRESS_TIME = 2000L;
        }
        this.DOWNLOAD_MAX_NETWORK_THREAD_COUNT = downloadMaxNetworkThreadCount != null ? FileDownloadProperties.getValidNetworkThreadCount(Integer.valueOf(downloadMaxNetworkThreadCount)) : 3;
        if (fileNonPreAllocation != null) {
            if (!fileNonPreAllocation.equals(TRUE_STRING) && !fileNonPreAllocation.equals(FALSE_STRING)) {
                throw new IllegalStateException(FileDownloadUtils.formatString("the value of '%s' must be '%s' or '%s'", KEY_FILE_NON_PRE_ALLOCATION, TRUE_STRING, FALSE_STRING));
            }
            this.FILE_NON_PRE_ALLOCATION = fileNonPreAllocation.equals(TRUE_STRING);
        } else {
            this.FILE_NON_PRE_ALLOCATION = false;
        }
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.i(FileDownloadProperties.class, "init properties %d\n load properties: %s=%B; %s=%B; %s=%d; %s=%d; %s=%d", System.currentTimeMillis() - start, KEY_HTTP_LENIENT, this.HTTP_LENIENT, KEY_PROCESS_NON_SEPARATE, this.PROCESS_NON_SEPARATE, KEY_DOWNLOAD_MIN_PROGRESS_STEP, this.DOWNLOAD_MIN_PROGRESS_STEP, KEY_DOWNLOAD_MIN_PROGRESS_TIME, this.DOWNLOAD_MIN_PROGRESS_TIME, KEY_DOWNLOAD_MAX_NETWORK_THREAD_COUNT, this.DOWNLOAD_MAX_NETWORK_THREAD_COUNT);
        }
    }

    public static int getValidNetworkThreadCount(int requireCount) {
        int MAX_VALID_NETWORK_THREAD_COUNT = 12;
        int MIN_VALID_NETWORK_THREAD_COUNT = 1;
        if (requireCount > MAX_VALID_NETWORK_THREAD_COUNT) {
            FileDownloadLog.w(FileDownloadProperties.class, "require the count of network thread  is %d, what is more than the max valid count(%d), so adjust to %d auto", requireCount, MAX_VALID_NETWORK_THREAD_COUNT, MAX_VALID_NETWORK_THREAD_COUNT);
            return MAX_VALID_NETWORK_THREAD_COUNT;
        }
        if (requireCount < MIN_VALID_NETWORK_THREAD_COUNT) {
            FileDownloadLog.w(FileDownloadProperties.class, "require the count of network thread  is %d, what is less than the min valid count(%d), so adjust to %d auto", requireCount, MIN_VALID_NETWORK_THREAD_COUNT, MIN_VALID_NETWORK_THREAD_COUNT);
            return MIN_VALID_NETWORK_THREAD_COUNT;
        }
        return requireCount;
    }

    public static class HolderClass {
        private static final FileDownloadProperties INSTANCE = new FileDownloadProperties();
    }
}

