/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FileDownloadSerialQueue {
    private final BlockingQueue<BaseDownloadTask> mTasks = new LinkedBlockingQueue<BaseDownloadTask>();
    private final HandlerThread mHandlerThread = new HandlerThread("SerialDownloadManager");
    private final Handler mHandler;
    private static final int WHAT_NEXT = 1;
    private static final int ID_INVALID = 0;
    private int mWorkingTaskId = 0;

    public FileDownloadSerialQueue() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), (Handler.Callback)new SerialLoop());
        this.sendNext();
    }

    public void enqueue(BaseDownloadTask task) {
        try {
            this.mTasks.put(task);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public int getWorkingTaskId() {
        return this.mWorkingTaskId;
    }

    public List<BaseDownloadTask> shutdown() {
        if (this.mWorkingTaskId != 0) {
            FileDownloader.getImpl().pause(this.mWorkingTaskId);
        }
        ArrayList<BaseDownloadTask> unDealTaskList = new ArrayList<BaseDownloadTask>();
        this.mTasks.drainTo(unDealTaskList);
        this.mHandler.removeMessages(1);
        this.mHandlerThread.interrupt();
        this.mHandlerThread.quit();
        return unDealTaskList;
    }

    private void sendNext() {
        this.mHandler.sendEmptyMessage(1);
    }

    private static class SerialFinishCallback
    implements BaseDownloadTask.FinishListener {
        private final WeakReference<FileDownloadSerialQueue> mQueueWeakReference;

        SerialFinishCallback(WeakReference<FileDownloadSerialQueue> queueWeakReference) {
            this.mQueueWeakReference = queueWeakReference;
        }

        @Override
        public void over(BaseDownloadTask task) {
            task.removeFinishListener(this);
            if (this.mQueueWeakReference == null) {
                return;
            }
            FileDownloadSerialQueue queue = (FileDownloadSerialQueue)this.mQueueWeakReference.get();
            if (queue == null) {
                return;
            }
            queue.mWorkingTaskId = 0;
            queue.sendNext();
        }
    }

    private class SerialLoop
    implements Handler.Callback {
        private SerialLoop() {
        }

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    try {
                        FileDownloadSerialQueue.this.mWorkingTaskId = ((BaseDownloadTask)FileDownloadSerialQueue.this.mTasks.take()).addFinishListener(new SerialFinishCallback(new WeakReference<FileDownloadSerialQueue>(FileDownloadSerialQueue.this))).start();
                        break;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            return false;
        }
    }
}

