/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.util;

import android.app.ActivityManager;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import android.os.StatFs;
import android.text.TextUtils;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileDownloadUtils {
    private static int MIN_PROGRESS_STEP = 65536;
    private static long MIN_PROGRESS_TIME = 2000L;
    private static String DEFAULT_SAVE_ROOT_PATH;
    private static Boolean IS_DOWNLOADER_PROCESS;
    private static final String INTERNAL_DOCUMENT_NAME = "filedownloader";
    private static final String OLD_FILE_CONVERTED_FILE_NAME = ".old_file_converted";
    private static Boolean FILENAME_CONVERTED;
    private static final Pattern CONTENT_DISPOSITION_PATTERN;
    private static final String FILEDOWNLOADER_PREFIX = "FileDownloader";

    public static void setMinProgressStep(int minProgressStep) throws IllegalAccessException {
        if (!FileDownloadUtils.isDownloaderProcess(FileDownloadHelper.getAppContext())) {
            throw new IllegalAccessException("This value is used in the :filedownloader process, so set this value in your process is without effect. You can add 'process.non-separate=true' in 'filedownloader.properties' to share the main process to FileDownloadService. Or you can configure this value in 'filedownloader.properties' by 'download.min-progress-step'.");
        }
        MIN_PROGRESS_STEP = minProgressStep;
    }

    public static void setMinProgressTime(long minProgressTime) throws IllegalAccessException {
        if (!FileDownloadUtils.isDownloaderProcess(FileDownloadHelper.getAppContext())) {
            throw new IllegalAccessException("This value is used in the :filedownloader process, so set this value in your process is without effect. You can add 'process.non-separate=true' in 'filedownloader.properties' to share the main process to FileDownloadService. Or you can configure this value in 'filedownloader.properties' by 'download.min-progress-time'.");
        }
        MIN_PROGRESS_TIME = minProgressTime;
    }

    public static int getMinProgressStep() {
        return MIN_PROGRESS_STEP;
    }

    public static long getMinProgressTime() {
        return MIN_PROGRESS_TIME;
    }

    public static boolean isFilenameValid(String filename) {
        return true;
    }

    public static String getDefaultSaveRootPath() {
        if (!TextUtils.isEmpty((CharSequence)DEFAULT_SAVE_ROOT_PATH)) {
            return DEFAULT_SAVE_ROOT_PATH;
        }
        if (FileDownloadHelper.getAppContext().getExternalCacheDir() == null) {
            return Environment.getDownloadCacheDirectory().getAbsolutePath();
        }
        return FileDownloadHelper.getAppContext().getExternalCacheDir().getAbsolutePath();
    }

    public static String getDefaultSaveFilePath(String url) {
        return FileDownloadUtils.generateFilePath(FileDownloadUtils.getDefaultSaveRootPath(), FileDownloadUtils.generateFileName(url));
    }

    public static String generateFileName(String url) {
        return FileDownloadUtils.md5(url);
    }

    public static String generateFilePath(String directory, String filename) {
        if (filename == null) {
            throw new IllegalStateException("can't generate real path, the file name is null");
        }
        if (directory == null) {
            throw new IllegalStateException("can't generate real path, the directory is null");
        }
        return FileDownloadUtils.formatString("%s%s%s", directory, File.separator, filename);
    }

    public static void setDefaultSaveRootPath(String path) {
        DEFAULT_SAVE_ROOT_PATH = path;
    }

    public static String getTempPath(String targetPath) {
        return FileDownloadUtils.formatString("%s.temp", targetPath);
    }

    public static int generateId(String url, String path) {
        return FileDownloadUtils.generateId(url, path, false);
    }

    public static int generateId(String url, String path, boolean pathAsDirectory) {
        if (pathAsDirectory) {
            return FileDownloadUtils.md5(FileDownloadUtils.formatString("%sp%s@dir", url, path)).hashCode();
        }
        return FileDownloadUtils.md5(FileDownloadUtils.formatString("%sp%s", url, path)).hashCode();
    }

    private static String md5(String string) {
        byte[] hash;
        try {
            hash = MessageDigest.getInstance("MD5").digest(string.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Huh, MD5 should be supported?", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Huh, UTF-8 should be supported?", e);
        }
        StringBuilder hex = new StringBuilder(hash.length * 2);
        for (byte b : hash) {
            if ((b & 0xFF) < 16) {
                hex.append("0");
            }
            hex.append(Integer.toHexString(b & 0xFF));
        }
        return hex.toString();
    }

    public static String getStack() {
        return FileDownloadUtils.getStack(true);
    }

    public static String getStack(boolean printLine) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return FileDownloadUtils.getStack(stackTrace, printLine);
    }

    public static String getStack(StackTraceElement[] stackTrace, boolean printLine) {
        if (stackTrace == null || stackTrace.length < 4) {
            return "";
        }
        StringBuilder t = new StringBuilder();
        for (int i = 3; i < stackTrace.length; ++i) {
            if (!stackTrace[i].getClassName().contains("com.liulishuo.filedownloader")) continue;
            t.append("[");
            t.append(stackTrace[i].getClassName().substring("com.liulishuo.filedownloader".length()));
            t.append(":");
            t.append(stackTrace[i].getMethodName());
            if (printLine) {
                t.append("(").append(stackTrace[i].getLineNumber()).append(")]");
                continue;
            }
            t.append("]");
        }
        return t.toString();
    }

    public static boolean isDownloaderProcess(Context context) {
        if (IS_DOWNLOADER_PROCESS != null) {
            return IS_DOWNLOADER_PROCESS;
        }
        boolean result = false;
        if (FileDownloadProperties.getImpl().PROCESS_NON_SEPARATE) {
            result = true;
        } else {
            int pid = Process.myPid();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List runningAppProcessInfoList = activityManager.getRunningAppProcesses();
            if (null == runningAppProcessInfoList || runningAppProcessInfoList.isEmpty()) {
                FileDownloadLog.w(FileDownloadUtils.class, "The running app process info list from ActivityManager is null or empty, maybe current App is not running.", new Object[0]);
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : runningAppProcessInfoList) {
                if (runningAppProcessInfo.pid != pid) continue;
                result = runningAppProcessInfo.processName.endsWith(":filedownloader");
                break;
            }
        }
        IS_DOWNLOADER_PROCESS = result;
        return IS_DOWNLOADER_PROCESS;
    }

    public static String[] convertHeaderString(String nameAndValuesString) {
        String[] lineString = nameAndValuesString.split("\n");
        String[] namesAndValues = new String[lineString.length * 2];
        for (int i = 0; i < lineString.length; ++i) {
            String[] nameAndValue = lineString[i].split(": ");
            namesAndValues[i * 2] = nameAndValue[0];
            namesAndValues[i * 2 + 1] = nameAndValue[1];
        }
        return namesAndValues;
    }

    public static long getFreeSpaceBytes(String path) {
        StatFs statFs = new StatFs(path);
        long freeSpaceBytes = Build.VERSION.SDK_INT >= 18 ? statFs.getAvailableBytes() : (long)statFs.getAvailableBlocks() * (long)statFs.getBlockSize();
        return freeSpaceBytes;
    }

    public static String formatString(String msg, Object ... args) {
        return String.format(Locale.ENGLISH, msg, args);
    }

    public static void markConverted(Context context) {
        File file = FileDownloadUtils.getConvertedMarkedFile(context);
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean isFilenameConverted(Context context) {
        if (FILENAME_CONVERTED == null) {
            FILENAME_CONVERTED = FileDownloadUtils.getConvertedMarkedFile(context).exists();
        }
        return FILENAME_CONVERTED;
    }

    public static File getConvertedMarkedFile(Context context) {
        return new File(context.getFilesDir().getAbsolutePath() + File.separator + INTERNAL_DOCUMENT_NAME, OLD_FILE_CONVERTED_FILE_NAME);
    }

    public static String parseContentDisposition(String contentDisposition) {
        if (contentDisposition == null) {
            return null;
        }
        try {
            Matcher m = CONTENT_DISPOSITION_PATTERN.matcher(contentDisposition);
            if (m.find()) {
                return m.group(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return null;
    }

    public static String getTargetFilePath(String path, boolean pathAsDirectory, String filename) {
        if (path == null) {
            return null;
        }
        if (pathAsDirectory) {
            if (filename == null) {
                return null;
            }
            return FileDownloadUtils.generateFilePath(path, filename);
        }
        return path;
    }

    public static String getParent(String path) {
        int index;
        int length = path.length();
        int firstInPath = 0;
        if (File.separatorChar == '\\' && length > 2 && path.charAt(1) == ':') {
            firstInPath = 2;
        }
        if ((index = path.lastIndexOf(File.separatorChar)) == -1 && firstInPath > 0) {
            index = 2;
        }
        if (index == -1 || path.charAt(length - 1) == File.separatorChar) {
            return null;
        }
        if (path.indexOf(File.separatorChar) == index && path.charAt(firstInPath) == File.separatorChar) {
            return path.substring(0, index + 1);
        }
        return path.substring(0, index);
    }

    public static String getThreadPoolName(String name) {
        return "FileDownloader-" + name;
    }

    public static boolean isNetworkOnWifiType() {
        ConnectivityManager manager = (ConnectivityManager)FileDownloadHelper.getAppContext().getSystemService("connectivity");
        NetworkInfo info = manager.getActiveNetworkInfo();
        return info != null && info.getType() == 1;
    }

    public static boolean checkPermission(String permission2) {
        int perm = FileDownloadHelper.getAppContext().checkCallingOrSelfPermission(permission2);
        return perm == 0;
    }

    public static long convertContentLengthString(String s) {
        if (s == null) {
            return -1L;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    static {
        FILENAME_CONVERTED = null;
        CONTENT_DISPOSITION_PATTERN = Pattern.compile("attachment;\\s*filename\\s*=\\s*\"([^\"]*)\"");
    }
}

