/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.FileDownloadConnectListener;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.FileDownloadServiceProxy;
import com.liulishuo.filedownloader.FileDownloader;
import com.liulishuo.filedownloader.ILostServiceConnectedHandler;
import com.liulishuo.filedownloader.IQueuesHandler;
import com.liulishuo.filedownloader.event.DownloadServiceConnectChangedEvent;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.util.ArrayList;
import java.util.List;

public class LostServiceConnectedHandler
extends FileDownloadConnectListener
implements ILostServiceConnectedHandler {
    private final ArrayList<BaseDownloadTask.IRunningTask> mWaitingList = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connected() {
        IQueuesHandler queueHandler = FileDownloader.getImpl().getQueuesHandler();
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "The downloader service is connected.", new Object[0]);
        }
        ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mWaitingList;
        synchronized (arrayList) {
            List copyWaitingList = (List)this.mWaitingList.clone();
            this.mWaitingList.clear();
            ArrayList<Integer> wakeupSerialQueueKeyList = new ArrayList<Integer>(queueHandler.serialQueueSize());
            for (BaseDownloadTask.IRunningTask task : copyWaitingList) {
                int attachKey = task.getAttachKey();
                if (queueHandler.contain(attachKey)) {
                    task.getOrigin().asInQueueTask().enqueue();
                    if (wakeupSerialQueueKeyList.contains(attachKey)) continue;
                    wakeupSerialQueueKeyList.add(attachKey);
                    continue;
                }
                task.startTaskByRescue();
            }
            queueHandler.unFreezeSerialQueues(wakeupSerialQueueKeyList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnected() {
        if (this.getConnectStatus() == DownloadServiceConnectChangedEvent.ConnectStatus.lost) {
            IQueuesHandler queueHandler = FileDownloader.getImpl().getQueuesHandler();
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "lost the connection to the file download service, and current active task size is %d", FileDownloadList.getImpl().size());
            }
            if (FileDownloadList.getImpl().size() > 0) {
                ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mWaitingList;
                synchronized (arrayList) {
                    FileDownloadList.getImpl().divertAndIgnoreDuplicate(this.mWaitingList);
                    for (BaseDownloadTask.IRunningTask task : this.mWaitingList) {
                        task.free();
                    }
                    queueHandler.freezeAllSerialQueues();
                }
                FileDownloader.getImpl().bindService();
            }
        } else if (FileDownloadList.getImpl().size() > 0) {
            FileDownloadLog.w(this, "file download service has be unbound but the size of active tasks are not empty %d ", FileDownloadList.getImpl().size());
        }
    }

    @Override
    public boolean isInWaitingList(BaseDownloadTask.IRunningTask task) {
        return !this.mWaitingList.isEmpty() && this.mWaitingList.contains(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskWorkFine(BaseDownloadTask.IRunningTask task) {
        if (!this.mWaitingList.isEmpty()) {
            ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mWaitingList;
            synchronized (arrayList) {
                this.mWaitingList.remove(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dispatchTaskStart(BaseDownloadTask.IRunningTask task) {
        if (!FileDownloader.getImpl().isServiceConnected()) {
            ArrayList<BaseDownloadTask.IRunningTask> arrayList = this.mWaitingList;
            synchronized (arrayList) {
                if (!FileDownloader.getImpl().isServiceConnected()) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(this, "Waiting for connecting with the downloader service... %d", task.getOrigin().getId());
                    }
                    FileDownloadServiceProxy.getImpl().bindStartByContext(FileDownloadHelper.getAppContext());
                    if (!this.mWaitingList.contains(task)) {
                        task.free();
                        this.mWaitingList.add(task);
                    }
                    return true;
                }
            }
        }
        this.taskWorkFine(task);
        return false;
    }
}

