/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import android.os.Process;
import com.liulishuo.filedownloader.IThreadPoolMonitor;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.ConnectTask;
import com.liulishuo.filedownloader.download.ConnectionProfile;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.download.DownloadRunnable;
import com.liulishuo.filedownloader.download.DownloadStatusCallback;
import com.liulishuo.filedownloader.download.ProcessCallback;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.exception.FileDownloadHttpException;
import com.liulishuo.filedownloader.exception.FileDownloadNetworkPolicyException;
import com.liulishuo.filedownloader.exception.FileDownloadOutOfSpaceException;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.stream.FileDownloadOutputStream;
import com.liulishuo.filedownloader.util.FileDownloadExecutors;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadProperties;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;

public class DownloadLaunchRunnable
implements Runnable,
ProcessCallback {
    private final DownloadStatusCallback statusCallback;
    private final int defaultConnectionCount = 5;
    private final FileDownloadModel model;
    private final FileDownloadHeader userRequestHeader;
    private final boolean isForceReDownload;
    private final boolean isWifiRequired;
    private final FileDownloadDatabase database;
    private final IThreadPoolMonitor threadPoolMonitor;
    private boolean isTriedFixRangeNotSatisfiable = false;
    int validRetryTimes;
    private static final int HTTP_REQUESTED_RANGE_NOT_SATISFIABLE = 416;
    private static final int TOTAL_VALUE_IN_CHUNKED_RESOURCE = -1;
    private boolean isNeedForceDiscardRange = false;
    private final boolean supportSeek;
    private final ArrayList<DownloadRunnable> downloadRunnableList = new ArrayList(5);
    private DownloadRunnable singleDownloadRunnable;
    private boolean isSingleConnection;
    private static final ThreadPoolExecutor DOWNLOAD_EXECUTOR = FileDownloadExecutors.newFixedThreadPool("ConnectionBlock");
    private boolean isResumeAvailableOnDB;
    private boolean acceptPartial;
    private boolean isChunked;
    private final AtomicBoolean alive = new AtomicBoolean(true);
    private volatile boolean paused = false;
    private volatile boolean error;
    private volatile Exception errorException;
    private String redirectedUrl;
    private long lastCallbackBytes = 0L;
    private long lastCallbackTimestamp = 0L;
    private long lastUpdateBytes = 0L;
    private long lastUpdateTimestamp = 0L;

    private DownloadLaunchRunnable(FileDownloadModel model, FileDownloadHeader header, IThreadPoolMonitor threadPoolMonitor, int minIntervalMillis, int callbackProgressMaxCount, boolean isForceReDownload, boolean isWifiRequired, int maxRetryTimes) {
        this.model = model;
        this.userRequestHeader = header;
        this.isForceReDownload = isForceReDownload;
        this.isWifiRequired = isWifiRequired;
        this.database = CustomComponentHolder.getImpl().getDatabaseInstance();
        this.supportSeek = CustomComponentHolder.getImpl().isSupportSeek();
        this.threadPoolMonitor = threadPoolMonitor;
        this.validRetryTimes = maxRetryTimes;
        this.statusCallback = new DownloadStatusCallback(model, maxRetryTimes, minIntervalMillis, callbackProgressMaxCount);
    }

    private DownloadLaunchRunnable(DownloadStatusCallback callback, FileDownloadModel model, FileDownloadHeader header, IThreadPoolMonitor threadPoolMonitor, int minIntervalMillis, int callbackProgressMaxCount, boolean isForceReDownload, boolean isWifiRequired, int maxRetryTimes) {
        this.model = model;
        this.userRequestHeader = header;
        this.isForceReDownload = isForceReDownload;
        this.isWifiRequired = isWifiRequired;
        this.database = CustomComponentHolder.getImpl().getDatabaseInstance();
        this.supportSeek = CustomComponentHolder.getImpl().isSupportSeek();
        this.threadPoolMonitor = threadPoolMonitor;
        this.validRetryTimes = maxRetryTimes;
        this.statusCallback = callback;
    }

    static DownloadLaunchRunnable createForTest(DownloadStatusCallback callback, FileDownloadModel model, FileDownloadHeader header, IThreadPoolMonitor threadPoolMonitor, int minIntervalMillis, int callbackProgressMaxCount, boolean isForceReDownload, boolean isWifiRequired, int maxRetryTimes) {
        return new DownloadLaunchRunnable(callback, model, header, threadPoolMonitor, minIntervalMillis, callbackProgressMaxCount, isForceReDownload, isWifiRequired, maxRetryTimes);
    }

    public void pause() {
        this.paused = true;
        if (this.singleDownloadRunnable != null) {
            this.singleDownloadRunnable.pause();
        }
        ArrayList pauseList = (ArrayList)this.downloadRunnableList.clone();
        for (DownloadRunnable runnable : pauseList) {
            if (runnable == null) continue;
            runnable.pause();
        }
    }

    public void pending() {
        List<ConnectionModel> connectionOnDBList = this.database.findConnectionModel(this.model.getId());
        this.inspectTaskModelResumeAvailableOnDB(connectionOnDBList);
        this.statusCallback.onPending();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Process.setThreadPriority((int)10);
            if (this.model.getStatus() != 1) {
                if (this.model.getStatus() == -2) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(this, "High concurrent cause, start runnable but already paused %d", this.model.getId());
                    }
                } else {
                    this.onError(new RuntimeException(FileDownloadUtils.formatString("Task[%d] can't start the download runnable, because its status is %d not %d", this.model.getId(), this.model.getStatus(), (byte)1)));
                }
                return;
            }
            if (!this.paused) {
                this.statusCallback.onStartThread();
            }
            while (true) {
                if (this.paused) {
                    if (FileDownloadLog.NEED_LOG) {
                        FileDownloadLog.d(this, "High concurrent cause, start runnable but already paused %d", this.model.getId());
                    }
                    return;
                }
                this.checkupBeforeConnect();
                this.trialConnect();
                this.checkupAfterGetFilename();
                List<ConnectionModel> connectionOnDBList = this.database.findConnectionModel(this.model.getId());
                this.inspectTaskModelResumeAvailableOnDB(connectionOnDBList);
                if (this.paused) {
                    this.model.setStatus((byte)-2);
                    return;
                }
                long totalLength = this.model.getTotal();
                this.handlePreAllocate(totalLength, this.model.getTempFilePath());
                int connectionCount = this.calcConnectionCount(totalLength);
                if (connectionCount <= 0) {
                    throw new IllegalAccessException(FileDownloadUtils.formatString("invalid connection count %d, the connection count must be larger than 0", connectionCount));
                }
                if (totalLength == 0L) {
                    return;
                }
                if (this.paused) {
                    this.model.setStatus((byte)-2);
                    return;
                }
                try {
                    boolean bl = this.isSingleConnection = connectionCount == 1;
                    if (this.isSingleConnection) {
                        this.realDownloadWithSingleConnection(totalLength);
                    } else {
                        this.statusCallback.onMultiConnection();
                        if (this.isResumeAvailableOnDB) {
                            this.realDownloadWithMultiConnectionFromResume(connectionCount, connectionOnDBList);
                        } else {
                            this.realDownloadWithMultiConnectionFromBeginning(totalLength, connectionCount);
                        }
                    }
                }
                catch (FileDownloadGiveUpRetryException | IOException | IllegalAccessException | IllegalArgumentException | InterruptedException e) {
                    if (this.isRetry(e)) {
                        this.onRetry(e);
                        continue;
                    }
                    this.onError(e);
                }
                catch (DiscardSafely discardSafely) {
                    this.statusCallback.discardAllMessage();
                    if (this.paused) {
                        this.statusCallback.onPausedDirectly();
                    } else if (this.error) {
                        this.statusCallback.onErrorDirectly(this.errorException);
                    } else {
                        try {
                            this.statusCallback.onCompletedDirectly();
                        }
                        catch (IOException e) {
                            this.statusCallback.onErrorDirectly(e);
                        }
                    }
                    this.alive.set(false);
                    return;
                }
                catch (RetryDirectly retryDirectly) {
                    this.model.setStatus((byte)5);
                    continue;
                }
                break;
            }
        }
        finally {
            this.statusCallback.discardAllMessage();
            if (this.paused) {
                this.statusCallback.onPausedDirectly();
            } else if (this.error) {
                this.statusCallback.onErrorDirectly(this.errorException);
            } else {
                try {
                    this.statusCallback.onCompletedDirectly();
                }
                catch (IOException e) {
                    this.statusCallback.onErrorDirectly(e);
                }
            }
            this.alive.set(false);
        }
    }

    private int calcConnectionCount(long totalLength) {
        if (this.isMultiConnectionAvailable()) {
            if (this.isResumeAvailableOnDB) {
                return this.model.getConnectionCount();
            }
            return CustomComponentHolder.getImpl().determineConnectionCount(this.model.getId(), this.model.getUrl(), this.model.getPath(), totalLength);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trialConnect() throws IOException, RetryDirectly, IllegalAccessException {
        FileDownloadConnection trialConnection = null;
        try {
            ConnectionProfile trialConnectionProfile = this.isNeedForceDiscardRange ? ConnectionProfile.ConnectionProfileBuild.buildTrialConnectionProfileNoRange() : ConnectionProfile.ConnectionProfileBuild.buildTrialConnectionProfile();
            ConnectTask trialConnectTask = new ConnectTask.Builder().setDownloadId(this.model.getId()).setUrl(this.model.getUrl()).setEtag(this.model.getETag()).setHeader(this.userRequestHeader).setConnectionProfile(trialConnectionProfile).build();
            trialConnection = trialConnectTask.connect();
            this.handleTrialConnectResult(trialConnectTask.getRequestHeader(), trialConnectTask, trialConnection);
        }
        finally {
            if (trialConnection != null) {
                trialConnection.ending();
            }
        }
    }

    private boolean isMultiConnectionAvailable() {
        if (this.isResumeAvailableOnDB && this.model.getConnectionCount() <= 1) {
            return false;
        }
        return this.acceptPartial && this.supportSeek && !this.isChunked;
    }

    private int determineConnectionCount() {
        return 5;
    }

    void inspectTaskModelResumeAvailableOnDB(List<ConnectionModel> connectionOnDBList) {
        boolean resumeAvailable;
        boolean isMultiConnection;
        int connectionCount = this.model.getConnectionCount();
        String tempFilePath = this.model.getTempFilePath();
        String targetFilePath = this.model.getTargetFilePath();
        boolean bl = isMultiConnection = connectionCount > 1;
        long offset = this.isNeedForceDiscardRange ? 0L : (isMultiConnection && !this.supportSeek ? 0L : ((resumeAvailable = FileDownloadUtils.isBreakpointAvailable(this.model.getId(), this.model)) ? (!this.supportSeek ? new File(tempFilePath).length() : (isMultiConnection ? (connectionCount != connectionOnDBList.size() ? 0L : ConnectionModel.getTotalOffset(connectionOnDBList)) : this.model.getSoFar())) : 0L));
        this.model.setSoFar(offset);
        boolean bl2 = this.isResumeAvailableOnDB = offset > 0L;
        if (!this.isResumeAvailableOnDB) {
            this.database.removeConnections(this.model.getId());
            FileDownloadUtils.deleteTaskFiles(targetFilePath, tempFilePath);
        }
    }

    private void handleTrialConnectResult(Map<String, List<String>> requestHeader, ConnectTask connectTask, FileDownloadConnection connection) throws IOException, RetryDirectly, IllegalArgumentException {
        String fileName;
        long totalLength;
        int id = this.model.getId();
        int code = connection.getResponseCode();
        this.acceptPartial = FileDownloadUtils.isAcceptRange(code, connection);
        boolean onlyFromBeginning = code == 200 || code == 201 || code == 0;
        String oldEtag = this.model.getETag();
        String newEtag = FileDownloadUtils.findEtag(id, connection);
        boolean isPreconditionFailed = false;
        if (code == 412) {
            isPreconditionFailed = true;
        } else if (oldEtag != null && !oldEtag.equals(newEtag) && (onlyFromBeginning || this.acceptPartial)) {
            isPreconditionFailed = true;
        } else if (code == 201 && connectTask.isRangeNotFromBeginning()) {
            isPreconditionFailed = true;
        } else if (code == 416) {
            if (this.model.getSoFar() > 0L) {
                isPreconditionFailed = true;
            } else if (!this.isNeedForceDiscardRange) {
                this.isNeedForceDiscardRange = true;
                isPreconditionFailed = true;
            }
        }
        if (isPreconditionFailed) {
            if (this.isResumeAvailableOnDB) {
                FileDownloadLog.w(this, "there is precondition failed on this request[%d] with old etag[%s]\u3001new etag[%s]\u3001response code is %d", id, oldEtag, newEtag, code);
            }
            this.database.removeConnections(this.model.getId());
            FileDownloadUtils.deleteTaskFiles(this.model.getTargetFilePath(), this.model.getTempFilePath());
            this.isResumeAvailableOnDB = false;
            if (oldEtag != null && oldEtag.equals(newEtag)) {
                FileDownloadLog.w(this, "the old etag[%s] is the same to the new etag[%s], but the response status code is %d not Partial(206), so wo have to start this task from very beginning for task[%d]!", oldEtag, newEtag, code, id);
                newEtag = null;
            }
            this.model.setSoFar(0L);
            this.model.setTotal(0L);
            this.model.setETag(newEtag);
            this.model.resetConnectionCount();
            this.database.updateOldEtagOverdue(id, this.model.getETag(), this.model.getSoFar(), this.model.getTotal(), this.model.getConnectionCount());
            throw new RetryDirectly();
        }
        this.redirectedUrl = connectTask.getFinalRedirectedUrl();
        if (this.acceptPartial || onlyFromBeginning) {
            totalLength = FileDownloadUtils.findInstanceLengthForTrial(connection);
            fileName = null;
            if (this.model.isPathAsDirectory()) {
                fileName = FileDownloadUtils.findFilename(connection, this.model.getUrl());
            }
        } else {
            throw new FileDownloadHttpException(code, requestHeader, connection.getResponseHeaderFields());
        }
        this.isChunked = totalLength == -1L;
        this.statusCallback.onConnected(this.isResumeAvailableOnDB && this.acceptPartial, totalLength, newEtag, fileName);
    }

    private void realDownloadWithSingleConnection(long totalLength) throws IOException, IllegalAccessException {
        ConnectionProfile profile;
        if (!this.acceptPartial) {
            this.model.setSoFar(0L);
            profile = ConnectionProfile.ConnectionProfileBuild.buildBeginToEndConnectionProfile(totalLength);
        } else {
            profile = ConnectionProfile.ConnectionProfileBuild.buildToEndConnectionProfile(this.model.getSoFar(), this.model.getSoFar(), totalLength - this.model.getSoFar());
        }
        this.singleDownloadRunnable = new DownloadRunnable.Builder().setId(this.model.getId()).setConnectionIndex(-1).setCallback(this).setUrl(this.model.getUrl()).setEtag(this.model.getETag()).setHeader(this.userRequestHeader).setWifiRequired(this.isWifiRequired).setConnectionModel(profile).setPath(this.model.getTempFilePath()).build();
        this.model.setConnectionCount(1);
        this.database.updateConnectionCount(this.model.getId(), 1);
        if (this.paused) {
            this.model.setStatus((byte)-2);
            this.singleDownloadRunnable.pause();
        } else {
            this.singleDownloadRunnable.run();
        }
    }

    private void realDownloadWithMultiConnectionFromResume(int connectionCount, List<ConnectionModel> modelList) throws InterruptedException {
        if (connectionCount <= 1 || modelList.size() != connectionCount) {
            throw new IllegalArgumentException();
        }
        this.fetchWithMultipleConnection(modelList, this.model.getTotal());
    }

    private void realDownloadWithMultiConnectionFromBeginning(long totalLength, int connectionCount) throws InterruptedException {
        long startOffset = 0L;
        long eachRegion = totalLength / (long)connectionCount;
        int id = this.model.getId();
        ArrayList<ConnectionModel> connectionModelList = new ArrayList<ConnectionModel>();
        for (int i = 0; i < connectionCount; ++i) {
            long endOffset = i == connectionCount - 1 ? -1L : startOffset + eachRegion - 1L;
            ConnectionModel connectionModel = new ConnectionModel();
            connectionModel.setId(id);
            connectionModel.setIndex(i);
            connectionModel.setStartOffset(startOffset);
            connectionModel.setCurrentOffset(startOffset);
            connectionModel.setEndOffset(endOffset);
            connectionModelList.add(connectionModel);
            this.database.insertConnectionModel(connectionModel);
            startOffset += eachRegion;
        }
        this.model.setConnectionCount(connectionCount);
        this.database.updateConnectionCount(id, connectionCount);
        this.fetchWithMultipleConnection(connectionModelList, totalLength);
    }

    private void fetchWithMultipleConnection(List<ConnectionModel> connectionModelList, long totalLength) throws InterruptedException {
        int id = this.model.getId();
        String etag = this.model.getETag();
        String url = this.redirectedUrl != null ? this.redirectedUrl : this.model.getUrl();
        String path = this.model.getTempFilePath();
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "fetch data with multiple connection(count: [%d]) for task[%d] totalLength[%d]", connectionModelList.size(), id, totalLength);
        }
        long totalOffset = 0L;
        boolean withEtag = this.isResumeAvailableOnDB;
        for (ConnectionModel connectionModel : connectionModelList) {
            long contentLength = connectionModel.getEndOffset() == -1L ? totalLength - connectionModel.getCurrentOffset() : connectionModel.getEndOffset() - connectionModel.getCurrentOffset() + 1L;
            totalOffset += connectionModel.getCurrentOffset() - connectionModel.getStartOffset();
            if (contentLength == 0L) {
                if (!FileDownloadLog.NEED_LOG) continue;
                FileDownloadLog.d(this, "pass connection[%d-%d], because it has been completed", connectionModel.getId(), connectionModel.getIndex());
                continue;
            }
            DownloadRunnable.Builder builder = new DownloadRunnable.Builder();
            ConnectionProfile connectionProfile = ConnectionProfile.ConnectionProfileBuild.buildConnectionProfile(connectionModel.getStartOffset(), connectionModel.getCurrentOffset(), connectionModel.getEndOffset(), contentLength);
            DownloadRunnable runnable = builder.setId(id).setConnectionIndex(connectionModel.getIndex()).setCallback(this).setUrl(url).setEtag(withEtag ? etag : null).setHeader(this.userRequestHeader).setWifiRequired(this.isWifiRequired).setConnectionModel(connectionProfile).setPath(path).build();
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "enable multiple connection: %s", connectionModel);
            }
            if (runnable == null) {
                throw new IllegalArgumentException("the download runnable must not be null!");
            }
            this.downloadRunnableList.add(runnable);
        }
        if (totalOffset != this.model.getSoFar()) {
            FileDownloadLog.w(this, "correct the sofar[%d] from connection table[%d]", this.model.getSoFar(), totalOffset);
            this.model.setSoFar(totalOffset);
        }
        ArrayList<Callable<Object>> subTasks = new ArrayList<Callable<Object>>(this.downloadRunnableList.size());
        for (DownloadRunnable runnable : this.downloadRunnableList) {
            if (this.paused) {
                runnable.pause();
                continue;
            }
            subTasks.add(Executors.callable(runnable));
        }
        if (this.paused) {
            this.model.setStatus((byte)-2);
            return;
        }
        List list = DOWNLOAD_EXECUTOR.invokeAll(subTasks);
        if (FileDownloadLog.NEED_LOG) {
            for (Future future : list) {
                FileDownloadLog.d(this, "finish sub-task for [%d] %B %B", id, future.isDone(), future.isCancelled());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePreAllocate(long totalLength, String path) throws IOException, IllegalAccessException {
        try (FileDownloadOutputStream outputStream = null;){
            if (totalLength != -1L) {
                outputStream = FileDownloadUtils.createOutputStream(this.model.getTempFilePath());
                long breakpointBytes = new File(path).length();
                long requiredSpaceBytes = totalLength - breakpointBytes;
                long freeSpaceBytes = FileDownloadUtils.getFreeSpaceBytes(path);
                if (freeSpaceBytes < requiredSpaceBytes) {
                    throw new FileDownloadOutOfSpaceException(freeSpaceBytes, requiredSpaceBytes, breakpointBytes);
                }
                if (!FileDownloadProperties.getImpl().fileNonPreAllocation) {
                    outputStream.setLength(totalLength);
                }
            }
        }
    }

    @Override
    public void onProgress(long increaseBytes) {
        if (this.paused) {
            return;
        }
        this.statusCallback.onProgress(increaseBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted(DownloadRunnable doneRunnable, long startOffset, long endOffset) {
        if (this.paused) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "the task[%d] has already been paused, so pass the completed callback", this.model.getId());
            }
            return;
        }
        int doneConnectionIndex = doneRunnable.connectionIndex;
        if (FileDownloadLog.NEED_LOG) {
            FileDownloadLog.d(this, "the connection has been completed(%d): [%d, %d)  %d", doneConnectionIndex, startOffset, endOffset, this.model.getTotal());
        }
        if (this.isSingleConnection) {
            if (startOffset != 0L && endOffset != this.model.getTotal()) {
                FileDownloadLog.e((Object)this, "the single task not completed corrected(%d, %d != %d) for task(%d)", startOffset, endOffset, this.model.getTotal(), this.model.getId());
            }
        } else {
            ArrayList<DownloadRunnable> arrayList = this.downloadRunnableList;
            synchronized (arrayList) {
                this.downloadRunnableList.remove(doneRunnable);
            }
        }
    }

    @Override
    public boolean isRetry(Exception exception) {
        if (exception instanceof FileDownloadHttpException) {
            FileDownloadHttpException httpException = (FileDownloadHttpException)exception;
            int code = httpException.getCode();
            if (this.isSingleConnection && code == 416 && !this.isTriedFixRangeNotSatisfiable) {
                FileDownloadUtils.deleteTaskFiles(this.model.getTargetFilePath(), this.model.getTempFilePath());
                this.isTriedFixRangeNotSatisfiable = true;
                return true;
            }
        }
        return this.validRetryTimes > 0 && !(exception instanceof FileDownloadGiveUpRetryException);
    }

    @Override
    public void onError(Exception exception) {
        this.error = true;
        this.errorException = exception;
        if (this.paused) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "the task[%d] has already been paused, so pass the error callback", this.model.getId());
            }
            return;
        }
        ArrayList discardList = (ArrayList)this.downloadRunnableList.clone();
        for (DownloadRunnable runnable : discardList) {
            if (runnable == null) continue;
            runnable.discard();
        }
    }

    @Override
    public void onRetry(Exception exception) {
        if (this.paused) {
            if (FileDownloadLog.NEED_LOG) {
                FileDownloadLog.d(this, "the task[%d] has already been paused, so pass the retry callback", this.model.getId());
            }
            return;
        }
        if (this.validRetryTimes-- < 0) {
            FileDownloadLog.e((Object)this, "valid retry times is less than 0(%d) for download task(%d)", this.validRetryTimes, this.model.getId());
        }
        this.statusCallback.onRetry(exception, this.validRetryTimes);
    }

    @Override
    public void syncProgressFromCache() {
        this.database.updateProgress(this.model.getId(), this.model.getSoFar());
    }

    private void checkupBeforeConnect() throws FileDownloadGiveUpRetryException {
        if (this.isWifiRequired && !FileDownloadUtils.checkPermission("android.permission.ACCESS_NETWORK_STATE")) {
            throw new FileDownloadGiveUpRetryException(FileDownloadUtils.formatString("Task[%d] can't start the download runnable, because this task require wifi, but user application nor current process has %s, so we can't check whether the network type connection.", this.model.getId(), "android.permission.ACCESS_NETWORK_STATE"));
        }
        if (this.isWifiRequired && FileDownloadUtils.isNetworkNotOnWifiType()) {
            throw new FileDownloadNetworkPolicyException();
        }
    }

    private void checkupAfterGetFilename() throws RetryDirectly, DiscardSafely {
        int id = this.model.getId();
        if (this.model.isPathAsDirectory()) {
            String targetFilePath = this.model.getTargetFilePath();
            int fileCaseId = FileDownloadUtils.generateId(this.model.getUrl(), targetFilePath);
            if (FileDownloadHelper.inspectAndInflowDownloaded(id, targetFilePath, this.isForceReDownload, false)) {
                this.database.remove(id);
                this.database.removeConnections(id);
                throw new DiscardSafely();
            }
            FileDownloadModel fileCaseModel = this.database.find(fileCaseId);
            if (fileCaseModel != null) {
                if (FileDownloadHelper.inspectAndInflowDownloading(id, fileCaseModel, this.threadPoolMonitor, false)) {
                    this.database.remove(id);
                    this.database.removeConnections(id);
                    throw new DiscardSafely();
                }
                List<ConnectionModel> connectionModelList = this.database.findConnectionModel(fileCaseId);
                this.database.remove(fileCaseId);
                this.database.removeConnections(fileCaseId);
                FileDownloadUtils.deleteTargetFile(this.model.getTargetFilePath());
                if (FileDownloadUtils.isBreakpointAvailable(fileCaseId, fileCaseModel)) {
                    this.model.setSoFar(fileCaseModel.getSoFar());
                    this.model.setTotal(fileCaseModel.getTotal());
                    this.model.setETag(fileCaseModel.getETag());
                    this.model.setConnectionCount(fileCaseModel.getConnectionCount());
                    this.database.update(this.model);
                    if (connectionModelList != null) {
                        for (ConnectionModel connectionModel : connectionModelList) {
                            connectionModel.setId(id);
                            this.database.insertConnectionModel(connectionModel);
                        }
                    }
                    throw new RetryDirectly();
                }
            }
            if (FileDownloadHelper.inspectAndInflowConflictPath(id, this.model.getSoFar(), this.model.getTempFilePath(), targetFilePath, this.threadPoolMonitor)) {
                this.database.remove(id);
                this.database.removeConnections(id);
                throw new DiscardSafely();
            }
        }
    }

    public int getId() {
        return this.model.getId();
    }

    public boolean isAlive() {
        return this.alive.get() || this.statusCallback.isAlive();
    }

    public String getTempFilePath() {
        return this.model.getTempFilePath();
    }

    public static class Builder {
        private FileDownloadModel model;
        private FileDownloadHeader header;
        private IThreadPoolMonitor threadPoolMonitor;
        private Integer minIntervalMillis;
        private Integer callbackProgressMaxCount;
        private Boolean isForceReDownload;
        private Boolean isWifiRequired;
        private Integer maxRetryTimes;

        public Builder setModel(FileDownloadModel model) {
            this.model = model;
            return this;
        }

        public Builder setHeader(FileDownloadHeader header) {
            this.header = header;
            return this;
        }

        public Builder setThreadPoolMonitor(IThreadPoolMonitor threadPoolMonitor) {
            this.threadPoolMonitor = threadPoolMonitor;
            return this;
        }

        public Builder setMinIntervalMillis(Integer minIntervalMillis) {
            this.minIntervalMillis = minIntervalMillis;
            return this;
        }

        public Builder setCallbackProgressMaxCount(Integer callbackProgressMaxCount) {
            this.callbackProgressMaxCount = callbackProgressMaxCount;
            return this;
        }

        public Builder setForceReDownload(Boolean forceReDownload) {
            this.isForceReDownload = forceReDownload;
            return this;
        }

        public Builder setWifiRequired(Boolean wifiRequired) {
            this.isWifiRequired = wifiRequired;
            return this;
        }

        public Builder setMaxRetryTimes(Integer maxRetryTimes) {
            this.maxRetryTimes = maxRetryTimes;
            return this;
        }

        public DownloadLaunchRunnable build() {
            if (this.model == null || this.threadPoolMonitor == null || this.minIntervalMillis == null || this.callbackProgressMaxCount == null || this.isForceReDownload == null || this.isWifiRequired == null || this.maxRetryTimes == null) {
                throw new IllegalArgumentException();
            }
            return new DownloadLaunchRunnable(this.model, this.header, this.threadPoolMonitor, this.minIntervalMillis, (int)this.callbackProgressMaxCount, this.isForceReDownload, (boolean)this.isWifiRequired, this.maxRetryTimes);
        }
    }

    class DiscardSafely
    extends Throwable {
        DiscardSafely() {
        }
    }

    class RetryDirectly
    extends Throwable {
        RetryDirectly() {
        }
    }
}

