/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.download;

import android.os.Process;
import com.liulishuo.filedownloader.connection.FileDownloadConnection;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.download.ConnectTask;
import com.liulishuo.filedownloader.download.ConnectionProfile;
import com.liulishuo.filedownloader.download.CustomComponentHolder;
import com.liulishuo.filedownloader.download.FetchDataTask;
import com.liulishuo.filedownloader.download.ProcessCallback;
import com.liulishuo.filedownloader.exception.FileDownloadGiveUpRetryException;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadHeader;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import java.io.IOException;
import java.net.SocketException;
import java.util.List;

public class DownloadRunnable
implements Runnable {
    private final ConnectTask connectTask;
    private final ProcessCallback callback;
    private final String path;
    private final boolean isWifiRequired;
    private FetchDataTask fetchDataTask;
    private volatile boolean paused;
    private final int downloadId;
    final int connectionIndex;

    private DownloadRunnable(int id, int connectionIndex, ConnectTask connectTask, ProcessCallback callback, boolean isWifiRequired, String path) {
        this.downloadId = id;
        this.connectionIndex = connectionIndex;
        this.paused = false;
        this.callback = callback;
        this.path = path;
        this.connectTask = connectTask;
        this.isWifiRequired = isWifiRequired;
    }

    public void pause() {
        this.paused = true;
        if (this.fetchDataTask != null) {
            this.fetchDataTask.pause();
        }
    }

    public void discard() {
        this.pause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        FileDownloadConnection connection = null;
        long beginOffset = this.connectTask.getProfile().currentOffset;
        boolean isConnected = false;
        while (true) {
            try {
                if (this.paused) {
                    return;
                }
                isConnected = false;
                connection = this.connectTask.connect();
                int code = connection.getResponseCode();
                if (FileDownloadLog.NEED_LOG) {
                    FileDownloadLog.d(this, "the connection[%d] for %d, is connected %s with code[%d]", this.connectionIndex, this.downloadId, this.connectTask.getProfile(), code);
                }
                if (code != 206 && code != 200) {
                    throw new SocketException(FileDownloadUtils.formatString("Connection failed with request[%s] response[%s] http-state[%d] on task[%d-%d], which is changed after verify connection, so please try again.", this.connectTask.getRequestHeader(), connection.getResponseHeaderFields(), code, this.downloadId, this.connectionIndex));
                }
                isConnected = true;
                FetchDataTask.Builder builder = new FetchDataTask.Builder();
                if (this.paused) {
                    return;
                }
                this.fetchDataTask = builder.setDownloadId(this.downloadId).setConnectionIndex(this.connectionIndex).setCallback(this.callback).setHost(this).setWifiRequired(this.isWifiRequired).setConnection(connection).setConnectionProfile(this.connectTask.getProfile()).setPath(this.path).build();
                this.fetchDataTask.run();
                if (!this.paused) break;
                this.fetchDataTask.pause();
            }
            catch (FileDownloadGiveUpRetryException | IOException | IllegalAccessException | IllegalArgumentException e) {
                if (this.callback.isRetry(e)) {
                    long downloadedOffset;
                    if (isConnected && this.fetchDataTask == null) {
                        FileDownloadLog.w(this, "it is valid to retry and connection is valid but create fetch-data-task failed, so give up directly with %s", e);
                        this.callback.onError(e);
                        break;
                    }
                    if (this.fetchDataTask != null && (downloadedOffset = this.getDownloadedOffset()) > 0L) {
                        this.connectTask.updateConnectionProfile(downloadedOffset);
                    }
                    this.callback.onRetry(e);
                    continue;
                }
                this.callback.onError(e);
            }
            finally {
                if (connection == null) continue;
                connection.ending();
                continue;
            }
            break;
        }
    }

    private long getDownloadedOffset() {
        FileDownloadDatabase database = CustomComponentHolder.getImpl().getDatabaseInstance();
        if (this.connectionIndex >= 0) {
            List<ConnectionModel> connectionModels = database.findConnectionModel(this.downloadId);
            for (ConnectionModel connectionModel : connectionModels) {
                if (connectionModel.getIndex() != this.connectionIndex) continue;
                return connectionModel.getCurrentOffset();
            }
        } else {
            FileDownloadModel downloadModel = database.find(this.downloadId);
            return downloadModel.getSoFar();
        }
        return 0L;
    }

    public static class Builder {
        private final ConnectTask.Builder connectTaskBuilder = new ConnectTask.Builder();
        private ProcessCallback callback;
        private String path;
        private Boolean isWifiRequired;
        private Integer connectionIndex;

        public Builder setCallback(ProcessCallback callback) {
            this.callback = callback;
            return this;
        }

        public Builder setId(int id) {
            this.connectTaskBuilder.setDownloadId(id);
            return this;
        }

        public Builder setUrl(String url) {
            this.connectTaskBuilder.setUrl(url);
            return this;
        }

        public Builder setEtag(String etag) {
            this.connectTaskBuilder.setEtag(etag);
            return this;
        }

        public Builder setHeader(FileDownloadHeader header) {
            this.connectTaskBuilder.setHeader(header);
            return this;
        }

        public Builder setConnectionModel(ConnectionProfile model) {
            this.connectTaskBuilder.setConnectionProfile(model);
            return this;
        }

        public Builder setPath(String path) {
            this.path = path;
            return this;
        }

        public Builder setWifiRequired(boolean wifiRequired) {
            this.isWifiRequired = wifiRequired;
            return this;
        }

        public Builder setConnectionIndex(Integer connectionIndex) {
            this.connectionIndex = connectionIndex;
            return this;
        }

        public DownloadRunnable build() {
            if (this.callback == null || this.path == null || this.isWifiRequired == null || this.connectionIndex == null) {
                throw new IllegalArgumentException(FileDownloadUtils.formatString("%s %s %B", this.callback, this.path, this.isWifiRequired));
            }
            ConnectTask connectTask = this.connectTaskBuilder.build();
            return new DownloadRunnable(connectTask.downloadId, this.connectionIndex, connectTask, this.callback, this.isWifiRequired, this.path);
        }

        DownloadRunnable buildForTest(ConnectTask connectTask) {
            return new DownloadRunnable(connectTask.downloadId, 0, connectTask, this.callback, false, "");
        }
    }
}

