/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader.database;

import android.util.SparseArray;
import com.liulishuo.filedownloader.database.FileDownloadDatabase;
import com.liulishuo.filedownloader.model.ConnectionModel;
import com.liulishuo.filedownloader.model.FileDownloadModel;
import com.liulishuo.filedownloader.util.FileDownloadHelper;
import com.liulishuo.filedownloader.util.FileDownloadLog;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NoDatabaseImpl
implements FileDownloadDatabase {
    final SparseArray<FileDownloadModel> downloaderModelMap = new SparseArray();
    final SparseArray<List<ConnectionModel>> connectionModelListMap = new SparseArray();

    public static Maker createMaker() {
        return new Maker();
    }

    @Override
    public void onTaskStart(int id) {
    }

    @Override
    public FileDownloadModel find(int id) {
        return (FileDownloadModel)this.downloaderModelMap.get(id);
    }

    @Override
    public List<ConnectionModel> findConnectionModel(int id) {
        ArrayList<ConnectionModel> resultList = new ArrayList<ConnectionModel>();
        List processList = (List)this.connectionModelListMap.get(id);
        if (processList != null) {
            resultList.addAll(processList);
        }
        return resultList;
    }

    @Override
    public void removeConnections(int id) {
        this.connectionModelListMap.remove(id);
    }

    @Override
    public void insertConnectionModel(ConnectionModel model) {
        int id = model.getId();
        ArrayList<ConnectionModel> processList = (ArrayList<ConnectionModel>)this.connectionModelListMap.get(id);
        if (processList == null) {
            processList = new ArrayList<ConnectionModel>();
            this.connectionModelListMap.put(id, processList);
        }
        processList.add(model);
    }

    @Override
    public void updateConnectionModel(int id, int index, long currentOffset) {
        List processList = (List)this.connectionModelListMap.get(id);
        if (processList == null) {
            return;
        }
        for (ConnectionModel connectionModel : processList) {
            if (connectionModel.getIndex() != index) continue;
            connectionModel.setCurrentOffset(currentOffset);
            return;
        }
    }

    @Override
    public void updateConnectionCount(int id, int count) {
    }

    @Override
    public void insert(FileDownloadModel downloadModel) {
        this.downloaderModelMap.put(downloadModel.getId(), (Object)downloadModel);
    }

    @Override
    public void update(FileDownloadModel downloadModel) {
        if (downloadModel == null) {
            FileDownloadLog.w(this, "update but model == null!", new Object[0]);
            return;
        }
        if (this.find(downloadModel.getId()) != null) {
            this.downloaderModelMap.remove(downloadModel.getId());
            this.downloaderModelMap.put(downloadModel.getId(), (Object)downloadModel);
        } else {
            this.insert(downloadModel);
        }
    }

    @Override
    public boolean remove(int id) {
        this.downloaderModelMap.remove(id);
        return true;
    }

    @Override
    public void clear() {
        this.downloaderModelMap.clear();
    }

    @Override
    public void updateOldEtagOverdue(int id, String newEtag, long sofar, long total, int connectionCount) {
    }

    @Override
    public void updateConnected(int id, long total, String etag, String filename) {
    }

    @Override
    public void updateProgress(int id, long sofarBytes) {
    }

    @Override
    public void updateError(int id, Throwable throwable, long sofar) {
    }

    @Override
    public void updateRetry(int id, Throwable throwable) {
    }

    @Override
    public void updateCompleted(int id, long total) {
        this.remove(id);
    }

    @Override
    public void updatePause(int id, long sofar) {
    }

    @Override
    public void updatePending(int id) {
    }

    @Override
    public FileDownloadDatabase.Maintainer maintainer() {
        return new Maintainer();
    }

    public static class Maker
    implements FileDownloadHelper.DatabaseCustomMaker {
        @Override
        public FileDownloadDatabase customMake() {
            return new NoDatabaseImpl();
        }
    }

    class MaintainerIterator
    implements Iterator<FileDownloadModel> {
        MaintainerIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public FileDownloadModel next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    class Maintainer
    implements FileDownloadDatabase.Maintainer {
        Maintainer() {
        }

        @Override
        public Iterator<FileDownloadModel> iterator() {
            return new MaintainerIterator();
        }

        @Override
        public void onFinishMaintain() {
        }

        @Override
        public void onRemovedInvalidData(FileDownloadModel model) {
        }

        @Override
        public void onRefreshedValidData(FileDownloadModel model) {
        }

        @Override
        public void changeFileDownloadModelId(int oldId, FileDownloadModel modelWithNewId) {
        }
    }
}

