/*
 * Decompiled with CFR 0.152.
 */
package com.liulishuo.filedownloader;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.liulishuo.filedownloader.BaseDownloadTask;
import com.liulishuo.filedownloader.DownloadTaskAdapter;
import com.liulishuo.filedownloader.FileDownloadList;
import com.liulishuo.filedownloader.exception.FileDownloadNetworkPolicyException;
import com.liulishuo.filedownloader.exception.FileDownloadOutOfSpaceException;
import com.liulishuo.filedownloader.exception.FileDownloadSecurityException;
import com.liulishuo.filedownloader.retry.RetryAssist;
import com.liulishuo.filedownloader.util.FileDownloadUtils;
import com.liulishuo.okdownload.DownloadTask;
import com.liulishuo.okdownload.core.Util;
import com.liulishuo.okdownload.core.cause.EndCause;
import com.liulishuo.okdownload.core.exception.DownloadSecurityException;
import com.liulishuo.okdownload.core.exception.NetworkPolicyException;
import com.liulishuo.okdownload.core.exception.PreAllocateException;
import java.util.concurrent.Executor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class CompatListenerAssist {
    private static final Executor EXECUTOR = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Util.threadFactory((String)"OkDownload Block Complete", (boolean)false));
    private static final String TAG = "CompatListenerAssist";
    @NonNull
    private final CompatListenerAssistCallback callback;
    @NonNull
    private final Handler uiHandler;
    private boolean resumable;
    private String etag;
    @NonNull
    final AtomicBoolean taskConnected;
    @Nullable
    private Exception exception;
    private boolean reuseOldFile;

    CompatListenerAssist(@NonNull CompatListenerAssistCallback callback) {
        this(callback, new Handler(Looper.getMainLooper()));
    }

    CompatListenerAssist(@NonNull CompatListenerAssistCallback callback, @NonNull Handler uiHandler) {
        this.callback = callback;
        this.taskConnected = new AtomicBoolean(false);
        this.uiHandler = uiHandler;
    }

    public void taskStart(@NonNull DownloadTask task) {
        DownloadTaskAdapter downloadTaskAdapter = FileDownloadUtils.findDownloadTaskAdapter(task);
        if (downloadTaskAdapter == null) {
            return;
        }
        long soFarBytes = downloadTaskAdapter.getSoFarBytesInLong();
        long totalBytes = downloadTaskAdapter.getTotalBytesInLong();
        this.callback.pending(downloadTaskAdapter, soFarBytes, totalBytes);
        this.callback.started(downloadTaskAdapter);
    }

    public void setResumable(boolean resumable) {
        this.resumable = resumable;
    }

    public boolean isResumable() {
        return this.resumable;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public String getEtag() {
        return this.etag;
    }

    public void connectStart(DownloadTask task) {
        if (this.taskConnected.compareAndSet(false, true)) {
            DownloadTaskAdapter downloadTaskAdapter = FileDownloadUtils.findDownloadTaskAdapter(task);
            if (downloadTaskAdapter == null) {
                return;
            }
            long soFarBytes = downloadTaskAdapter.getSoFarBytesInLong();
            long totalBytes = downloadTaskAdapter.getTotalBytesInLong();
            downloadTaskAdapter.getProgressAssist().initSofarBytes(soFarBytes);
            downloadTaskAdapter.getProgressAssist().calculateCallbackMinIntervalBytes(totalBytes);
            this.callback.connected(downloadTaskAdapter, this.etag, this.resumable, soFarBytes, totalBytes);
        }
    }

    public void fetchProgress(@NonNull DownloadTask task, long increaseBytes) {
        DownloadTaskAdapter downloadTaskAdapter = FileDownloadUtils.findDownloadTaskAdapter(task);
        if (downloadTaskAdapter == null) {
            return;
        }
        downloadTaskAdapter.getProgressAssist().onProgress(downloadTaskAdapter, increaseBytes, this.callback);
    }

    public void taskEnd(@NonNull DownloadTask task, @NonNull EndCause cause, @Nullable Exception realCause) {
        DownloadTaskAdapter downloadTaskAdapter = FileDownloadUtils.findDownloadTaskAdapter(task);
        if (downloadTaskAdapter == null) {
            return;
        }
        downloadTaskAdapter.getProgressAssist().clearProgress();
        this.exception = realCause;
        switch (cause) {
            case PRE_ALLOCATE_FAILED: 
            case ERROR: {
                this.handleError(downloadTaskAdapter, realCause);
                break;
            }
            case CANCELED: {
                this.handleCanceled(downloadTaskAdapter);
                break;
            }
            case FILE_BUSY: 
            case SAME_TASK_BUSY: {
                this.handleWarn(downloadTaskAdapter, cause, realCause);
                break;
            }
            case COMPLETED: {
                this.handleComplete(downloadTaskAdapter);
                break;
            }
        }
        this.onTaskFinish(downloadTaskAdapter);
    }

    void handleWarn(@NonNull DownloadTaskAdapter downloadTaskAdapter, EndCause cause, Exception realCause) {
        Util.w((String)TAG, (String)("handle warn, cause: " + cause + "real cause: " + realCause));
        this.callback.warn(downloadTaskAdapter);
    }

    void handleCanceled(@NonNull DownloadTaskAdapter downloadTaskAdapter) {
        this.callback.paused(downloadTaskAdapter, downloadTaskAdapter.getProgressAssist().getSofarBytes(), downloadTaskAdapter.getTotalBytesInLong());
    }

    void handleError(@NonNull DownloadTaskAdapter downloadTaskAdapter, @Nullable Exception realCause) {
        Throwable throwable;
        RetryAssist retryAssist = downloadTaskAdapter.getRetryAssist();
        if (retryAssist != null && retryAssist.canRetry()) {
            Log.d((String)TAG, (String)("handle retry " + Thread.currentThread().getName()));
            int retryingTime = retryAssist.getRetriedTimes() + 1;
            this.callback.retry(downloadTaskAdapter, realCause, retryingTime, downloadTaskAdapter.getProgressAssist().getSofarBytes());
            retryAssist.doRetry(downloadTaskAdapter.getDownloadTask());
            return;
        }
        Log.d((String)TAG, (String)"handle error");
        if (realCause instanceof NetworkPolicyException) {
            throwable = new FileDownloadNetworkPolicyException();
        } else if (realCause instanceof PreAllocateException) {
            PreAllocateException preAllocateException = (PreAllocateException)realCause;
            throwable = new FileDownloadOutOfSpaceException(preAllocateException.getFreeSpace(), preAllocateException.getRequireSpace(), downloadTaskAdapter.getProgressAssist().getSofarBytes(), (Throwable)preAllocateException);
        } else {
            throwable = realCause instanceof DownloadSecurityException ? new FileDownloadSecurityException(realCause.getMessage()) : new Throwable(realCause);
        }
        this.callback.error(downloadTaskAdapter, throwable);
    }

    void onTaskFinish(@NonNull DownloadTaskAdapter downloadTaskAdapter) {
        Util.d((String)TAG, (String)("on task finish, have finish listener: " + downloadTaskAdapter.isContainFinishListener()));
        for (BaseDownloadTask.FinishListener listener : downloadTaskAdapter.getFinishListeners()) {
            listener.over(downloadTaskAdapter);
        }
        FileDownloadList.getImpl().remove(downloadTaskAdapter);
    }

    void handleComplete(final @NonNull DownloadTaskAdapter downloadTaskAdapter) {
        boolean bl = this.reuseOldFile = !this.taskConnected.get();
        if (downloadTaskAdapter.getDownloadTask().isAutoCallbackToUIThread()) {
            EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    CompatListenerAssist.this.handleBlockComplete(downloadTaskAdapter);
                }
            });
        } else {
            try {
                this.callback.blockComplete(downloadTaskAdapter);
                this.callback.completed(downloadTaskAdapter);
            }
            catch (Throwable throwable) {
                this.handleError(downloadTaskAdapter, new Exception(throwable));
            }
        }
    }

    void handleBlockComplete(final @NonNull DownloadTaskAdapter downloadTaskAdapter) {
        try {
            this.callback.blockComplete(downloadTaskAdapter);
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    CompatListenerAssist.this.callback.completed(downloadTaskAdapter);
                }
            });
        }
        catch (Throwable throwable) {
            this.uiHandler.post(new Runnable(){

                @Override
                public void run() {
                    CompatListenerAssist.this.handleError(downloadTaskAdapter, new Exception(throwable));
                }
            });
        }
    }

    @Nullable
    public Exception getException() {
        return this.exception;
    }

    public boolean isReuseOldFile() {
        return this.reuseOldFile;
    }

    public static interface CompatListenerAssistCallback {
        public void pending(BaseDownloadTask var1, long var2, long var4);

        public void started(BaseDownloadTask var1);

        public void connected(BaseDownloadTask var1, String var2, boolean var3, long var4, long var6);

        public void progress(BaseDownloadTask var1, long var2, long var4);

        public void blockComplete(BaseDownloadTask var1) throws Throwable;

        public void retry(BaseDownloadTask var1, Throwable var2, int var3, long var4);

        public void completed(BaseDownloadTask var1);

        public void paused(BaseDownloadTask var1, long var2, long var4);

        public void error(BaseDownloadTask var1, Throwable var2);

        public void warn(BaseDownloadTask var1);
    }
}

